/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.oauth;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.oauth.jwt.Jwt;
import org.cloudfoundry.identity.uaa.oauth.jwt.JwtHelper;
import org.cloudfoundry.identity.uaa.oauth.token.RevocableToken;
import org.cloudfoundry.identity.uaa.oauth.token.RevocableTokenProvisioning;
import org.cloudfoundry.identity.uaa.scim.ScimUser;
import org.cloudfoundry.identity.uaa.scim.ScimUserProvisioning;
import org.cloudfoundry.identity.uaa.scim.exception.ScimResourceNotFoundException;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.cloudfoundry.identity.uaa.zone.MultitenantJdbcClientDetailsService;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.oauth2.common.exceptions.InsufficientScopeException;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.oauth2.common.util.RandomValueStringGenerator;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.NoSuchClientException;
import org.springframework.security.oauth2.provider.client.BaseClientDetails;
import org.springframework.security.oauth2.provider.error.DefaultWebResponseExceptionTranslator;
import org.springframework.security.oauth2.provider.error.WebResponseExceptionTranslator;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class TokenRevocationEndpoint {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private WebResponseExceptionTranslator exceptionTranslator = new DefaultWebResponseExceptionTranslator();
    private final ScimUserProvisioning userProvisioning;
    private final MultitenantJdbcClientDetailsService clientDetailsService;
    private final RandomValueStringGenerator generator = new RandomValueStringGenerator(8);
    private final RevocableTokenProvisioning tokenProvisioning;

    public TokenRevocationEndpoint(MultitenantJdbcClientDetailsService clientDetailsService, ScimUserProvisioning userProvisioning, RevocableTokenProvisioning tokenProvisioning) {
        this.clientDetailsService = clientDetailsService;
        this.userProvisioning = userProvisioning;
        this.tokenProvisioning = tokenProvisioning;
    }

    @RequestMapping(value={"/oauth/token/revoke/user/{userId}"})
    public ResponseEntity<Void> revokeTokensForUser(@PathVariable String userId) {
        this.logger.debug((Object)("Revoking tokens for user: " + userId));
        ScimUser user = (ScimUser)this.userProvisioning.retrieve(userId);
        user.setSalt(this.generator.generate());
        this.userProvisioning.update(userId, user);
        this.logger.debug((Object)("Tokens revoked for user: " + userId));
        return new ResponseEntity(HttpStatus.OK);
    }

    @RequestMapping(value={"/oauth/token/revoke/client/{clientId}"})
    public ResponseEntity<Void> revokeTokensForClient(@PathVariable String clientId) {
        this.logger.debug((Object)("Revoking tokens for client: " + clientId));
        BaseClientDetails client = (BaseClientDetails)this.clientDetailsService.loadClientByClientId(clientId);
        client.addAdditionalInformation("token_salt", (Object)this.generator.generate());
        this.clientDetailsService.updateClientDetails((ClientDetails)client);
        this.logger.debug((Object)("Tokens revoked for client: " + clientId));
        return new ResponseEntity(HttpStatus.OK);
    }

    @RequestMapping(value={"/oauth/token/revoke/{tokenId}"}, method={RequestMethod.DELETE})
    public ResponseEntity<Void> revokeTokenById(@PathVariable String tokenId, HttpServletRequest request) {
        this.logger.debug((Object)"Revoking token");
        String authorization = request.getHeader("Authorization");
        String requestToken = authorization.split(" ")[1];
        Jwt jwt = JwtHelper.decode(requestToken);
        Map claims = (Map)JsonUtils.readValue((String)jwt.getClaims(), (TypeReference)new TypeReference<Map<String, Object>>(){});
        RevocableToken token = (RevocableToken)this.tokenProvisioning.retrieve(tokenId);
        List scopes = (List)claims.get("scope");
        if (!scopes.contains("tokens.revoke") && !scopes.contains("uaa.admin")) {
            String userId = (String)claims.get("user_id");
            String clientId = (String)claims.get("client_id");
            if (StringUtils.hasText((String)userId)) {
                if (token.getUserId().equals(userId)) {
                    this.tokenProvisioning.delete(tokenId, -1);
                    this.logger.debug((Object)("Revoked user token with ID: " + tokenId));
                    return new ResponseEntity(HttpStatus.OK);
                }
            } else if (StringUtils.hasText((String)clientId) && token.getClientId().equals(clientId)) {
                this.tokenProvisioning.delete(tokenId, -1);
                this.logger.debug((Object)("Revoked client token with ID: " + tokenId));
                return new ResponseEntity(HttpStatus.OK);
            }
        } else {
            this.tokenProvisioning.delete(tokenId, -1);
            this.logger.debug((Object)("Revoked token with ID: " + tokenId));
            return new ResponseEntity(HttpStatus.OK);
        }
        throw new InsufficientScopeException("Cannot revoke others' tokens unless you have either `tokens.revoke` or `uaa.admin`");
    }

    @ExceptionHandler(value={ScimResourceNotFoundException.class, NoSuchClientException.class, EmptyResultDataAccessException.class})
    public ResponseEntity<OAuth2Exception> handleException(Exception e) throws Exception {
        this.logger.info((Object)("Handling error: " + e.getClass().getSimpleName() + ", " + e.getMessage()));
        InvalidTokenException e404 = new InvalidTokenException("Resource not found"){

            public int getHttpErrorCode() {
                return 404;
            }
        };
        return this.exceptionTranslator.translate((Exception)((Object)e404));
    }

    @ExceptionHandler(value={InsufficientScopeException.class})
    public ResponseEntity<InsufficientScopeException> handleInvalidClientDetails(InsufficientScopeException e) {
        return new ResponseEntity((Object)e, HttpStatus.FORBIDDEN);
    }
}

