/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider.saml.idp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.cloudfoundry.identity.uaa.authentication.UaaPrincipal;
import org.cloudfoundry.identity.uaa.provider.saml.idp.IdpWebSSOProfileOptions;
import org.cloudfoundry.identity.uaa.provider.saml.idp.IdpWebSsoProfile;
import org.joda.time.DateTime;
import org.opensaml.Configuration;
import org.opensaml.common.SAMLException;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.SAMLObjectBuilder;
import org.opensaml.common.SAMLVersion;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.core.AttributeStatement;
import org.opensaml.saml2.core.AttributeValue;
import org.opensaml.saml2.core.Audience;
import org.opensaml.saml2.core.AudienceRestriction;
import org.opensaml.saml2.core.AuthnContext;
import org.opensaml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.core.AuthnStatement;
import org.opensaml.saml2.core.Conditions;
import org.opensaml.saml2.core.NameID;
import org.opensaml.saml2.core.Response;
import org.opensaml.saml2.core.Status;
import org.opensaml.saml2.core.StatusCode;
import org.opensaml.saml2.core.Subject;
import org.opensaml.saml2.core.SubjectConfirmation;
import org.opensaml.saml2.core.SubjectConfirmationData;
import org.opensaml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml2.metadata.Endpoint;
import org.opensaml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.ws.message.encoder.MessageEncodingException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.XMLObjectBuilder;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.schema.XSString;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.SecurityHelper;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.SignatureException;
import org.opensaml.xml.signature.Signer;
import org.opensaml.xml.signature.impl.SignatureBuilder;
import org.opensaml.xml.signature.impl.SignatureImpl;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.saml.context.SAMLMessageContext;
import org.springframework.security.saml.websso.WebSSOProfileImpl;

public class IdpWebSsoProfileImpl
extends WebSSOProfileImpl
implements IdpWebSsoProfile {
    @Override
    public void sendResponse(Authentication authentication, SAMLMessageContext context, IdpWebSSOProfileOptions options) throws SAMLException, MetadataProviderException, MessageEncodingException, SecurityException, MarshallingException, SignatureException {
        this.buildResponse(authentication, context, options);
        this.sendMessage(context, false);
    }

    protected void buildResponse(Authentication authentication, SAMLMessageContext context, IdpWebSSOProfileOptions options) throws MetadataProviderException, SecurityException, MarshallingException, SignatureException {
        IDPSSODescriptor idpDescriptor = (IDPSSODescriptor)context.getLocalEntityRoleMetadata();
        SPSSODescriptor spDescriptor = (SPSSODescriptor)context.getPeerEntityRoleMetadata();
        AuthnRequest authnRequest = (AuthnRequest)context.getInboundSAMLMessage();
        AssertionConsumerService assertionConsumerService = this.getAssertionConsumerService(options, idpDescriptor, spDescriptor);
        context.setPeerEntityEndpoint((Endpoint)assertionConsumerService);
        Assertion assertion = this.buildAssertion(authentication, authnRequest, options, context.getPeerEntityId(), context.getLocalEntityId());
        if (options.isAssertionsSigned() || spDescriptor.getWantAssertionsSigned().booleanValue()) {
            this.signAssertion(assertion, context.getLocalSigningCredential());
        }
        Response samlResponse = this.createResponse(context, assertionConsumerService, assertion);
        context.setOutboundMessage((XMLObject)samlResponse);
        context.setOutboundSAMLMessage((SAMLObject)samlResponse);
    }

    private Response createResponse(SAMLMessageContext context, AssertionConsumerService assertionConsumerService, Assertion assertion) {
        SAMLObjectBuilder responseBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(Response.DEFAULT_ELEMENT_NAME);
        Response response = (Response)responseBuilder.buildObject();
        this.buildCommonAttributes(context.getLocalEntityId(), response, (Endpoint)assertionConsumerService);
        response.getAssertions().add(assertion);
        this.buildStatusSuccess(response);
        return response;
    }

    private void buildCommonAttributes(String localEntityId, Response response, Endpoint service) {
        response.setID(this.generateID());
        response.setIssuer(this.getIssuer(localEntityId));
        response.setVersion(SAMLVersion.VERSION_20);
        response.setIssueInstant(new DateTime());
        if (service != null) {
            response.setDestination(service.getLocation());
        }
    }

    private Assertion buildAssertion(Authentication authentication, AuthnRequest authnRequest, IdpWebSSOProfileOptions options, String audienceURI, String issuerEntityId) {
        SAMLObjectBuilder assertionBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(Assertion.DEFAULT_ELEMENT_NAME);
        Assertion assertion = (Assertion)assertionBuilder.buildObject();
        assertion.setID(this.generateID());
        assertion.setIssueInstant(new DateTime());
        assertion.setVersion(SAMLVersion.VERSION_20);
        assertion.setIssuer(this.getIssuer(issuerEntityId));
        this.buildAssertionAuthnStatement(assertion);
        this.buildAssertionConditions(assertion, options.getAssertionTimeToLiveSeconds(), audienceURI);
        this.buildAssertionSubject(assertion, authnRequest, options.getAssertionTimeToLiveSeconds(), authentication.getName());
        this.buildAttributeStatement(assertion, authentication);
        return assertion;
    }

    private void buildAssertionAuthnStatement(Assertion assertion) {
        SAMLObjectBuilder authnStatementBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(AuthnStatement.DEFAULT_ELEMENT_NAME);
        AuthnStatement authnStatement = (AuthnStatement)authnStatementBuilder.buildObject();
        authnStatement.setAuthnInstant(new DateTime());
        authnStatement.setSessionIndex(this.generateID());
        SAMLObjectBuilder authnContextBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(AuthnContext.DEFAULT_ELEMENT_NAME);
        AuthnContext authnContext = (AuthnContext)authnContextBuilder.buildObject();
        SAMLObjectBuilder authnContextClassRefBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(AuthnContextClassRef.DEFAULT_ELEMENT_NAME);
        AuthnContextClassRef authnContextClassRef = (AuthnContextClassRef)authnContextClassRefBuilder.buildObject();
        authnContextClassRef.setAuthnContextClassRef("urn:oasis:names:tc:SAML:2.0:ac:classes:Password");
        authnContext.setAuthnContextClassRef(authnContextClassRef);
        authnStatement.setAuthnContext(authnContext);
        assertion.getAuthnStatements().add(authnStatement);
    }

    private void buildAssertionConditions(Assertion assertion, int assertionTtlSeconds, String audienceURI) {
        SAMLObjectBuilder conditionsBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(Conditions.DEFAULT_ELEMENT_NAME);
        Conditions conditions = (Conditions)conditionsBuilder.buildObject();
        conditions.setNotBefore(new DateTime());
        conditions.setNotOnOrAfter(new DateTime().plusSeconds(assertionTtlSeconds));
        SAMLObjectBuilder audienceRestrictionBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(AudienceRestriction.DEFAULT_ELEMENT_NAME);
        AudienceRestriction audienceRestriction = (AudienceRestriction)audienceRestrictionBuilder.buildObject();
        SAMLObjectBuilder audienceBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(Audience.DEFAULT_ELEMENT_NAME);
        Audience audience = (Audience)audienceBuilder.buildObject();
        audience.setAudienceURI(audienceURI);
        audienceRestriction.getAudiences().add(audience);
        conditions.getAudienceRestrictions().add(audienceRestriction);
        assertion.setConditions(conditions);
    }

    private void buildAssertionSubject(Assertion assertion, AuthnRequest authnRequest, int assertionTtlSeconds, String nameIdStr) {
        SAMLObjectBuilder subjectBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(Subject.DEFAULT_ELEMENT_NAME);
        Subject subject = (Subject)subjectBuilder.buildObject();
        SAMLObjectBuilder nameIdBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(NameID.DEFAULT_ELEMENT_NAME);
        NameID nameId = (NameID)nameIdBuilder.buildObject();
        nameId.setValue(nameIdStr);
        nameId.setFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
        subject.setNameID(nameId);
        SAMLObjectBuilder subjectConfirmationBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(SubjectConfirmation.DEFAULT_ELEMENT_NAME);
        SubjectConfirmation subjectConfirmation = (SubjectConfirmation)subjectConfirmationBuilder.buildObject();
        subjectConfirmation.setMethod("urn:oasis:names:tc:SAML:2.0:cm:bearer");
        SAMLObjectBuilder subjectConfirmationDataBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(SubjectConfirmationData.DEFAULT_ELEMENT_NAME);
        SubjectConfirmationData subjectConfirmationData = (SubjectConfirmationData)subjectConfirmationDataBuilder.buildObject();
        subjectConfirmationData.setNotOnOrAfter(new DateTime().plusSeconds(assertionTtlSeconds));
        subjectConfirmationData.setInResponseTo(authnRequest.getID());
        subjectConfirmationData.setRecipient(authnRequest.getAssertionConsumerServiceURL());
        subjectConfirmation.setSubjectConfirmationData(subjectConfirmationData);
        subject.getSubjectConfirmations().add(subjectConfirmation);
        assertion.setSubject(subject);
    }

    private void buildAttributeStatement(Assertion assertion, Authentication authentication) {
        SAMLObjectBuilder attributeStatementBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(AttributeStatement.DEFAULT_ELEMENT_NAME);
        AttributeStatement attributeStatement = (AttributeStatement)attributeStatementBuilder.buildObject();
        ArrayList<String> authorities = new ArrayList<String>();
        for (GrantedAuthority authority : authentication.getAuthorities()) {
            authorities.add(authority.getAuthority());
        }
        Attribute authoritiesAttribute = this.buildStringAttribute("authorities", authorities);
        attributeStatement.getAttributes().add(authoritiesAttribute);
        UaaPrincipal principal = (UaaPrincipal)authentication.getPrincipal();
        Attribute emailAttribute = this.buildStringAttribute("email", Arrays.asList(principal.getEmail()));
        attributeStatement.getAttributes().add(emailAttribute);
        Attribute idAttribute = this.buildStringAttribute("id", Arrays.asList(principal.getId()));
        attributeStatement.getAttributes().add(idAttribute);
        Attribute nameAttribute = this.buildStringAttribute("name", Arrays.asList(principal.getName()));
        attributeStatement.getAttributes().add(nameAttribute);
        Attribute originAttribute = this.buildStringAttribute("origin", Arrays.asList(principal.getOrigin()));
        attributeStatement.getAttributes().add(originAttribute);
        Attribute zoneAttribute = this.buildStringAttribute("zoneId", Arrays.asList(principal.getZoneId()));
        attributeStatement.getAttributes().add(zoneAttribute);
        assertion.getAttributeStatements().add(attributeStatement);
    }

    public Attribute buildStringAttribute(String name, List<String> values) {
        SAMLObjectBuilder attributeBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(Attribute.DEFAULT_ELEMENT_NAME);
        Attribute attribute = (Attribute)attributeBuilder.buildObject();
        attribute.setName(name);
        XMLObjectBuilder xsStringBuilder = this.builderFactory.getBuilder(XSString.TYPE_NAME);
        for (String value : values) {
            XSString attributeValue = (XSString)xsStringBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME, XSString.TYPE_NAME);
            attributeValue.setValue(value);
            attribute.getAttributeValues().add(attributeValue);
        }
        return attribute;
    }

    private void buildStatusSuccess(Response response) {
        this.buildStatus(response, "urn:oasis:names:tc:SAML:2.0:status:Success");
    }

    private void buildStatus(Response response, String statusCodeStr) {
        SAMLObjectBuilder statusCodeBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(StatusCode.DEFAULT_ELEMENT_NAME);
        StatusCode statusCode = (StatusCode)statusCodeBuilder.buildObject();
        statusCode.setValue(statusCodeStr);
        SAMLObjectBuilder statusBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(Status.DEFAULT_ELEMENT_NAME);
        Status status = (Status)statusBuilder.buildObject();
        status.setStatusCode(statusCode);
        response.setStatus(status);
    }

    private void signAssertion(Assertion assertion, Credential credential) throws SecurityException, MarshallingException, SignatureException {
        SignatureBuilder signatureBuilder = (SignatureBuilder)this.builderFactory.getBuilder(Signature.DEFAULT_ELEMENT_NAME);
        SignatureImpl signature = signatureBuilder.buildObject();
        signature.setSigningCredential(credential);
        SecurityHelper.prepareSignatureParams((Signature)signature, (Credential)credential, null, null);
        assertion.setSignature((Signature)signature);
        Marshaller marshaller = Configuration.getMarshallerFactory().getMarshaller((XMLObject)assertion);
        marshaller.marshall((XMLObject)assertion);
        Signer.signObject((Signature)signature);
    }
}

