/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider.saml.idp;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.provider.JdbcIdentityProviderProvisioning;
import org.cloudfoundry.identity.uaa.provider.saml.idp.SamlServiceProvider;
import org.cloudfoundry.identity.uaa.provider.saml.idp.SamlServiceProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.saml.idp.SamlServiceProviderDeletable;
import org.cloudfoundry.identity.uaa.provider.saml.idp.SamlServiceProviderProvisioning;
import org.cloudfoundry.identity.uaa.provider.saml.idp.SamlSpAlreadyExistsException;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class JdbcSamlServiceProviderProvisioning
implements SamlServiceProviderProvisioning,
SamlServiceProviderDeletable {
    private static final Log LOGGER = LogFactory.getLog(JdbcIdentityProviderProvisioning.class);
    public static final String SERVICE_PROVIDER_FIELDS = "id,version,created,lastmodified,name,entity_id,config,identity_zone_id,active";
    public static final String CREATE_SERVICE_PROVIDER_SQL = "insert into service_provider(id,version,created,lastmodified,name,entity_id,config,identity_zone_id,active) values (?,?,?,?,?,?,?,?,?)";
    public static final String DELETE_SERVICE_PROVIDER_SQL = "delete from service_provider where id=? and identity_zone_id=?";
    public static final String DELETE_SERVICE_PROVIDER_BY_ENTITY_ID_SQL = "delete from service_provider where entity_id = ? and identity_zone_id=?";
    public static final String DELETE_SERVICE_PROVIDER_BY_ZONE_SQL = "delete from service_provider where identity_zone_id=?";
    public static final String SERVICE_PROVIDERS_QUERY = "select id,version,created,lastmodified,name,entity_id,config,identity_zone_id,active from service_provider where identity_zone_id=?";
    public static final String ACTIVE_SERVICE_PROVIDERS_QUERY = "select id,version,created,lastmodified,name,entity_id,config,identity_zone_id,active from service_provider where identity_zone_id=? and active";
    public static final String SERVICE_PROVIDER_UPDATE_FIELDS = "version,lastmodified,name,config,active".replace(",", "=?,") + "=?";
    public static final String UPDATE_SERVICE_PROVIDER_SQL = "update service_provider set " + SERVICE_PROVIDER_UPDATE_FIELDS + " where id=? and identity_zone_id=?";
    public static final String SERVICE_PROVIDER_BY_ID_QUERY = "select id,version,created,lastmodified,name,entity_id,config,identity_zone_id,active from service_provider where id=? and identity_zone_id=?";
    public static final String SERVICE_PROVIDER_BY_ENTITY_ID_QUERY = "select id,version,created,lastmodified,name,entity_id,config,identity_zone_id,active from service_provider where entity_id=? and identity_zone_id=? ";
    protected final JdbcTemplate jdbcTemplate;
    private final RowMapper<SamlServiceProvider> mapper = new SamlServiceProviderRowMapper();

    public JdbcSamlServiceProviderProvisioning(JdbcTemplate jdbcTemplate) {
        Assert.notNull((Object)jdbcTemplate);
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    public SamlServiceProvider retrieve(String id) {
        SamlServiceProvider serviceProvider = (SamlServiceProvider)this.jdbcTemplate.queryForObject(SERVICE_PROVIDER_BY_ID_QUERY, this.mapper, new Object[]{id, IdentityZoneHolder.get().getId()});
        return serviceProvider;
    }

    @Override
    public void delete(String id) {
        this.jdbcTemplate.update(DELETE_SERVICE_PROVIDER_SQL, new Object[]{id, IdentityZoneHolder.get().getId()});
    }

    @Override
    public int deleteByEntityId(String entityId, String zoneId) {
        return this.jdbcTemplate.update(DELETE_SERVICE_PROVIDER_BY_ENTITY_ID_SQL, new Object[]{entityId, zoneId});
    }

    @Override
    public int deleteByIdentityZone(String zoneId) {
        return this.jdbcTemplate.update(DELETE_SERVICE_PROVIDER_BY_ZONE_SQL, new Object[]{zoneId});
    }

    @Override
    public List<SamlServiceProvider> retrieveActive(String zoneId) {
        return this.jdbcTemplate.query(ACTIVE_SERVICE_PROVIDERS_QUERY, this.mapper, new Object[]{zoneId});
    }

    @Override
    public List<SamlServiceProvider> retrieveAll(boolean activeOnly, String zoneId) {
        if (activeOnly) {
            return this.retrieveActive(zoneId);
        }
        return this.jdbcTemplate.query(SERVICE_PROVIDERS_QUERY, this.mapper, new Object[]{zoneId});
    }

    @Override
    public SamlServiceProvider retrieveByEntityId(String entityId, String zoneId) {
        SamlServiceProvider serviceProvider = (SamlServiceProvider)this.jdbcTemplate.queryForObject(SERVICE_PROVIDER_BY_ENTITY_ID_QUERY, this.mapper, new Object[]{entityId, zoneId});
        return serviceProvider;
    }

    @Override
    public SamlServiceProvider create(final SamlServiceProvider serviceProvider) {
        this.validate(serviceProvider);
        final String id = UUID.randomUUID().toString();
        try {
            this.jdbcTemplate.update(CREATE_SERVICE_PROVIDER_SQL, new PreparedStatementSetter(){

                public void setValues(PreparedStatement ps) throws SQLException {
                    int pos = 1;
                    ps.setString(pos++, id);
                    ps.setInt(pos++, serviceProvider.getVersion());
                    ps.setTimestamp(pos++, new Timestamp(System.currentTimeMillis()));
                    ps.setTimestamp(pos++, new Timestamp(System.currentTimeMillis()));
                    ps.setString(pos++, serviceProvider.getName());
                    ps.setString(pos++, serviceProvider.getEntityId());
                    ps.setString(pos++, JsonUtils.writeValueAsString((Object)serviceProvider.getConfig()));
                    ps.setString(pos++, serviceProvider.getIdentityZoneId());
                    ps.setBoolean(pos++, serviceProvider.isActive());
                }
            });
        }
        catch (DuplicateKeyException e) {
            throw new SamlSpAlreadyExistsException(e.getMostSpecificCause().getMessage());
        }
        return this.retrieve(id);
    }

    @Override
    public SamlServiceProvider update(final SamlServiceProvider serviceProvider) {
        this.validate(serviceProvider);
        final String zoneId = IdentityZoneHolder.get().getId();
        this.jdbcTemplate.update(UPDATE_SERVICE_PROVIDER_SQL, new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                int pos = 1;
                ps.setInt(pos++, serviceProvider.getVersion() + 1);
                ps.setTimestamp(pos++, new Timestamp(new Date().getTime()));
                ps.setString(pos++, serviceProvider.getName());
                ps.setString(pos++, JsonUtils.writeValueAsString((Object)serviceProvider.getConfig()));
                ps.setBoolean(pos++, serviceProvider.isActive());
                ps.setString(pos++, serviceProvider.getId().trim());
                ps.setString(pos++, zoneId);
            }
        });
        return this.retrieve(serviceProvider.getId());
    }

    protected void validate(SamlServiceProvider provider) {
        if (provider == null) {
            throw new NullPointerException("SAML Service Provider can not be null.");
        }
        if (!StringUtils.hasText((String)provider.getIdentityZoneId())) {
            throw new DataIntegrityViolationException("Identity zone ID must be set.");
        }
    }

    @Override
    public Log getLogger() {
        return LOGGER;
    }

    private static final class SamlServiceProviderRowMapper
    implements RowMapper<SamlServiceProvider> {
        public SamlServiceProvider mapRow(ResultSet rs, int rowNum) throws SQLException {
            SamlServiceProvider samlServiceProvider = new SamlServiceProvider();
            int pos = 1;
            samlServiceProvider.setId(rs.getString(pos++).trim());
            samlServiceProvider.setVersion(rs.getInt(pos++));
            samlServiceProvider.setCreated((Date)rs.getTimestamp(pos++));
            samlServiceProvider.setLastModified((Date)rs.getTimestamp(pos++));
            samlServiceProvider.setName(rs.getString(pos++));
            samlServiceProvider.setEntityId(rs.getString(pos++));
            String config = rs.getString(pos++);
            SamlServiceProviderDefinition definition = (SamlServiceProviderDefinition)JsonUtils.readValue((String)config, SamlServiceProviderDefinition.class);
            samlServiceProvider.setConfig(definition);
            samlServiceProvider.setIdentityZoneId(rs.getString(pos++));
            samlServiceProvider.setActive(rs.getBoolean(pos++));
            return samlServiceProvider;
        }
    }
}

