/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.security;

import javax.servlet.http.HttpServletRequest;
import org.cloudfoundry.identity.uaa.authentication.UaaPrincipal;
import org.cloudfoundry.identity.uaa.util.UaaUrlUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.util.StringUtils;

public class IsUserSelfCheck {
    public boolean isSelf(HttpServletRequest request, int pathParameterIndex) {
        String pathInfo = UaaUrlUtils.getRequestPath(request);
        if (!StringUtils.hasText((String)pathInfo)) {
            return false;
        }
        String idFromUrl = this.extractIdFromUrl(pathParameterIndex, pathInfo);
        if (idFromUrl == null) {
            return false;
        }
        String idFromAuth = this.extractIdFromAuthentication(SecurityContextHolder.getContext().getAuthentication());
        if (idFromAuth == null) {
            return false;
        }
        return idFromAuth.equals(idFromUrl);
    }

    protected String extractIdFromAuthentication(Authentication authentication) {
        if (authentication == null) {
            return null;
        }
        if (authentication.getPrincipal() instanceof UaaPrincipal) {
            return ((UaaPrincipal)authentication.getPrincipal()).getId();
        }
        if (authentication instanceof OAuth2Authentication) {
            OAuth2Authentication a = (OAuth2Authentication)authentication;
            if (a.isClientOnly()) {
                return null;
            }
            if (a.getUserAuthentication().getPrincipal() instanceof UaaPrincipal) {
                return ((UaaPrincipal)a.getUserAuthentication().getPrincipal()).getId();
            }
        }
        return null;
    }

    protected String extractIdFromUrl(int pathParameterIndex, String pathInfo) {
        return UaaUrlUtils.extractPathVariableFromUrl(pathParameterIndex, pathInfo);
    }
}

