/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.KeyPair;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.bouncycastle.openssl.PEMReader;

public class KeyWithCert {
    private X509Certificate cert;
    private KeyPair pkey;

    public KeyWithCert(String key, String passphrase, String certificate) throws CertificateException {
        PEMReader reader;
        if (passphrase == null) {
            passphrase = "";
        }
        try {
            reader = new PEMReader((Reader)new InputStreamReader(new ByteArrayInputStream(key.getBytes())), passphrase::toCharArray);
            this.pkey = (KeyPair)reader.readObject();
            if (this.pkey == null) {
                throw new CertificateException("Failed to read private key. The security provider could not parse it.");
            }
        }
        catch (IOException ex) {
            throw new CertificateException("Failed to read private key.", ex);
        }
        try {
            reader = new PEMReader((Reader)new InputStreamReader(new ByteArrayInputStream(certificate.getBytes())));
            this.cert = (X509Certificate)reader.readObject();
            if (this.cert == null) {
                throw new CertificateException("Failed to read certificate. The security provider could not parse it.");
            }
        }
        catch (IOException ex) {
            throw new CertificateException("Failed to read certificate.", ex);
        }
        if (!this.cert.getPublicKey().equals(this.pkey.getPublic())) {
            throw new CertificateException("Certificate does not match private key.");
        }
    }

    public X509Certificate getCert() {
        return this.cert;
    }

    public KeyPair getPkey() {
        return this.pkey;
    }
}

