/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.approval.ApprovalStore;
import org.cloudfoundry.identity.uaa.authentication.UaaAuthenticationDetails;
import org.cloudfoundry.identity.uaa.client.ClientAdminEndpointsValidator;
import org.cloudfoundry.identity.uaa.client.ClientDetailsValidator;
import org.cloudfoundry.identity.uaa.client.InvalidClientDetailsException;
import org.cloudfoundry.identity.uaa.client.RestrictUaaScopesClientValidator;
import org.cloudfoundry.identity.uaa.error.UaaException;
import org.cloudfoundry.identity.uaa.oauth.client.ClientDetailsModification;
import org.cloudfoundry.identity.uaa.oauth.client.SecretChangeRequest;
import org.cloudfoundry.identity.uaa.resources.ActionResult;
import org.cloudfoundry.identity.uaa.resources.AttributeNameMapper;
import org.cloudfoundry.identity.uaa.resources.QueryableResourceManager;
import org.cloudfoundry.identity.uaa.resources.ResourceMonitor;
import org.cloudfoundry.identity.uaa.resources.SearchResults;
import org.cloudfoundry.identity.uaa.resources.SearchResultsFactory;
import org.cloudfoundry.identity.uaa.resources.SimpleAttributeNameMapper;
import org.cloudfoundry.identity.uaa.security.DefaultSecurityContextAccessor;
import org.cloudfoundry.identity.uaa.security.SecurityContextAccessor;
import org.cloudfoundry.identity.uaa.util.UaaPagingUtils;
import org.cloudfoundry.identity.uaa.util.UaaStringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelParseException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.jmx.export.annotation.ManagedMetric;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.jmx.support.MetricType;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.common.exceptions.BadClientCredentialsException;
import org.springframework.security.oauth2.common.exceptions.InvalidClientException;
import org.springframework.security.oauth2.provider.ClientAlreadyExistsException;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientRegistrationService;
import org.springframework.security.oauth2.provider.NoSuchClientException;
import org.springframework.security.oauth2.provider.client.BaseClientDetails;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Controller
@ManagedResource
public class ClientAdminEndpoints
implements InitializingBean {
    private static final String SCIM_CLIENTS_SCHEMA_URI = "http://cloudfoundry.org/schema/scim/oauth-clients-1.0";
    private final Log logger = LogFactory.getLog(this.getClass());
    private ClientRegistrationService clientRegistrationService;
    private QueryableResourceManager<ClientDetails> clientDetailsService;
    private ResourceMonitor<ClientDetails> clientDetailsResourceMonitor;
    private AttributeNameMapper attributeNameMapper = new SimpleAttributeNameMapper(Collections.emptyMap());
    private SecurityContextAccessor securityContextAccessor = new DefaultSecurityContextAccessor();
    private final Map<String, AtomicInteger> errorCounts = new ConcurrentHashMap<String, AtomicInteger>();
    private AtomicInteger clientUpdates = new AtomicInteger();
    private AtomicInteger clientDeletes = new AtomicInteger();
    private AtomicInteger clientSecretChanges = new AtomicInteger();
    private ClientDetailsValidator clientDetailsValidator;
    private ClientDetailsValidator restrictedScopesValidator;
    private ApprovalStore approvalStore;
    private AuthenticationManager authenticationManager;

    public ClientDetailsValidator getRestrictedScopesValidator() {
        return this.restrictedScopesValidator;
    }

    public void setRestrictedScopesValidator(ClientDetailsValidator restrictedScopesValidator) {
        this.restrictedScopesValidator = restrictedScopesValidator;
    }

    public ApprovalStore getApprovalStore() {
        return this.approvalStore;
    }

    public void setApprovalStore(ApprovalStore approvalStore) {
        this.approvalStore = approvalStore;
    }

    public AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void setAttributeNameMapper(AttributeNameMapper attributeNameMapper) {
        this.attributeNameMapper = attributeNameMapper;
    }

    public void setClientRegistrationService(ClientRegistrationService clientRegistrationService) {
        this.clientRegistrationService = clientRegistrationService;
    }

    public void setClientDetailsService(QueryableResourceManager<ClientDetails> clientDetailsService) {
        this.clientDetailsService = clientDetailsService;
    }

    public void setSecurityContextAccessor(SecurityContextAccessor securityContextAccessor) {
        this.securityContextAccessor = securityContextAccessor;
    }

    @ManagedMetric(metricType=MetricType.COUNTER, displayName="Client Registration Count")
    public int getTotalClients() {
        return this.clientDetailsResourceMonitor.getTotalCount();
    }

    @ManagedMetric(metricType=MetricType.COUNTER, displayName="Client Update Count (Since Startup)")
    public int getClientUpdates() {
        return this.clientUpdates.get();
    }

    @ManagedMetric(metricType=MetricType.COUNTER, displayName="Client Delete Count (Since Startup)")
    public int getClientDeletes() {
        return this.clientDeletes.get();
    }

    @ManagedMetric(metricType=MetricType.COUNTER, displayName="Client Secret Change Count (Since Startup)")
    public int getClientSecretChanges() {
        return this.clientSecretChanges.get();
    }

    @ManagedMetric(displayName="Errors Since Startup")
    public Map<String, AtomicInteger> getErrorCounts() {
        return this.errorCounts;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.clientRegistrationService != null ? 1 : 0) != 0, (String)"A ClientRegistrationService must be provided");
        Assert.state((this.clientDetailsService != null ? 1 : 0) != 0, (String)"A ClientDetailsService must be provided");
        Assert.state((this.clientDetailsValidator != null ? 1 : 0) != 0, (String)"A ClientDetailsValidator must be provided");
    }

    @RequestMapping(value={"/oauth/clients/{client}"}, method={RequestMethod.GET})
    @ResponseBody
    public ClientDetails getClientDetails(@PathVariable String client) throws Exception {
        try {
            return this.removeSecret((ClientDetails)this.clientDetailsService.retrieve(client));
        }
        catch (InvalidClientException e) {
            throw new NoSuchClientException("No such client: " + client);
        }
        catch (BadClientCredentialsException e) {
            throw new NoSuchClientException("No such client: " + client);
        }
    }

    @RequestMapping(value={"/oauth/clients"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public ClientDetails createClientDetails(@RequestBody BaseClientDetails client) throws Exception {
        ClientDetails details = this.clientDetailsValidator.validate((ClientDetails)client, ClientDetailsValidator.Mode.CREATE);
        this.clientRegistrationService.addClientDetails(details);
        return this.removeSecret((ClientDetails)this.clientDetailsService.retrieve(client.getClientId()));
    }

    @RequestMapping(value={"/oauth/clients/restricted"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public List<String> getRestrictedClientScopes() throws Exception {
        if (this.restrictedScopesValidator instanceof RestrictUaaScopesClientValidator) {
            return ((RestrictUaaScopesClientValidator)this.restrictedScopesValidator).getUaaScopes().getUaaScopes();
        }
        return null;
    }

    @RequestMapping(value={"/oauth/clients/restricted"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public ClientDetails createRestrictedClientDetails(@RequestBody BaseClientDetails client) throws Exception {
        this.getRestrictedScopesValidator().validate((ClientDetails)client, ClientDetailsValidator.Mode.CREATE);
        return this.createClientDetails(client);
    }

    @RequestMapping(value={"/oauth/clients/tx"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    @Transactional
    public ClientDetails[] createClientDetailsTx(@RequestBody ClientDetailsModification[] clients) throws Exception {
        if (clients == null || clients.length == 0) {
            throw new NoSuchClientException("Message body does not contain any clients.");
        }
        ClientDetails[] results = new ClientDetails[clients.length];
        for (int i = 0; i < clients.length; ++i) {
            results[i] = this.clientDetailsValidator.validate((ClientDetails)clients[i], ClientDetailsValidator.Mode.CREATE);
        }
        return this.doInsertClientDetails(results);
    }

    protected ClientDetails[] doInsertClientDetails(ClientDetails[] details) {
        for (int i = 0; i < details.length; ++i) {
            this.clientRegistrationService.addClientDetails(details[i]);
            details[i] = this.removeSecret(details[i]);
        }
        return details;
    }

    @RequestMapping(value={"/oauth/clients/tx"}, method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.OK)
    @Transactional
    @ResponseBody
    public ClientDetailsModification[] updateClientDetailsTx(@RequestBody ClientDetailsModification[] clients) throws Exception {
        if (clients == null || clients.length == 0) {
            throw new InvalidClientDetailsException("No clients specified for update.");
        }
        ClientDetailsModification[] details = new ClientDetailsModification[clients.length];
        for (int i = 0; i < clients.length; ++i) {
            ClientDetailsModification client = clients[i];
            ClientDetails existing = this.getClientDetails(client.getClientId());
            if (existing == null) {
                throw new NoSuchClientException("Client " + client.getClientId() + " does not exist");
            }
            details[i] = this.syncWithExisting(existing, (ClientDetails)client);
            details[i] = new ClientDetailsModification(this.clientDetailsValidator.validate((ClientDetails)details[i], ClientDetailsValidator.Mode.MODIFY));
        }
        return this.doProcessUpdates(details);
    }

    protected ClientDetailsModification[] doProcessUpdates(ClientDetailsModification[] details) {
        ClientDetailsModification[] result = new ClientDetailsModification[details.length];
        for (int i = 0; i < result.length; ++i) {
            this.clientRegistrationService.updateClientDetails((ClientDetails)details[i]);
            this.clientUpdates.incrementAndGet();
            result[i] = this.removeSecret((ClientDetails)details[i]);
        }
        return result;
    }

    @RequestMapping(value={"/oauth/clients/restricted/{client}"}, method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public ClientDetails updateRestrictedClientDetails(@RequestBody BaseClientDetails client, @PathVariable(value="client") String clientId) throws Exception {
        this.getRestrictedScopesValidator().validate((ClientDetails)client, ClientDetailsValidator.Mode.MODIFY);
        return this.updateClientDetails(client, clientId);
    }

    @RequestMapping(value={"/oauth/clients/{client}"}, method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public ClientDetails updateClientDetails(@RequestBody BaseClientDetails client, @PathVariable(value="client") String clientId) throws Exception {
        Assert.state((boolean)clientId.equals(client.getClientId()), (String)String.format("The client id (%s) does not match the URL (%s)", client.getClientId(), clientId));
        BaseClientDetails details = client;
        try {
            ClientDetails existing = this.getClientDetails(clientId);
            if (existing == null) {
                this.logger.warn((Object)("Couldn't fetch client config, null, for client_id: " + clientId));
            } else {
                details = this.syncWithExisting(existing, (ClientDetails)client);
            }
        }
        catch (Exception e) {
            this.logger.warn((Object)("Couldn't fetch client config for client_id: " + clientId), (Throwable)e);
        }
        details = this.clientDetailsValidator.validate((ClientDetails)details, ClientDetailsValidator.Mode.MODIFY);
        this.clientRegistrationService.updateClientDetails((ClientDetails)details);
        this.clientUpdates.incrementAndGet();
        return this.removeSecret((ClientDetails)this.clientDetailsService.retrieve(clientId));
    }

    @RequestMapping(value={"/oauth/clients/{client}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public ClientDetails removeClientDetails(@PathVariable String client) throws Exception {
        ClientDetails details = (ClientDetails)this.clientDetailsService.retrieve(client);
        this.doProcessDeletes(new ClientDetails[]{details});
        return this.removeSecret(details);
    }

    @RequestMapping(value={"/oauth/clients/tx/delete"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.OK)
    @Transactional
    @ResponseBody
    public ClientDetailsModification[] removeClientDetailsTx(@RequestBody ClientDetailsModification[] details) throws Exception {
        ClientDetails[] result = new ClientDetails[details.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (ClientDetails)this.clientDetailsService.retrieve(details[i].getClientId());
        }
        return this.doProcessDeletes(result);
    }

    @RequestMapping(value={"/oauth/clients/tx/modify"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.OK)
    @Transactional
    @ResponseBody
    public ClientDetailsModification[] modifyClientDetailsTx(@RequestBody ClientDetailsModification[] details) throws Exception {
        ClientDetailsModification[] result = new ClientDetailsModification[details.length];
        for (int i = 0; i < result.length; ++i) {
            if ("add".equals(details[i].getAction())) {
                ClientDetails client = this.clientDetailsValidator.validate((ClientDetails)details[i], ClientDetailsValidator.Mode.CREATE);
                this.clientRegistrationService.addClientDetails(client);
                this.clientUpdates.incrementAndGet();
                result[i] = new ClientDetailsModification((ClientDetails)this.clientDetailsService.retrieve(details[i].getClientId()));
            } else if ("delete".equals(details[i].getAction())) {
                result[i] = new ClientDetailsModification((ClientDetails)this.clientDetailsService.retrieve(details[i].getClientId()));
                this.doProcessDeletes(new ClientDetails[]{result[i]});
                result[i].setApprovalsDeleted(true);
            } else if ("update".equals(details[i].getAction())) {
                result[i] = this.updateClientNotSecret(details[i]);
            } else if ("update,secret".equals(details[i].getAction())) {
                boolean approvalsDeleted = this.updateClientSecret(details[i]);
                result[i] = this.updateClientNotSecret(details[i]);
                result[i].setApprovalsDeleted(approvalsDeleted);
            } else if ("secret".equals(details[i].getAction())) {
                boolean approvalsDeleted = this.updateClientSecret(details[i]);
                result[i] = details[i];
                result[i].setApprovalsDeleted(approvalsDeleted);
            } else {
                throw new InvalidClientDetailsException("Invalid action.");
            }
            result[i].setAction(details[i].getAction());
            result[i].setClientSecret(null);
        }
        return result;
    }

    private ClientDetailsModification updateClientNotSecret(ClientDetailsModification c) {
        ClientDetailsModification result = new ClientDetailsModification((ClientDetails)this.clientDetailsService.retrieve(c.getClientId()));
        ClientDetails client = this.clientDetailsValidator.validate((ClientDetails)c, ClientDetailsValidator.Mode.MODIFY);
        this.clientRegistrationService.updateClientDetails(client);
        this.clientUpdates.incrementAndGet();
        return result;
    }

    private boolean updateClientSecret(ClientDetailsModification detail) {
        boolean deleteApprovals;
        boolean bl = deleteApprovals = !this.authenticateClient(detail.getClientId(), detail.getClientSecret());
        if (deleteApprovals) {
            this.clientRegistrationService.updateClientSecret(detail.getClientId(), detail.getClientSecret());
            this.deleteApprovals(detail.getClientId());
            detail.setApprovalsDeleted(true);
        }
        return deleteApprovals;
    }

    @RequestMapping(value={"/oauth/clients/tx/secret"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.OK)
    @Transactional
    @ResponseBody
    public ClientDetailsModification[] changeSecretTx(@RequestBody SecretChangeRequest[] change) {
        ClientDetailsModification[] clientDetails = new ClientDetailsModification[change.length];
        String clientId = null;
        try {
            for (int i = 0; i < change.length; ++i) {
                clientId = change[i].getClientId();
                clientDetails[i] = new ClientDetailsModification((ClientDetails)this.clientDetailsService.retrieve(clientId));
                boolean oldPasswordOk = this.authenticateClient(clientId, change[i].getOldSecret());
                this.clientRegistrationService.updateClientSecret(clientId, change[i].getSecret());
                if (!oldPasswordOk) {
                    this.deleteApprovals(clientId);
                    clientDetails[i].setApprovalsDeleted(true);
                }
                clientDetails[i] = this.removeSecret((ClientDetails)clientDetails[i]);
            }
        }
        catch (InvalidClientException e) {
            throw new NoSuchClientException("No such client: " + clientId);
        }
        this.clientSecretChanges.getAndAdd(change.length);
        return clientDetails;
    }

    protected ClientDetailsModification[] doProcessDeletes(ClientDetails[] details) {
        ClientDetailsModification[] result = new ClientDetailsModification[details.length];
        for (int i = 0; i < details.length; ++i) {
            String clientId = details[i].getClientId();
            this.clientRegistrationService.removeClientDetails(clientId);
            this.deleteApprovals(clientId);
            this.clientDeletes.incrementAndGet();
            result[i] = this.removeSecret(details[i]);
            result[i].setApprovalsDeleted(true);
        }
        return result;
    }

    protected void deleteApprovals(String clientId) {
        if (this.approvalStore == null) {
            throw new UnsupportedOperationException("No approval store configured on " + this.getClass().getName());
        }
        this.approvalStore.revokeApprovals(String.format("client_id eq \"%s\"", clientId));
    }

    @RequestMapping(value={"/oauth/clients"}, method={RequestMethod.GET})
    @ResponseBody
    public SearchResults<?> listClientDetails(@RequestParam(value="attributes", required=false) String attributesCommaSeparated, @RequestParam(required=false, defaultValue="client_id pr") String filter, @RequestParam(required=false, defaultValue="client_id") String sortBy, @RequestParam(required=false, defaultValue="ascending") String sortOrder, @RequestParam(required=false, defaultValue="1") int startIndex, @RequestParam(required=false, defaultValue="100") int count) throws Exception {
        List clients;
        ArrayList<ClientDetailsModification> result = new ArrayList<ClientDetailsModification>();
        try {
            clients = this.clientDetailsService.query(filter, sortBy, "ascending".equalsIgnoreCase(sortOrder));
            if (count > clients.size()) {
                count = clients.size();
            }
        }
        catch (IllegalArgumentException e) {
            String msg = "Invalid filter expression: [" + filter + "]";
            if (StringUtils.hasText((String)sortBy)) {
                msg = msg + " [" + sortBy + "]";
            }
            throw new UaaException(msg, HttpStatus.BAD_REQUEST.value());
        }
        for (ClientDetails client : UaaPagingUtils.subList(clients, startIndex, count)) {
            result.add(this.removeSecret(client));
        }
        if (!StringUtils.hasLength((String)attributesCommaSeparated)) {
            return new SearchResults(Arrays.asList(SCIM_CLIENTS_SCHEMA_URI), result, startIndex, count, clients.size());
        }
        String[] attributes = attributesCommaSeparated.split(",");
        try {
            return SearchResultsFactory.buildSearchResultFrom(result, startIndex, count, clients.size(), attributes, this.attributeNameMapper, Arrays.asList(SCIM_CLIENTS_SCHEMA_URI));
        }
        catch (SpelParseException e) {
            throw new UaaException("Invalid attributes: [" + attributesCommaSeparated + "]", HttpStatus.BAD_REQUEST.value());
        }
        catch (SpelEvaluationException e) {
            throw new UaaException("Invalid attributes: [" + attributesCommaSeparated + "]", HttpStatus.BAD_REQUEST.value());
        }
    }

    @RequestMapping(value={"/oauth/clients/{client}/secret"}, method={RequestMethod.PUT})
    @ResponseBody
    public ActionResult changeSecret(@PathVariable String client, @RequestBody SecretChangeRequest change) {
        ClientDetails clientDetails;
        try {
            clientDetails = (ClientDetails)this.clientDetailsService.retrieve(client);
        }
        catch (InvalidClientException e) {
            throw new NoSuchClientException("No such client: " + client);
        }
        try {
            this.checkPasswordChangeIsAllowed(clientDetails, change.getOldSecret());
        }
        catch (IllegalStateException e) {
            throw new InvalidClientDetailsException(e.getMessage());
        }
        this.clientRegistrationService.updateClientSecret(client, change.getSecret());
        this.clientSecretChanges.incrementAndGet();
        return new ActionResult("ok", "secret updated");
    }

    @ExceptionHandler(value={InvalidClientDetailsException.class})
    public ResponseEntity<InvalidClientDetailsException> handleInvalidClientDetails(InvalidClientDetailsException e) {
        this.incrementErrorCounts(e);
        return new ResponseEntity((Object)e, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={NoSuchClientException.class})
    public ResponseEntity<Void> handleNoSuchClient(NoSuchClientException e) {
        this.incrementErrorCounts((Exception)((Object)e));
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={ClientAlreadyExistsException.class})
    public ResponseEntity<InvalidClientDetailsException> handleClientAlreadyExists(ClientAlreadyExistsException e) {
        this.incrementErrorCounts((Exception)e);
        return new ResponseEntity((Object)new InvalidClientDetailsException(e.getMessage()), HttpStatus.CONFLICT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementErrorCounts(Exception e) {
        String series = UaaStringUtils.getErrorName(e);
        AtomicInteger value = this.errorCounts.get(series);
        if (value == null) {
            Map<String, AtomicInteger> map = this.errorCounts;
            synchronized (map) {
                value = this.errorCounts.get(series);
                if (value == null) {
                    value = new AtomicInteger();
                    this.errorCounts.put(series, value);
                }
            }
        }
        value.incrementAndGet();
    }

    private void checkPasswordChangeIsAllowed(ClientDetails clientDetails, String oldSecret) {
        if (!this.securityContextAccessor.isClient()) {
            throw new IllegalStateException("Only a client can change client secret");
        }
        String clientId = clientDetails.getClientId();
        String currentClientId = this.securityContextAccessor.getClientId();
        if (this.securityContextAccessor.isAdmin()) {
            if (clientId.equals(currentClientId) && !this.authenticateClient(clientId, oldSecret)) {
                throw new IllegalStateException("Previous secret is required even for admin");
            }
        } else {
            if (!clientId.equals(currentClientId)) {
                this.logger.warn((Object)("Client with id " + currentClientId + " attempting to change password for client " + clientId));
                throw new IllegalStateException("Bad request. Not permitted to change another client's secret");
            }
            if (!this.authenticateClient(clientId, oldSecret)) {
                throw new IllegalStateException("Previous secret is required and must be valid");
            }
        }
    }

    private boolean authenticateClient(String clientId, String clientSecret) {
        UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)clientId, (Object)clientSecret);
        try {
            HttpServletRequest curRequest = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
            if (curRequest != null) {
                authentication.setDetails((Object)new UaaAuthenticationDetails(curRequest, clientId));
            }
        }
        catch (IllegalStateException curRequest) {
            // empty catch block
        }
        try {
            Authentication auth = this.authenticationManager.authenticate((Authentication)authentication);
            return auth.isAuthenticated();
        }
        catch (AuthenticationException e) {
            return false;
        }
        catch (Exception e) {
            this.logger.debug((Object)("Unable to authenticate/validate " + clientId), (Throwable)e);
            return false;
        }
    }

    private ClientDetailsModification removeSecret(ClientDetails client) {
        if (client == null) {
            return null;
        }
        ClientDetailsModification details = new ClientDetailsModification(client);
        details.setClientSecret(null);
        return details;
    }

    private ClientDetailsModification syncWithExisting(ClientDetails existing, ClientDetails input) {
        ClientDetailsModification details = new ClientDetailsModification(input);
        if (input instanceof BaseClientDetails) {
            BaseClientDetails baseInput = (BaseClientDetails)input;
            if (baseInput.getAutoApproveScopes() != null) {
                details.setAutoApproveScopes((Collection)baseInput.getAutoApproveScopes());
            } else {
                BaseClientDetails existingDetails;
                details.setAutoApproveScopes(new HashSet());
                if (existing instanceof BaseClientDetails && (existingDetails = (BaseClientDetails)existing).getAutoApproveScopes() != null) {
                    for (String scope : existingDetails.getAutoApproveScopes()) {
                        details.getAutoApproveScopes().add(scope);
                    }
                }
            }
        }
        if (details.getAccessTokenValiditySeconds() == null) {
            details.setAccessTokenValiditySeconds(existing.getAccessTokenValiditySeconds());
        }
        if (details.getRefreshTokenValiditySeconds() == null) {
            details.setRefreshTokenValiditySeconds(existing.getRefreshTokenValiditySeconds());
        }
        if (details.getAuthorities() == null || details.getAuthorities().isEmpty()) {
            details.setAuthorities(existing.getAuthorities());
        }
        if (details.getAuthorizedGrantTypes() == null || details.getAuthorizedGrantTypes().isEmpty()) {
            details.setAuthorizedGrantTypes((Collection)existing.getAuthorizedGrantTypes());
        }
        if (details.getRegisteredRedirectUri() == null || details.getRegisteredRedirectUri().isEmpty()) {
            details.setRegisteredRedirectUri(existing.getRegisteredRedirectUri());
        }
        if (details.getResourceIds() == null || details.getResourceIds().isEmpty()) {
            details.setResourceIds((Collection)existing.getResourceIds());
        }
        if (details.getScope() == null || details.getScope().isEmpty()) {
            details.setScope((Collection)existing.getScope());
        }
        HashMap additionalInformation = new HashMap(existing.getAdditionalInformation());
        additionalInformation.putAll(input.getAdditionalInformation());
        for (String key : Collections.unmodifiableSet(additionalInformation.keySet())) {
            if (additionalInformation.get(key) != null) continue;
            additionalInformation.remove(key);
        }
        details.setAdditionalInformation(additionalInformation);
        return details;
    }

    public void setClientDetailsValidator(ClientAdminEndpointsValidator clientDetailsValidator) {
        this.clientDetailsValidator = clientDetailsValidator;
    }

    public ClientDetailsValidator getClientDetailsValidator() {
        return this.clientDetailsValidator;
    }

    public void setClientDetailsResourceMonitor(ResourceMonitor<ClientDetails> clientDetailsResourceMonitor) {
        this.clientDetailsResourceMonitor = clientDetailsResourceMonitor;
    }
}

