/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.oauth;

import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.approval.Approval;
import org.cloudfoundry.identity.uaa.approval.ApprovalStore;
import org.cloudfoundry.identity.uaa.authentication.Origin;
import org.cloudfoundry.identity.uaa.resources.QueryableResourceManager;
import org.cloudfoundry.identity.uaa.util.UaaTokenUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.approval.UserApprovalHandler;

public class UserManagedAuthzApprovalHandler
implements UserApprovalHandler {
    private static final String SCOPE_PREFIX = "scope.";
    private static Log logger = LogFactory.getLog(UserManagedAuthzApprovalHandler.class);
    private final String approvalParameter = "user_oauth_approval";
    private ApprovalStore approvalStore;
    private QueryableResourceManager<ClientDetails> clientDetailsService;
    private int approvalExpiryInMillis = -1;

    public void setClientDetailsService(QueryableResourceManager<ClientDetails> clientDetailsService) {
        this.clientDetailsService = clientDetailsService;
    }

    public void setApprovalStore(ApprovalStore approvalStore) {
        this.approvalStore = approvalStore;
    }

    public boolean isApproved(AuthorizationRequest authorizationRequest, Authentication userAuthentication) {
        Set<String> approvedScopes;
        boolean userApproval;
        String flag = (String)authorizationRequest.getApprovalParameters().get("user_oauth_approval");
        boolean bl = userApproval = flag != null && flag.toLowerCase().equals("true");
        if (logger.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder("Looking up user approved authorizations for ");
            builder.append("client_id=").append(authorizationRequest.getClientId());
            builder.append(" and username=").append(userAuthentication.getName());
            logger.debug((Object)builder.toString());
        }
        Set requestedScopes = authorizationRequest.getScope();
        Set<String> autoApprovedScopes = new HashSet<String>();
        ClientDetails client = (ClientDetails)this.clientDetailsService.retrieve(authorizationRequest.getClientId());
        if (null != client) {
            Map additionalInfo;
            if (null != requestedScopes) {
                for (String requestedScope : requestedScopes) {
                    if (!client.isAutoApprove(requestedScope)) continue;
                    autoApprovedScopes.add(requestedScope);
                }
            }
            if (null != (additionalInfo = client.getAdditionalInformation())) {
                Object autoApproved = additionalInfo.get("autoapprove");
                if (null != autoApproved && autoApproved instanceof Collection) {
                    Collection scopes = (Collection)autoApproved;
                    autoApprovedScopes.addAll(scopes);
                } else if (null != autoApproved && autoApproved instanceof Boolean && ((Boolean)autoApproved).booleanValue() || "true".equals(autoApproved)) {
                    autoApprovedScopes.addAll(client.getScope());
                }
            }
        }
        autoApprovedScopes = this.retainAutoApprovedScopes(requestedScopes, autoApprovedScopes);
        if (userApproval) {
            Date expiry = this.computeExpiry();
            Map approvalParameters = authorizationRequest.getApprovalParameters();
            approvedScopes = new HashSet<String>();
            approvedScopes.addAll(autoApprovedScopes);
            boolean foundUserApprovalParameter = false;
            for (String approvalParameter : approvalParameters.keySet()) {
                if (!approvalParameter.startsWith(SCOPE_PREFIX)) continue;
                approvedScopes.add(((String)approvalParameters.get(approvalParameter)).substring(SCOPE_PREFIX.length()));
                foundUserApprovalParameter = true;
            }
            if (foundUserApprovalParameter) {
                authorizationRequest.setScope(approvedScopes);
                for (String requestedScope : requestedScopes) {
                    Approval approval;
                    if (approvedScopes.contains(requestedScope)) {
                        approval = new Approval().setUserId(this.getUserId(userAuthentication)).setClientId(authorizationRequest.getClientId()).setScope(requestedScope).setExpiresAt(expiry).setStatus(Approval.ApprovalStatus.APPROVED);
                        this.approvalStore.addApproval(approval);
                        continue;
                    }
                    approval = new Approval().setUserId(this.getUserId(userAuthentication)).setClientId(authorizationRequest.getClientId()).setScope(requestedScope).setExpiresAt(expiry).setStatus(Approval.ApprovalStatus.DENIED);
                    this.approvalStore.addApproval(approval);
                }
            } else {
                authorizationRequest.setScope(autoApprovedScopes);
                for (String requestedScope : requestedScopes) {
                    if (autoApprovedScopes.contains(requestedScope)) continue;
                    Approval approval = new Approval().setUserId(this.getUserId(userAuthentication)).setClientId(authorizationRequest.getClientId()).setScope(requestedScope).setExpiresAt(expiry).setStatus(Approval.ApprovalStatus.DENIED);
                    this.approvalStore.addApproval(approval);
                }
            }
            if (userAuthentication.isAuthenticated()) {
                return true;
            }
        } else {
            List<Approval> userApprovals = this.approvalStore.getApprovals(this.getUserId(userAuthentication), authorizationRequest.getClientId());
            HashSet<String> validUserApprovedScopes = new HashSet<String>();
            approvedScopes = new HashSet();
            approvedScopes.addAll(autoApprovedScopes);
            validUserApprovedScopes.addAll(autoApprovedScopes);
            Date today = new Date();
            for (Approval approval : userApprovals) {
                if (!approval.getExpiresAt().after(today)) continue;
                validUserApprovedScopes.add(approval.getScope());
                if (approval.getStatus() != Approval.ApprovalStatus.APPROVED) continue;
                approvedScopes.add(approval.getScope());
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Valid user approved/denied scopes are " + validUserApprovedScopes));
            }
            if (validUserApprovedScopes.containsAll(requestedScopes) && userAuthentication.isAuthenticated()) {
                approvedScopes = this.retainAutoApprovedScopes(requestedScopes, approvedScopes);
                authorizationRequest.setScope(approvedScopes);
                return true;
            }
        }
        return false;
    }

    protected Set<String> retainAutoApprovedScopes(Collection<String> requestedScopes, Set<String> autoApprovedScopes) {
        return UaaTokenUtils.retainAutoApprovedScopes(requestedScopes, autoApprovedScopes);
    }

    protected String getUserId(Authentication authentication) {
        return Origin.getUserId(authentication);
    }

    private Date computeExpiry() {
        Calendar expiresAt = Calendar.getInstance();
        if (this.approvalExpiryInMillis == -1) {
            expiresAt.add(2, 1);
        } else {
            expiresAt.add(14, this.approvalExpiryInMillis);
        }
        return expiresAt.getTime();
    }

    public void setApprovalExpiryInSeconds(int approvalExpirySeconds) {
        this.approvalExpiryInMillis = approvalExpirySeconds * 1000;
    }

    public AuthorizationRequest checkForPreApproval(AuthorizationRequest authorizationRequest, Authentication userAuthentication) {
        return authorizationRequest;
    }

    public AuthorizationRequest updateAfterApproval(AuthorizationRequest authorizationRequest, Authentication userAuthentication) {
        return authorizationRequest;
    }

    public Map<String, Object> getUserApprovalRequest(AuthorizationRequest authorizationRequest, Authentication userAuthentication) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.putAll(authorizationRequest.getRequestParameters());
        return model;
    }
}

