/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider.saml.idp;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.httpclient.contrib.ssl.EasySSLProtocolSocketFactory;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.protocol.DefaultProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.http.client.utils.URIBuilder;
import org.cloudfoundry.identity.uaa.provider.saml.ConfigMetadataProvider;
import org.cloudfoundry.identity.uaa.provider.saml.FixedHttpMetaDataProvider;
import org.cloudfoundry.identity.uaa.provider.saml.idp.SamlServiceProvider;
import org.cloudfoundry.identity.uaa.provider.saml.idp.SamlServiceProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.saml.idp.SamlServiceProviderHolder;
import org.cloudfoundry.identity.uaa.zone.IdentityZone;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.xml.parse.BasicParserPool;
import org.opensaml.xml.parse.ParserPool;
import org.springframework.security.saml.metadata.ExtendedMetadata;
import org.springframework.security.saml.metadata.ExtendedMetadataDelegate;
import org.springframework.util.StringUtils;

public class SamlServiceProviderConfigurator {
    private final Map<IdentityZone, Map<String, SamlServiceProviderHolder>> zoneServiceProviders = new HashMap<IdentityZone, Map<String, SamlServiceProviderHolder>>();
    private HttpClientParams clientParams;
    private BasicParserPool parserPool;
    private Timer dummyTimer = new Timer(){

        @Override
        public void cancel() {
            super.cancel();
        }

        @Override
        public int purge() {
            return 0;
        }

        @Override
        public void schedule(TimerTask task, long delay) {
        }

        @Override
        public void schedule(TimerTask task, long delay, long period) {
        }

        @Override
        public void schedule(TimerTask task, Date firstTime, long period) {
        }

        @Override
        public void schedule(TimerTask task, Date time) {
        }

        @Override
        public void scheduleAtFixedRate(TimerTask task, long delay, long period) {
        }

        @Override
        public void scheduleAtFixedRate(TimerTask task, Date firstTime, long period) {
        }
    };

    public SamlServiceProviderConfigurator() {
        this.dummyTimer.cancel();
    }

    public List<SamlServiceProviderHolder> getSamlServiceProviders() {
        Map<String, SamlServiceProviderHolder> serviceProviders = this.getOrCreateSamlServiceProviderMapForZone(IdentityZoneHolder.get());
        return Collections.unmodifiableList(new ArrayList<SamlServiceProviderHolder>(serviceProviders.values()));
    }

    public List<SamlServiceProviderHolder> getSamlServiceProvidersForZone(IdentityZone zone) {
        Map<String, SamlServiceProviderHolder> serviceProviders = this.getOrCreateSamlServiceProviderMapForZone(zone);
        return Collections.unmodifiableList(new ArrayList<SamlServiceProviderHolder>(serviceProviders.values()));
    }

    public Map<String, SamlServiceProviderHolder> getSamlServiceProviderMapForZone(IdentityZone zone) {
        Map<String, SamlServiceProviderHolder> serviceProviders = this.getOrCreateSamlServiceProviderMapForZone(zone);
        return Collections.unmodifiableMap(serviceProviders);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, SamlServiceProviderHolder> getOrCreateSamlServiceProviderMapForZone(IdentityZone zone) {
        Map<String, SamlServiceProviderHolder> serviceProviders = this.zoneServiceProviders.get(zone);
        if (serviceProviders == null) {
            Map<IdentityZone, Map<String, SamlServiceProviderHolder>> map = this.zoneServiceProviders;
            synchronized (map) {
                serviceProviders = this.zoneServiceProviders.get(zone);
                if (serviceProviders == null) {
                    serviceProviders = new HashMap<String, SamlServiceProviderHolder>();
                    this.zoneServiceProviders.put(IdentityZoneHolder.get(), serviceProviders);
                }
            }
        }
        return serviceProviders;
    }

    public synchronized ExtendedMetadataDelegate[] addSamlServiceProvider(SamlServiceProvider provider) throws MetadataProviderException {
        if (provider == null) {
            throw new NullPointerException();
        }
        if (!StringUtils.hasText((String)provider.getEntityId())) {
            throw new NullPointerException("You must set the SAML SP Entity.");
        }
        if (!StringUtils.hasText((String)provider.getIdentityZoneId())) {
            throw new NullPointerException("You must set the SAML SP Identity Zone Id.");
        }
        if (!IdentityZoneHolder.get().getId().equals(provider.getIdentityZoneId())) {
            throw new IllegalArgumentException("The SAML SP Identity Zone Id does not match the curent zone.");
        }
        ExtendedMetadataDelegate added = this.getExtendedMetadataDelegate(provider);
        String metadataEntityId = ((ConfigMetadataProvider)added.getDelegate()).getEntityID();
        if (!provider.getEntityId().equals(metadataEntityId)) {
            throw new MetadataProviderException("Metadata entity id does not match SAML SP entity id: " + provider.getEntityId());
        }
        Map<String, SamlServiceProviderHolder> serviceProviders = this.getOrCreateSamlServiceProviderMapForZone(IdentityZoneHolder.get());
        ExtendedMetadataDelegate deleted = null;
        if (serviceProviders.containsKey(provider.getEntityId())) {
            deleted = serviceProviders.remove(provider.getEntityId()).getExtendedMetadataDelegate();
        }
        SamlServiceProviderHolder holder = new SamlServiceProviderHolder(added, provider);
        serviceProviders.put(provider.getEntityId(), holder);
        return new ExtendedMetadataDelegate[]{added, deleted};
    }

    public synchronized ExtendedMetadataDelegate removeSamlServiceProvider(String entityId) {
        Map<String, SamlServiceProviderHolder> serviceProviders = this.getOrCreateSamlServiceProviderMapForZone(IdentityZoneHolder.get());
        return serviceProviders.remove(entityId).getExtendedMetadataDelegate();
    }

    public ExtendedMetadataDelegate getExtendedMetadataDelegateFromCache(String entityId) throws MetadataProviderException {
        Map<String, SamlServiceProviderHolder> serviceProviders = this.getOrCreateSamlServiceProviderMapForZone(IdentityZoneHolder.get());
        return serviceProviders.get(entityId).getExtendedMetadataDelegate();
    }

    public ExtendedMetadataDelegate getExtendedMetadataDelegate(SamlServiceProvider provider) throws MetadataProviderException {
        ExtendedMetadataDelegate metadata;
        switch (provider.getConfig().getType()) {
            case DATA: {
                metadata = this.configureXMLMetadata(provider);
                break;
            }
            case URL: {
                metadata = this.configureURLMetadata(provider);
                break;
            }
            default: {
                throw new MetadataProviderException("Invalid metadata type for alias[" + provider.getEntityId() + "]:" + provider.getConfig().getMetaDataLocation());
            }
        }
        return metadata;
    }

    protected ExtendedMetadataDelegate configureXMLMetadata(SamlServiceProvider provider) {
        ConfigMetadataProvider configMetadataProvider = new ConfigMetadataProvider(provider.getIdentityZoneId(), provider.getEntityId(), provider.getConfig().getMetaDataLocation());
        configMetadataProvider.setParserPool((ParserPool)this.getParserPool());
        ExtendedMetadata extendedMetadata = new ExtendedMetadata();
        extendedMetadata.setLocal(false);
        extendedMetadata.setAlias(provider.getEntityId());
        ExtendedMetadataDelegate delegate = new ExtendedMetadataDelegate((MetadataProvider)configMetadataProvider, extendedMetadata);
        delegate.setMetadataTrustCheck(provider.getConfig().isMetadataTrustCheck());
        return delegate;
    }

    protected ExtendedMetadataDelegate configureURLMetadata(SamlServiceProvider provider) throws MetadataProviderException {
        FixedHttpMetaDataProvider fixedHttpMetaDataProvider;
        DefaultProtocolSocketFactory socketFactory = null;
        SamlServiceProviderDefinition def = provider.getConfig().clone();
        if (def.getMetaDataLocation().startsWith("https")) {
            try {
                socketFactory = new EasySSLProtocolSocketFactory();
            }
            catch (IOException | GeneralSecurityException e) {
                throw new MetadataProviderException("Error instantiating SSL/TLS socket factory.", e);
            }
        } else {
            socketFactory = new DefaultProtocolSocketFactory();
        }
        ExtendedMetadata extendedMetadata = new ExtendedMetadata();
        extendedMetadata.setAlias(provider.getEntityId());
        try {
            fixedHttpMetaDataProvider = FixedHttpMetaDataProvider.buildProvider(this.dummyTimer, this.getClientParams(), this.adjustURIForPort(def.getMetaDataLocation()));
        }
        catch (URISyntaxException e) {
            throw new MetadataProviderException("Invalid metadata URI: " + def.getMetaDataLocation(), (Exception)e);
        }
        fixedHttpMetaDataProvider.setSocketFactory((ProtocolSocketFactory)socketFactory);
        byte[] metadata = fixedHttpMetaDataProvider.fetchMetadata();
        def.setMetaDataLocation(new String(metadata, StandardCharsets.UTF_8));
        return this.configureXMLMetadata(provider);
    }

    protected String adjustURIForPort(String uri) throws URISyntaxException {
        URI metadataURI = new URI(uri);
        if (metadataURI.getPort() < 0) {
            switch (metadataURI.getScheme()) {
                case "https": {
                    return new URIBuilder(uri).setPort(443).build().toString();
                }
                case "http": {
                    return new URIBuilder(uri).setPort(80).build().toString();
                }
            }
            return uri;
        }
        return uri;
    }

    public HttpClientParams getClientParams() {
        return this.clientParams;
    }

    public void setClientParams(HttpClientParams clientParams) {
        this.clientParams = clientParams;
    }

    public BasicParserPool getParserPool() {
        return this.parserPool;
    }

    public void setParserPool(BasicParserPool parserPool) {
        this.parserPool = parserPool;
    }
}

