/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.oauth.jwt;

import java.util.LinkedHashMap;
import java.util.Map;
import org.cloudfoundry.identity.uaa.oauth.jwt.HeaderParametersImpl;
import org.cloudfoundry.identity.uaa.oauth.jwt.JwtAlgorithms;
import org.cloudfoundry.identity.uaa.oauth.jwt.JwtHeader;
import org.cloudfoundry.identity.uaa.oauth.jwt.Signer;
import org.springframework.security.jwt.codec.Codecs;

class JwtHeaderHelper {
    JwtHeaderHelper() {
    }

    static JwtHeader create(String header) {
        byte[] bytes = Codecs.b64UrlDecode((CharSequence)header);
        return new JwtHeader(bytes, JwtHeaderHelper.parseParams(bytes));
    }

    static JwtHeader create(Signer signer) {
        HeaderParametersImpl p = new HeaderParametersImpl(JwtAlgorithms.sigAlg(signer.algorithm()), null, null, signer.keyId());
        return new JwtHeader(JwtHeaderHelper.serializeParams(p), p);
    }

    static HeaderParametersImpl parseParams(byte[] header) {
        Map<String, String> map = JwtHeaderHelper.parseMap(Codecs.utf8Decode((byte[])header));
        String alg = map.get("alg");
        String enc = map.get("enc");
        String iv = map.get("iv");
        String typ = map.get("typ");
        if (typ != null && !"JWT".equalsIgnoreCase(typ)) {
            throw new IllegalArgumentException("typ is not \"JWT\"");
        }
        String kid = map.get("kid");
        return new HeaderParametersImpl(alg, enc, iv, kid);
    }

    private static Map<String, String> parseMap(String json) {
        if (json != null) {
            if ((json = json.trim()).startsWith("{")) {
                return JwtHeaderHelper.parseMapInternal(json);
            }
            if (json.equals("")) {
                return new LinkedHashMap<String, String>();
            }
        }
        throw new IllegalArgumentException("Invalid JSON (null)");
    }

    private static Map<String, String> parseMapInternal(String json) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        json = JwtHeaderHelper.trimLeadingCharacter(JwtHeaderHelper.trimTrailingCharacter(json, '}'), '{');
        for (String pair : json.split(",")) {
            String[] values = pair.split(":");
            String key = JwtHeaderHelper.strip(values[0], '\"');
            String value = null;
            if (values.length > 0) {
                value = JwtHeaderHelper.strip(values[1], '\"');
            }
            if (map.containsKey(key)) {
                throw new IllegalArgumentException("Duplicate '" + key + "' field");
            }
            map.put(key, value);
        }
        return map;
    }

    private static String strip(String string, char c) {
        return JwtHeaderHelper.trimLeadingCharacter(JwtHeaderHelper.trimTrailingCharacter(string.trim(), c), c);
    }

    private static String trimTrailingCharacter(String string, char c) {
        if (string.length() >= 0 && string.charAt(string.length() - 1) == c) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    private static String trimLeadingCharacter(String string, char c) {
        if (string.length() >= 0 && string.charAt(0) == c) {
            return string.substring(1);
        }
        return string;
    }

    private static byte[] serializeParams(HeaderParametersImpl params) {
        StringBuilder builder = new StringBuilder("{");
        JwtHeaderHelper.appendField(builder, "alg", params.alg);
        if (params.kid != null) {
            JwtHeaderHelper.appendField(builder, "kid", params.kid);
        }
        if (params.enc != null) {
            JwtHeaderHelper.appendField(builder, "enc", params.enc);
        }
        if (params.iv != null) {
            JwtHeaderHelper.appendField(builder, "iv", params.iv);
        }
        if (params.typ != null) {
            JwtHeaderHelper.appendField(builder, "typ", params.typ);
        }
        builder.append("}");
        return Codecs.utf8Encode((CharSequence)builder.toString());
    }

    private static void appendField(StringBuilder builder, String name, String value) {
        if (builder.length() > 1) {
            builder.append(",");
        }
        builder.append("\"").append(name).append("\":\"").append(value).append("\"");
    }
}

