/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider.oauth;

import java.io.IOException;
import java.net.URLEncoder;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.util.URIUtil;
import org.cloudfoundry.identity.uaa.authentication.UaaAuthenticationDetails;
import org.cloudfoundry.identity.uaa.provider.oauth.XOAuthAuthenticationManager;
import org.cloudfoundry.identity.uaa.provider.oauth.XOAuthCodeToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.StringUtils;

public class XOAuthAuthenticationFilter
implements Filter {
    private final XOAuthAuthenticationManager xOAuthAuthenticationManager;

    public XOAuthAuthenticationFilter(XOAuthAuthenticationManager xOAuthAuthenticationManager) {
        this.xOAuthAuthenticationManager = xOAuthAuthenticationManager;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String origin = URIUtil.getName((String)request.getServletPath());
        String code = request.getParameter("code");
        String redirectUrl = request.getRequestURL().toString();
        XOAuthCodeToken codeToken = new XOAuthCodeToken(code, origin, redirectUrl);
        codeToken.setDetails(new UaaAuthenticationDetails(request));
        try {
            Authentication authentication = this.xOAuthAuthenticationManager.authenticate(codeToken);
            SecurityContextHolder.getContext().setAuthentication(authentication);
        }
        catch (Exception ex) {
            String message = ex.getMessage();
            if (!StringUtils.hasText((String)message)) {
                message = ex.getClass().getSimpleName();
            }
            String errorMessage = URLEncoder.encode("There was an error when authenticating against the external identity provider: " + message, "UTF-8");
            response.sendRedirect(request.getContextPath() + "/oauth_error?error=" + errorMessage);
            return;
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void destroy() {
    }
}

