/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.audit;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.audit.AuditEvent;
import org.cloudfoundry.identity.uaa.audit.UaaAuditService;
import org.springframework.jmx.export.annotation.ManagedMetric;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.jmx.support.MetricType;

@ManagedResource
public class LoggingAuditService
implements UaaAuditService {
    private final Log logger = LogFactory.getLog((String)"UAA.Audit");
    private AtomicInteger userAuthenticationCount = new AtomicInteger();
    private AtomicInteger userAuthenticationFailureCount = new AtomicInteger();
    private AtomicInteger principalAuthenticationFailureCount = new AtomicInteger();
    private AtomicInteger userNotFoundCount = new AtomicInteger();
    private AtomicInteger principalNotFoundCount = new AtomicInteger();
    private AtomicInteger passwordChanges = new AtomicInteger();
    private AtomicInteger passwordFailures = new AtomicInteger();

    @ManagedMetric(metricType=MetricType.COUNTER, displayName="User Not Found Count")
    public int getUserNotFoundCount() {
        return this.userNotFoundCount.get();
    }

    @ManagedMetric(metricType=MetricType.COUNTER, displayName="User Successful Authentication Count")
    public int getUserAuthenticationCount() {
        return this.userAuthenticationCount.get();
    }

    @ManagedMetric(metricType=MetricType.COUNTER, displayName="User Authentication Failure Count")
    public int getUserAuthenticationFailureCount() {
        return this.userAuthenticationFailureCount.get();
    }

    @ManagedMetric(metricType=MetricType.COUNTER, displayName="Principal (non-user) Authentication Failure Count")
    public int getPrincipalAuthenticationFailureCount() {
        return this.principalAuthenticationFailureCount.get();
    }

    @ManagedMetric(metricType=MetricType.COUNTER, displayName="Principal (non-user) Not Found Count")
    public int getPrincipalNotFoundCount() {
        return this.principalNotFoundCount.get();
    }

    @ManagedMetric(metricType=MetricType.COUNTER, displayName="User Password Change Count (Since Startup)")
    public int getUserPasswordChanges() {
        return this.passwordChanges.get();
    }

    @ManagedMetric(metricType=MetricType.COUNTER, displayName="User Password Change Failure Count (Since Startup)")
    public int getUserPasswordFailures() {
        return this.passwordFailures.get();
    }

    @Override
    public List<AuditEvent> find(String principal, long after) {
        throw new UnsupportedOperationException("This implementation does not store data");
    }

    @Override
    public void log(AuditEvent auditEvent) {
        this.updateCounters(auditEvent);
        this.log(String.format("%s ('%s'): principal=%s, origin=[%s], identityZoneId=[%s]", auditEvent.getType().name(), auditEvent.getData(), auditEvent.getPrincipalId(), auditEvent.getOrigin(), auditEvent.getIdentityZoneId()));
    }

    private void updateCounters(AuditEvent auditEvent) {
        switch (auditEvent.getType()) {
            case PasswordChangeSuccess: {
                this.passwordChanges.incrementAndGet();
                break;
            }
            case PasswordChangeFailure: {
                this.passwordFailures.incrementAndGet();
                break;
            }
            case UserAuthenticationSuccess: {
                this.userAuthenticationCount.incrementAndGet();
                break;
            }
            case UserAuthenticationFailure: {
                this.userAuthenticationFailureCount.incrementAndGet();
                break;
            }
            case UserNotFound: {
                this.userNotFoundCount.incrementAndGet();
                break;
            }
            case PrincipalAuthenticationFailure: {
                this.principalAuthenticationFailureCount.incrementAndGet();
                break;
            }
            case PrincipalNotFound: {
                this.principalNotFoundCount.incrementAndGet();
                break;
            }
        }
    }

    private void log(String msg) {
        if (this.logger.isTraceEnabled()) {
            StringBuilder output = new StringBuilder(256);
            output.append("\n************************************************************\n");
            output.append(msg);
            output.append("\n\n************************************************************\n");
            this.logger.trace((Object)output.toString());
        } else {
            this.logger.info((Object)msg);
        }
    }
}

