/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.authentication.manager;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.audit.AuditEvent;
import org.cloudfoundry.identity.uaa.audit.AuditEventType;
import org.cloudfoundry.identity.uaa.audit.UaaAuditService;
import org.cloudfoundry.identity.uaa.authentication.manager.AccountLoginPolicy;
import org.cloudfoundry.identity.uaa.provider.IdentityProvider;
import org.cloudfoundry.identity.uaa.provider.IdentityProviderProvisioning;
import org.cloudfoundry.identity.uaa.provider.LockoutPolicy;
import org.cloudfoundry.identity.uaa.provider.UaaIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.user.UaaUser;
import org.cloudfoundry.identity.uaa.util.ObjectUtils;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;

public class PeriodLockoutPolicy
implements AccountLoginPolicy {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final UaaAuditService auditService;
    private LockoutPolicy lockoutPolicy;
    private IdentityProviderProvisioning providerProvisioning;

    public PeriodLockoutPolicy(UaaAuditService auditService, IdentityProviderProvisioning providerProvisioning) {
        this.auditService = auditService;
        this.providerProvisioning = providerProvisioning;
    }

    @Override
    public boolean isAllowed(UaaUser user, Authentication a) throws AuthenticationException {
        AuditEvent lastFailure;
        LockoutPolicy policyFromDb = this.getLockoutPolicyFromDb();
        LockoutPolicy localPolicy = policyFromDb != null ? policyFromDb : this.lockoutPolicy;
        long eventsAfter = System.currentTimeMillis() - (long)(localPolicy.getCountFailuresWithin() * 1000);
        List<AuditEvent> events = this.auditService.find(user.getId(), eventsAfter);
        int failureCount = this.sequentialFailureCount(events);
        if (failureCount >= localPolicy.getLockoutAfterFailures() && (lastFailure = this.mostRecentFailure(events)) != null && lastFailure.getTime() > System.currentTimeMillis() - (long)(localPolicy.getLockoutPeriodSeconds() * 1000)) {
            this.logger.warn((Object)("User " + user.getUsername() + " and id " + user.getId() + " has " + failureCount + " failed logins within the last checking period."));
            return false;
        }
        return true;
    }

    private int sequentialFailureCount(List<AuditEvent> events) {
        int failureCount = 0;
        for (AuditEvent event : events) {
            if (event.getType() == AuditEventType.UserAuthenticationFailure) {
                ++failureCount;
                continue;
            }
            if (event.getType() != AuditEventType.UserAuthenticationSuccess) continue;
            break;
        }
        return failureCount;
    }

    private AuditEvent mostRecentFailure(List<AuditEvent> events) {
        for (AuditEvent event : events) {
            if (event.getType() != AuditEventType.UserAuthenticationFailure) continue;
            return event;
        }
        return null;
    }

    public void setLockoutPolicy(LockoutPolicy lockoutPolicy) {
        this.lockoutPolicy = lockoutPolicy;
    }

    private LockoutPolicy getLockoutPolicyFromDb() {
        IdentityProvider idp = this.providerProvisioning.retrieveByOrigin("uaa", IdentityZoneHolder.get().getId());
        UaaIdentityProviderDefinition idpDefinition = (UaaIdentityProviderDefinition)ObjectUtils.castInstance((Object)idp.getConfig(), UaaIdentityProviderDefinition.class);
        if (idpDefinition != null && idpDefinition.getLockoutPolicy() != null) {
            return idpDefinition.getLockoutPolicy();
        }
        return null;
    }

    public LockoutPolicy getLockoutPolicy() {
        return this.lockoutPolicy;
    }
}

