/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.client;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.client.ClientMetadata;
import org.cloudfoundry.identity.uaa.client.ClientMetadataProvisioning;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.ClientRegistrationService;
import org.springframework.security.oauth2.provider.client.BaseClientDetails;
import org.springframework.util.Assert;
import org.springframework.util.Base64Utils;
import org.springframework.util.StringUtils;

public class JdbcClientMetadataProvisioning
implements ClientMetadataProvisioning {
    private static final Log logger = LogFactory.getLog(JdbcClientMetadataProvisioning.class);
    private static final String CLIENT_METADATA_FIELDS = "client_id, identity_zone_id, show_on_home_page, app_launch_url, app_icon, additional_information";
    private static final String CLIENT_METADATA_QUERY = "select client_id, identity_zone_id, show_on_home_page, app_launch_url, app_icon, additional_information from oauth_client_details where client_id=? and identity_zone_id=?";
    private static final String CLIENT_METADATAS_QUERY = "select client_id, identity_zone_id, show_on_home_page, app_launch_url, app_icon, additional_information from oauth_client_details where identity_zone_id=? and ((app_launch_url is not null and char_length(app_launch_url)>0) or (app_icon is not null and octet_length(app_icon)>0))";
    private static final String CLIENT_METADATA_UPDATE_FIELDS = "show_on_home_page, app_launch_url, app_icon";
    private static final String CLIENT_METADATA_UPDATE = "update oauth_client_details set " + "show_on_home_page, app_launch_url, app_icon".replace(",", "=?,") + "=?" + " where client_id=? and identity_zone_id=?";
    private JdbcTemplate template;
    private ClientDetailsService clientDetailsService;
    private ClientRegistrationService clientRegistrationService;
    private final RowMapper<ClientMetadata> mapper = new ClientMetadataRowMapper();

    JdbcClientMetadataProvisioning(ClientDetailsService clientDetailsService, ClientRegistrationService clientRegistrationService, JdbcTemplate template) {
        Assert.notNull((Object)template);
        Assert.notNull((Object)clientDetailsService);
        this.template = template;
        this.clientDetailsService = clientDetailsService;
        this.clientRegistrationService = clientRegistrationService;
    }

    public void setTemplate(JdbcTemplate template) {
        this.template = template;
    }

    @Override
    public List<ClientMetadata> retrieveAll() {
        logger.debug((Object)"Retrieving UI details for all client");
        return this.template.query(CLIENT_METADATAS_QUERY, this.mapper, new Object[]{IdentityZoneHolder.get().getId()});
    }

    @Override
    public ClientMetadata retrieve(String clientId) {
        logger.debug((Object)("Retrieving UI details for client: " + clientId));
        return (ClientMetadata)this.template.queryForObject(CLIENT_METADATA_QUERY, this.mapper, new Object[]{clientId, IdentityZoneHolder.get().getId()});
    }

    @Override
    public ClientMetadata update(ClientMetadata resource) {
        logger.debug((Object)("Updating metadata for client: " + resource.getClientId()));
        this.updateClientNameIfNotEmpty(resource);
        int updated = this.template.update(CLIENT_METADATA_UPDATE, ps -> {
            int pos = 1;
            ps.setBoolean(pos++, resource.isShowOnHomePage());
            URL appLaunchUrl = resource.getAppLaunchUrl();
            ps.setString(pos++, appLaunchUrl == null ? null : appLaunchUrl.toString());
            String appIcon = resource.getAppIcon();
            if (appIcon != null) {
                byte[] decodedAppIcon = Base64Utils.decode((byte[])appIcon.getBytes());
                ps.setBinaryStream(pos++, (InputStream)new ByteArrayInputStream(decodedAppIcon), decodedAppIcon.length);
            } else {
                ps.setBinaryStream(pos++, (InputStream)new ByteArrayInputStream(new byte[0]), 0);
            }
            ps.setString(pos++, resource.getClientId());
            String zone = IdentityZoneHolder.get().getId();
            ps.setString(pos++, zone);
        });
        ClientMetadata resultingClientMetadata = this.retrieve(resource.getClientId());
        if (updated > 1) {
            throw new IncorrectResultSizeDataAccessException(1);
        }
        return resultingClientMetadata;
    }

    protected void updateClientNameIfNotEmpty(ClientMetadata resource) {
        if (StringUtils.hasText((String)resource.getClientName())) {
            BaseClientDetails client = (BaseClientDetails)this.clientDetailsService.loadClientByClientId(resource.getClientId());
            client.addAdditionalInformation("name", (Object)resource.getClientName());
            this.clientRegistrationService.updateClientDetails((ClientDetails)client);
        }
    }

    private class ClientMetadataRowMapper
    implements RowMapper<ClientMetadata> {
        private ClientMetadataRowMapper() {
        }

        public ClientMetadata mapRow(ResultSet rs, int rowNum) throws SQLException {
            String json;
            ClientMetadata clientMetadata = new ClientMetadata();
            int pos = 1;
            clientMetadata.setClientId(rs.getString(pos++));
            clientMetadata.setIdentityZoneId(rs.getString(pos++));
            clientMetadata.setShowOnHomePage(rs.getBoolean(pos++));
            try {
                clientMetadata.setAppLaunchUrl(new URL(rs.getString(pos++)));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            byte[] iconBytes = rs.getBytes(pos++);
            if (iconBytes != null) {
                clientMetadata.setAppIcon(new String(Base64Utils.encode((byte[])iconBytes)));
            }
            if (StringUtils.hasText((String)(json = rs.getString(pos++)))) {
                Map additionalInformation = (Map)JsonUtils.readValue((String)json, (TypeReference)new TypeReference<Map<String, Object>>(){});
                clientMetadata.setClientName((String)additionalInformation.get("name"));
            }
            return clientMetadata;
        }
    }
}

