/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider.saml;

import org.cloudfoundry.identity.uaa.provider.SamlIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.util.UaaUrlUtils;
import org.springframework.web.util.UriComponentsBuilder;

public class SamlRedirectUtils {
    public static String getIdpRedirectUrl(SamlIdentityProviderDefinition definition, String entityId) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromPath((String)"saml/discovery");
        builder.queryParam("returnIDParam", new Object[]{"idp"});
        builder.queryParam("entityID", new Object[]{SamlRedirectUtils.getZonifiedEntityId(entityId)});
        builder.queryParam("idp", new Object[]{definition.getIdpEntityAlias()});
        builder.queryParam("isPassive", new Object[]{"true"});
        return builder.build().toUriString();
    }

    public static String getZonifiedEntityId(String entityID) {
        if (UaaUrlUtils.isUrl(entityID)) {
            return UaaUrlUtils.addSubdomainToUrl(entityID);
        }
        return UaaUrlUtils.getSubdomain() + entityID;
    }
}

