/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.security;

import javax.servlet.http.HttpServletRequest;
import org.cloudfoundry.identity.uaa.authentication.UaaPrincipal;
import org.cloudfoundry.identity.uaa.oauth.token.RevocableToken;
import org.cloudfoundry.identity.uaa.oauth.token.RevocableTokenProvisioning;
import org.cloudfoundry.identity.uaa.util.UaaUrlUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.util.StringUtils;

public class IsSelfCheck {
    private final RevocableTokenProvisioning tokenProvisioning;

    public IsSelfCheck(RevocableTokenProvisioning tokenProvisioning) {
        this.tokenProvisioning = tokenProvisioning;
    }

    public boolean isUserSelf(HttpServletRequest request, int pathParameterIndex) {
        String pathInfo = UaaUrlUtils.getRequestPath(request);
        if (!StringUtils.hasText((String)pathInfo)) {
            return false;
        }
        String idFromUrl = this.extractIdFromUrl(pathParameterIndex, pathInfo);
        if (idFromUrl == null) {
            return false;
        }
        String idFromAuth = this.extractIdFromAuthentication(SecurityContextHolder.getContext().getAuthentication(), false);
        if (idFromAuth == null) {
            return false;
        }
        return idFromAuth.equals(idFromUrl);
    }

    protected String extractIdFromAuthentication(Authentication authentication, boolean clientAuthenticationAllowed) {
        if (authentication == null) {
            return null;
        }
        if (authentication.getPrincipal() instanceof UaaPrincipal) {
            return ((UaaPrincipal)authentication.getPrincipal()).getId();
        }
        if (authentication instanceof OAuth2Authentication) {
            OAuth2Authentication a = (OAuth2Authentication)authentication;
            if (a.isClientOnly()) {
                return clientAuthenticationAllowed ? a.getOAuth2Request().getClientId() : null;
            }
            if (a.getUserAuthentication().getPrincipal() instanceof UaaPrincipal) {
                return ((UaaPrincipal)a.getUserAuthentication().getPrincipal()).getId();
            }
        }
        return null;
    }

    protected String extractIdFromUrl(int pathParameterIndex, String pathInfo) {
        return UaaUrlUtils.extractPathVariableFromUrl(pathParameterIndex, pathInfo);
    }

    public boolean isTokenRevocationForSelf(HttpServletRequest request) {
        String pathInfo = UaaUrlUtils.getRequestPath(request);
        if (!StringUtils.hasText((String)pathInfo)) {
            return false;
        }
        String tokenId = this.extractIdFromUrl(3, pathInfo);
        if (tokenId == null) {
            return false;
        }
        String idFromAuth = this.extractIdFromAuthentication(SecurityContextHolder.getContext().getAuthentication(), true);
        if (idFromAuth == null) {
            return false;
        }
        RevocableToken revocableToken = (RevocableToken)this.tokenProvisioning.retrieve(tokenId);
        String subjectId = revocableToken.getUserId() != null ? revocableToken.getUserId() : revocableToken.getClientId();
        return idFromAuth.equals(subjectId);
    }
}

