/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.approval;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cloudfoundry.identity.uaa.approval.Approval;
import org.cloudfoundry.identity.uaa.approval.ApprovalsControllerService;
import org.cloudfoundry.identity.uaa.approval.ApprovalsService;
import org.cloudfoundry.identity.uaa.approval.DescribedApproval;
import org.springframework.beans.factory.annotation.Autowired;

public class LoginUaaApprovalsService
implements ApprovalsService {
    @Autowired
    private ApprovalsControllerService approvalsAdminEndpoints;

    @Override
    public Map<String, List<DescribedApproval>> getCurrentApprovalsByClientId() {
        HashMap<String, List<DescribedApproval>> result = new HashMap<String, List<DescribedApproval>>();
        List<Approval> approvalsResponse = this.approvalsAdminEndpoints.getApprovals("user_id pr", 1, 1000);
        ArrayList<DescribedApproval> approvals = new ArrayList<DescribedApproval>();
        for (Approval approval : approvalsResponse) {
            DescribedApproval describedApproval = new DescribedApproval(approval);
            approvals.add(describedApproval);
        }
        for (DescribedApproval describedApproval : approvals) {
            String scope;
            ArrayList<DescribedApproval> clientApprovals = (ArrayList<DescribedApproval>)result.get(describedApproval.getClientId());
            if (clientApprovals == null) {
                clientApprovals = new ArrayList<DescribedApproval>();
                result.put(describedApproval.getClientId(), clientApprovals);
            }
            if (!(scope = describedApproval.getScope()).contains(".")) {
                describedApproval.setDescription("Access your data with scope '" + scope + "'");
                clientApprovals.add(describedApproval);
                continue;
            }
            String resource = scope.substring(0, scope.lastIndexOf("."));
            if ("uaa".equals(resource)) continue;
            String access = scope.substring(scope.lastIndexOf(".") + 1);
            describedApproval.setDescription("Access your '" + resource + "' resources with scope '" + access + "'");
            clientApprovals.add(describedApproval);
        }
        for (List list : result.values()) {
            Collections.sort(list, new Comparator<DescribedApproval>(){

                @Override
                public int compare(DescribedApproval o1, DescribedApproval o2) {
                    return o1.getScope().compareTo(o2.getScope());
                }
            });
        }
        return result;
    }

    @Override
    public void updateApprovals(List<DescribedApproval> approvals) {
        this.approvalsAdminEndpoints.updateApprovals(approvals.toArray(new DescribedApproval[approvals.size()]));
    }

    @Override
    public void deleteApprovalsForClient(String clientId) {
        this.approvalsAdminEndpoints.revokeApprovals(clientId);
    }
}

