/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider.ldap;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedHashMap;
import java.util.Map;

public class ProcessLdapProperties {
    public static final String LDAP_SOCKET_FACTORY = "java.naming.ldap.factory.socket";
    public static final String SKIP_SSL_VERIFICATION_SOCKET_FACTORY = "org.apache.directory.api.util.DummySSLSocketFactory";
    public static final String EXPIRY_CHECKING_SOCKET_FACTORY = "org.cloudfoundry.identity.uaa.security.LdapSocketFactory";
    private boolean disableSslVerification;
    private String baseUrl;

    public ProcessLdapProperties(String baseUrl, boolean disableSslVerification) {
        this.baseUrl = baseUrl;
        this.disableSslVerification = disableSslVerification;
    }

    public Map process(Map map) throws KeyManagementException, NoSuchAlgorithmException {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(map);
        if (this.isLdapsUrl()) {
            if (this.isDisableSslVerification()) {
                result.put(LDAP_SOCKET_FACTORY, SKIP_SSL_VERIFICATION_SOCKET_FACTORY);
            } else {
                result.put(LDAP_SOCKET_FACTORY, EXPIRY_CHECKING_SOCKET_FACTORY);
            }
        }
        return result;
    }

    public boolean isLdapsUrl() {
        return this.baseUrl != null && this.baseUrl.startsWith("ldaps");
    }

    public boolean isDisableSslVerification() {
        return this.disableSslVerification;
    }

    public void setDisableSslVerification(boolean disableSslVerification) {
        this.disableSslVerification = disableSslVerification;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }
}

