/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.scim.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Timestamp;
import java.util.HashMap;
import org.cloudfoundry.identity.uaa.codestore.ExpiringCode;
import org.cloudfoundry.identity.uaa.codestore.ExpiringCodeStore;
import org.cloudfoundry.identity.uaa.codestore.ExpiringCodeType;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.cloudfoundry.identity.uaa.util.UaaUrlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public final class ScimUtils {
    private static final Logger logger = LoggerFactory.getLogger(ScimUtils.class);

    private ScimUtils() {
    }

    public static ExpiringCode getExpiringCode(ExpiringCodeStore codeStore, String userId, String email, String clientId, String redirectUri, ExpiringCodeType intent) {
        Assert.notNull((Object)codeStore);
        Assert.notNull((Object)userId);
        Assert.notNull((Object)email);
        Assert.notNull((Object)((Object)intent));
        HashMap<String, String> codeData = new HashMap<String, String>();
        codeData.put("user_id", userId);
        codeData.put("email", email);
        codeData.put("client_id", clientId);
        if (redirectUri != null) {
            codeData.put("redirect_uri", redirectUri);
        }
        String codeDataString = JsonUtils.writeValueAsString(codeData);
        Timestamp expiresAt = new Timestamp(System.currentTimeMillis() + 3600000L);
        return codeStore.generateCode(codeDataString, expiresAt, intent.name());
    }

    public static URL getVerificationURL(ExpiringCode expiringCode) {
        String url = "";
        try {
            url = UaaUrlUtils.getUaaUrl("/verify_user");
            if (expiringCode != null) {
                url = url + "?code=" + expiringCode.getCode();
            }
            return new URL(url);
        }
        catch (MalformedURLException mfue) {
            logger.error(String.format("Unexpected error creating user verification URL from %s", url), (Throwable)mfue);
            throw new IllegalStateException();
        }
    }
}

