/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.security;

import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.security.web.authentication.WebAuthenticationDetails;

public class SavedRequestAwareAuthenticationDetails
extends WebAuthenticationDetails
implements Serializable {
    private static final long serialVersionUID = 3801124242820219132L;
    private Object savedRequest;

    public SavedRequestAwareAuthenticationDetails(HttpServletRequest request) {
        super(request);
        HttpSession session = request.getSession(false);
        if (session != null) {
            this.savedRequest = session.getAttribute("SPRING_SECURITY_SAVED_REQUEST");
        }
    }

    public Object getSavedRequest() {
        return this.savedRequest;
    }

    public void setSavedRequest(Object savedRequest) {
        this.savedRequest = savedRequest;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SavedRequestAwareAuthenticationDetails)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SavedRequestAwareAuthenticationDetails that = (SavedRequestAwareAuthenticationDetails)o;
        return !(this.savedRequest != null ? !this.savedRequest.equals(that.savedRequest) : that.savedRequest != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.savedRequest != null ? this.savedRequest.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString()).append(": ");
        sb.append("SavedRequest: ").append(this.getSavedRequest());
        return sb.toString();
    }
}

