/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.zone;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.audit.event.SystemDeletable;
import org.cloudfoundry.identity.uaa.resources.ResourceMonitor;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.security.crypto.password.NoOpPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.common.exceptions.InvalidClientException;
import org.springframework.security.oauth2.common.util.DefaultJdbcListFactory;
import org.springframework.security.oauth2.common.util.JdbcListFactory;
import org.springframework.security.oauth2.provider.ClientAlreadyExistsException;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.ClientRegistrationService;
import org.springframework.security.oauth2.provider.NoSuchClientException;
import org.springframework.security.oauth2.provider.client.BaseClientDetails;
import org.springframework.security.oauth2.provider.client.JdbcClientDetailsService;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class MultitenantJdbcClientDetailsService
extends JdbcClientDetailsService
implements ClientDetailsService,
ClientRegistrationService,
ResourceMonitor<ClientDetails>,
SystemDeletable {
    private static final Log logger = LogFactory.getLog(MultitenantJdbcClientDetailsService.class);
    private static final String CLIENT_FIELDS_FOR_UPDATE = "resource_ids, scope, authorized_grant_types, web_server_redirect_uri, authorities, access_token_validity, refresh_token_validity, additional_information, autoapprove, lastmodified";
    private static final String CLIENT_FIELDS = "client_secret, resource_ids, scope, authorized_grant_types, web_server_redirect_uri, authorities, access_token_validity, refresh_token_validity, additional_information, autoapprove, lastmodified";
    private static final String BASE_FIND_STATEMENT = "select client_id, client_secret, resource_ids, scope, authorized_grant_types, web_server_redirect_uri, authorities, access_token_validity, refresh_token_validity, additional_information, autoapprove, lastmodified from oauth_client_details";
    private static final String DEFAULT_FIND_STATEMENT = "select client_id, client_secret, resource_ids, scope, authorized_grant_types, web_server_redirect_uri, authorities, access_token_validity, refresh_token_validity, additional_information, autoapprove, lastmodified from oauth_client_details where identity_zone_id = :identityZoneId order by client_id";
    private static final String DEFAULT_SELECT_STATEMENT = "select client_id, client_secret, resource_ids, scope, authorized_grant_types, web_server_redirect_uri, authorities, access_token_validity, refresh_token_validity, additional_information, autoapprove, lastmodified from oauth_client_details where client_id = ? and identity_zone_id = ?";
    private static final String DEFAULT_INSERT_STATEMENT = "insert into oauth_client_details (client_secret, resource_ids, scope, authorized_grant_types, web_server_redirect_uri, authorities, access_token_validity, refresh_token_validity, additional_information, autoapprove, lastmodified, client_id, identity_zone_id) values (?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String DEFAULT_UPDATE_STATEMENT = "update oauth_client_details set " + "resource_ids, scope, authorized_grant_types, web_server_redirect_uri, authorities, access_token_validity, refresh_token_validity, additional_information, autoapprove, lastmodified".replaceAll(", ", "=?, ") + "=? where client_id = ? and identity_zone_id = ?";
    private static final String DEFAULT_UPDATE_SECRET_STATEMENT = "update oauth_client_details set client_secret = ? where client_id = ? and identity_zone_id = ?";
    private static final String DEFAULT_DELETE_STATEMENT = "delete from oauth_client_details where client_id = ? and identity_zone_id = ?";
    private static final String DELETE_CLIENTS_BY_ZONE = "delete from oauth_client_details where identity_zone_id = ?";
    private static final String DELETE_CLIENT_APPROVALS_BY_ZONE = "delete from authz_approvals where client_id in (select client_id from oauth_client_details where identity_zone_id = ?)";
    private RowMapper<ClientDetails> rowMapper = new ClientDetailsRowMapper();
    private String deleteClientDetailsSql = "delete from oauth_client_details where client_id = ? and identity_zone_id = ?";
    private String findClientDetailsSql = "select client_id, client_secret, resource_ids, scope, authorized_grant_types, web_server_redirect_uri, authorities, access_token_validity, refresh_token_validity, additional_information, autoapprove, lastmodified from oauth_client_details where identity_zone_id = :identityZoneId order by client_id";
    private String updateClientDetailsSql = DEFAULT_UPDATE_STATEMENT;
    private String updateClientSecretSql = "update oauth_client_details set client_secret = ? where client_id = ? and identity_zone_id = ?";
    private String insertClientDetailsSql = "insert into oauth_client_details (client_secret, resource_ids, scope, authorized_grant_types, web_server_redirect_uri, authorities, access_token_validity, refresh_token_validity, additional_information, autoapprove, lastmodified, client_id, identity_zone_id) values (?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private String selectClientDetailsSql = "select client_id, client_secret, resource_ids, scope, authorized_grant_types, web_server_redirect_uri, authorities, access_token_validity, refresh_token_validity, additional_information, autoapprove, lastmodified from oauth_client_details where client_id = ? and identity_zone_id = ?";
    private PasswordEncoder passwordEncoder = NoOpPasswordEncoder.getInstance();
    private final JdbcTemplate jdbcTemplate;
    private JdbcListFactory listFactory;

    public MultitenantJdbcClientDetailsService(DataSource dataSource) {
        super(dataSource);
        Assert.notNull((Object)dataSource, (String)"DataSource required");
        this.jdbcTemplate = new JdbcTemplate(dataSource);
        this.listFactory = new DefaultJdbcListFactory((NamedParameterJdbcOperations)new NamedParameterJdbcTemplate((JdbcOperations)this.jdbcTemplate));
    }

    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    public ClientDetails loadClientByClientId(String clientId) throws InvalidClientException {
        ClientDetails details;
        try {
            details = (ClientDetails)this.jdbcTemplate.queryForObject(this.selectClientDetailsSql, (RowMapper)new ClientDetailsRowMapper(), new Object[]{clientId, IdentityZoneHolder.get().getId()});
        }
        catch (EmptyResultDataAccessException e) {
            throw new NoSuchClientException("No client with requested id: " + clientId);
        }
        return details;
    }

    public void addClientDetails(ClientDetails clientDetails) throws ClientAlreadyExistsException {
        try {
            this.jdbcTemplate.update(this.insertClientDetailsSql, this.getFields(clientDetails));
        }
        catch (DuplicateKeyException e) {
            throw new ClientAlreadyExistsException("Client already exists: " + clientDetails.getClientId(), (Throwable)e);
        }
    }

    public void updateClientDetails(ClientDetails clientDetails) throws NoSuchClientException {
        int count = this.jdbcTemplate.update(this.updateClientDetailsSql, this.getFieldsForUpdate(clientDetails));
        if (count != 1) {
            throw new NoSuchClientException("No client found with id = " + clientDetails.getClientId() + " in identity zone " + IdentityZoneHolder.get().getName());
        }
    }

    public void updateClientSecret(String clientId, String secret) throws NoSuchClientException {
        int count = this.jdbcTemplate.update(this.updateClientSecretSql, new Object[]{this.passwordEncoder.encode((CharSequence)secret), clientId, IdentityZoneHolder.get().getId()});
        if (count != 1) {
            throw new NoSuchClientException("No client found with id = " + clientId);
        }
    }

    public void removeClientDetails(String clientId) throws NoSuchClientException {
        int count = this.jdbcTemplate.update(this.deleteClientDetailsSql, new Object[]{clientId, IdentityZoneHolder.get().getId()});
        if (count != 1) {
            throw new NoSuchClientException("No client found with id = " + clientId);
        }
    }

    public List<ClientDetails> listClientDetails() {
        return this.listFactory.getList(this.findClientDetailsSql, Collections.singletonMap("identityZoneId", IdentityZoneHolder.get().getId()), this.rowMapper);
    }

    private Object[] getFields(ClientDetails clientDetails) {
        Object[] fieldsForUpdate = this.getFieldsForUpdate(clientDetails);
        Object[] fields = new Object[fieldsForUpdate.length + 1];
        System.arraycopy(fieldsForUpdate, 0, fields, 1, fieldsForUpdate.length);
        fields[0] = clientDetails.getClientSecret() != null ? this.passwordEncoder.encode((CharSequence)clientDetails.getClientSecret()) : null;
        return fields;
    }

    private Object[] getFieldsForUpdate(ClientDetails clientDetails) {
        String json = null;
        try {
            json = JsonUtils.writeValueAsString((Object)clientDetails.getAdditionalInformation());
        }
        catch (Exception e) {
            logger.warn((Object)("Could not serialize additional information: " + clientDetails), (Throwable)e);
            throw new InvalidDataAccessResourceUsageException("Could not serialize additional information:" + clientDetails.getClientId(), (Throwable)e);
        }
        return new Object[]{clientDetails.getResourceIds() != null ? StringUtils.collectionToCommaDelimitedString((Collection)clientDetails.getResourceIds()) : null, clientDetails.getScope() != null ? StringUtils.collectionToCommaDelimitedString((Collection)clientDetails.getScope()) : null, clientDetails.getAuthorizedGrantTypes() != null ? StringUtils.collectionToCommaDelimitedString((Collection)clientDetails.getAuthorizedGrantTypes()) : null, clientDetails.getRegisteredRedirectUri() != null ? StringUtils.collectionToCommaDelimitedString((Collection)clientDetails.getRegisteredRedirectUri()) : null, clientDetails.getAuthorities() != null ? StringUtils.collectionToCommaDelimitedString((Collection)clientDetails.getAuthorities()) : null, clientDetails.getAccessTokenValiditySeconds(), clientDetails.getRefreshTokenValiditySeconds(), json, this.getAutoApproveScopes(clientDetails), new Timestamp(System.currentTimeMillis()), clientDetails.getClientId(), IdentityZoneHolder.get().getId()};
    }

    private String getAutoApproveScopes(ClientDetails clientDetails) {
        if (clientDetails.isAutoApprove("true")) {
            return "true";
        }
        HashSet<String> scopes = new HashSet<String>();
        for (String scope : clientDetails.getScope()) {
            if (!clientDetails.isAutoApprove(scope)) continue;
            scopes.add(scope);
        }
        return StringUtils.collectionToCommaDelimitedString(scopes);
    }

    public void setSelectClientDetailsSql(String selectClientDetailsSql) {
        this.selectClientDetailsSql = selectClientDetailsSql;
    }

    public void setDeleteClientDetailsSql(String deleteClientDetailsSql) {
        this.deleteClientDetailsSql = deleteClientDetailsSql;
    }

    public void setUpdateClientDetailsSql(String updateClientDetailsSql) {
        this.updateClientDetailsSql = updateClientDetailsSql;
    }

    public void setUpdateClientSecretSql(String updateClientSecretSql) {
        this.updateClientSecretSql = updateClientSecretSql;
    }

    public void setInsertClientDetailsSql(String insertClientDetailsSql) {
        this.insertClientDetailsSql = insertClientDetailsSql;
    }

    public void setFindClientDetailsSql(String findClientDetailsSql) {
        this.findClientDetailsSql = findClientDetailsSql;
    }

    public void setListFactory(JdbcListFactory listFactory) {
        this.listFactory = listFactory;
    }

    public void setRowMapper(RowMapper<ClientDetails> rowMapper) {
        this.rowMapper = rowMapper;
    }

    @Override
    public int deleteByIdentityZone(String zoneId) {
        this.jdbcTemplate.update(DELETE_CLIENT_APPROVALS_BY_ZONE, new Object[]{zoneId});
        return this.jdbcTemplate.update(DELETE_CLIENTS_BY_ZONE, new Object[]{zoneId});
    }

    @Override
    public int deleteByOrigin(String origin, String zoneId) {
        return 0;
    }

    @Override
    public Log getLogger() {
        return logger;
    }

    @Override
    public int getTotalCount() {
        Integer count = (Integer)this.jdbcTemplate.queryForObject("select count(*) from oauth_client_details", Integer.class);
        if (count != null) {
            return count;
        }
        return 0;
    }

    private static class ClientDetailsRowMapper
    implements RowMapper<ClientDetails> {
        private ClientDetailsRowMapper() {
        }

        public ClientDetails mapRow(ResultSet rs, int rowNum) throws SQLException {
            String scopes;
            String json;
            BaseClientDetails details = new BaseClientDetails(rs.getString(1), rs.getString(3), rs.getString(4), rs.getString(5), rs.getString(7), rs.getString(6));
            details.setClientSecret(rs.getString(2));
            if (rs.getObject(8) != null) {
                details.setAccessTokenValiditySeconds(Integer.valueOf(rs.getInt(8)));
            }
            if (rs.getObject(9) != null) {
                details.setRefreshTokenValiditySeconds(Integer.valueOf(rs.getInt(9)));
            }
            if ((json = rs.getString(10)) != null) {
                try {
                    Map additionalInformation = (Map)JsonUtils.readValue((String)json, Map.class);
                    details.setAdditionalInformation(additionalInformation);
                }
                catch (Exception e) {
                    logger.warn((Object)("Could not decode JSON for additional information: " + details), (Throwable)e);
                }
            }
            if ((scopes = rs.getString(11)) != null) {
                details.setAutoApproveScopes((Collection)StringUtils.commaDelimitedListToSet((String)scopes));
            }
            if (rs.getObject(12) != null) {
                details.addAdditionalInformation("lastModified", (Object)rs.getTimestamp(12));
            }
            return details;
        }
    }
}

