/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.approval;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.approval.Approval;
import org.cloudfoundry.identity.uaa.approval.ApprovalStore;
import org.cloudfoundry.identity.uaa.approval.ApprovalsControllerService;
import org.cloudfoundry.identity.uaa.error.UaaException;
import org.cloudfoundry.identity.uaa.resources.ActionResult;
import org.cloudfoundry.identity.uaa.security.DefaultSecurityContextAccessor;
import org.cloudfoundry.identity.uaa.security.SecurityContextAccessor;
import org.cloudfoundry.identity.uaa.user.UaaUserDatabase;
import org.cloudfoundry.identity.uaa.util.UaaPagingUtils;
import org.cloudfoundry.identity.uaa.web.ConvertingExceptionView;
import org.cloudfoundry.identity.uaa.web.ExceptionReport;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.View;

@Controller
public class ApprovalsAdminEndpoints
implements InitializingBean,
ApprovalsControllerService {
    private ApprovalStore approvalStore = null;
    private ClientDetailsService clientDetailsService = null;
    private UaaUserDatabase userDatabase;
    private Map<Class<? extends Exception>, HttpStatus> statuses = new HashMap<Class<? extends Exception>, HttpStatus>();
    private HttpMessageConverter<?>[] messageConverters = new RestTemplate().getMessageConverters().toArray(new HttpMessageConverter[0]);
    private final Log logger = LogFactory.getLog(this.getClass());
    private SecurityContextAccessor securityContextAccessor = new DefaultSecurityContextAccessor();
    private static final String USER_FILTER_TEMPLATE = "user_id eq \"%s\"";
    private static final String USER_AND_CLIENT_FILTER_TEMPLATE = "user_id eq \"%s\" and client_id eq \"%s\"";

    public void setStatuses(Map<Class<? extends Exception>, HttpStatus> statuses) {
        this.statuses = statuses;
    }

    public void setMessageConverters(HttpMessageConverter<?>[] messageConverters) {
        this.messageConverters = messageConverters;
    }

    public void setSecurityContextAccessor(SecurityContextAccessor securityContextAccessor) {
        this.securityContextAccessor = securityContextAccessor;
    }

    public void setApprovalStore(ApprovalStore approvalStore) {
        this.approvalStore = approvalStore;
    }

    public void setUaaUserDatabase(UaaUserDatabase userDatabase) {
        this.userDatabase = userDatabase;
    }

    @Override
    @RequestMapping(value={"/approvals"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Approval> getApprovals(@RequestParam(required=false, defaultValue="user_id pr") String filter, @RequestParam(required=false, defaultValue="1") int startIndex, @RequestParam(required=false, defaultValue="100") int count) {
        String userId = this.getCurrentUserId();
        this.logger.debug((Object)("Fetching all approvals for user: " + userId));
        List<Approval> input = this.approvalStore.getApprovals(String.format("%s and user_id eq \"%s\"", filter, userId));
        List<Approval> approvals = UaaPagingUtils.subList(input, startIndex, count);
        HashSet<String> clientIds = new HashSet<String>();
        for (Approval approval : approvals) {
            clientIds.add(approval.getClientId());
        }
        HashMap clientAutoApprovedScopes = new HashMap();
        for (String clientId : clientIds) {
            ClientDetails client = this.clientDetailsService.loadClientByClientId(clientId);
            Map additionalInfo = client.getAdditionalInformation();
            Object autoApproved = additionalInfo.get("autoapprove");
            HashSet autoApprovedScopes = new HashSet();
            if (autoApproved instanceof Collection) {
                Collection scopes = (Collection)autoApproved;
                autoApprovedScopes.addAll(scopes);
            } else if (autoApproved instanceof Boolean && ((Boolean)autoApproved).booleanValue() || "true".equals(autoApproved)) {
                autoApprovedScopes.addAll(client.getScope());
            }
            clientAutoApprovedScopes.put(clientId, autoApprovedScopes);
        }
        ArrayList<Approval> arrayList = new ArrayList<Approval>();
        for (Approval approval : approvals) {
            if (clientAutoApprovedScopes.containsKey(approval.getClientId()) && ((Set)clientAutoApprovedScopes.get(approval.getClientId())).contains(approval.getScope())) continue;
            arrayList.add(approval);
        }
        return arrayList;
    }

    private String getCurrentUserId() {
        if (!this.securityContextAccessor.isUser()) {
            throw new AccessDeniedException("Approvals can only be managed by a user");
        }
        return this.securityContextAccessor.getUserId();
    }

    @Override
    @RequestMapping(value={"/approvals"}, method={RequestMethod.PUT})
    @ResponseBody
    public List<Approval> updateApprovals(@RequestBody Approval[] approvals) {
        String currentUserId = this.getCurrentUserId();
        this.logger.debug((Object)("Updating approvals for user: " + currentUserId));
        this.approvalStore.revokeApprovals(String.format(USER_FILTER_TEMPLATE, currentUserId));
        for (Approval approval : approvals) {
            if (StringUtils.hasText((String)approval.getUserId()) && !this.isValidUser(approval.getUserId())) {
                this.logger.warn((Object)String.format("Error[2] %s attempting to update approvals for %s", currentUserId, approval.getUserId()));
                throw new UaaException("unauthorized_operation", "Cannot update approvals for another user. Set user_id to null to update for existing user.", HttpStatus.UNAUTHORIZED.value());
            }
            approval.setUserId(currentUserId);
            this.approvalStore.addApproval(approval);
        }
        return this.approvalStore.getApprovals(String.format(USER_FILTER_TEMPLATE, currentUserId));
    }

    @Override
    @RequestMapping(value={"/approvals/{clientId}"}, method={RequestMethod.PUT})
    @ResponseBody
    public List<Approval> updateClientApprovals(@PathVariable String clientId, @RequestBody Approval[] approvals) {
        String currentUserId = this.getCurrentUserId();
        this.logger.debug((Object)("Updating approvals for user: " + currentUserId));
        this.approvalStore.revokeApprovals(String.format(USER_AND_CLIENT_FILTER_TEMPLATE, currentUserId, clientId));
        for (Approval approval : approvals) {
            if (StringUtils.hasText((String)approval.getUserId()) && !this.isValidUser(approval.getUserId())) {
                this.logger.warn((Object)String.format("Error[1] %s attemting to update approvals for %s.", currentUserId, approval.getUserId()));
                throw new UaaException("unauthorized_operation", "Cannot update approvals for another user. Set user_id to null to update for existing user.", HttpStatus.UNAUTHORIZED.value());
            }
            approval.setUserId(currentUserId);
            this.approvalStore.addApproval(approval);
        }
        return this.approvalStore.getApprovals(String.format(USER_AND_CLIENT_FILTER_TEMPLATE, currentUserId, clientId));
    }

    private boolean isValidUser(String userId) {
        if (userId == null || !userId.equals(this.getCurrentUserId())) {
            return false;
        }
        try {
            this.userDatabase.retrieveUserById(userId);
            return true;
        }
        catch (UsernameNotFoundException e) {
            return false;
        }
    }

    @Override
    @RequestMapping(value={"/approvals"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ActionResult revokeApprovals(@RequestParam(required=true) String clientId) {
        String username = this.getCurrentUserId();
        this.logger.debug((Object)("Revoking all existing approvals for user: " + username + " and client " + clientId));
        this.approvalStore.revokeApprovals(String.format(USER_AND_CLIENT_FILTER_TEMPLATE, username, clientId));
        return new ActionResult("ok", "Approvals of user " + username + " and client " + clientId + " revoked");
    }

    @ExceptionHandler
    public View handleException(Exception t) {
        UaaException e = t instanceof UaaException ? (UaaException)t : new UaaException("Unexpected error", "Error accessing user's approvals", HttpStatus.INTERNAL_SERVER_ERROR.value());
        Class<?> clazz = t.getClass();
        for (Class<? extends Exception> key : this.statuses.keySet()) {
            if (!key.isAssignableFrom(clazz)) continue;
            e = new UaaException(t.getMessage(), "Error accessing user's approvals", this.statuses.get(key).value());
            break;
        }
        return new ConvertingExceptionView((ResponseEntity<? extends ExceptionReport>)new ResponseEntity((Object)new ExceptionReport(e, false), HttpStatus.valueOf((int)e.getHttpStatus())), this.messageConverters);
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.approvalStore, (String)"Please supply an approvals manager");
        Assert.notNull((Object)this.userDatabase, (String)"Please supply a user database");
    }

    public void setClientDetailsService(ClientDetailsService clientDetailsService) {
        this.clientDetailsService = clientDetailsService;
    }
}

