/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.authentication;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.cloudfoundry.identity.uaa.util.UaaStringUtils;

public class UTF8ConversionFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        if ("application/x-www-form-urlencoded".equals(request.getContentType()) && (request.getCharacterEncoding() == null || "ISO-8859-1".equalsIgnoreCase(request.getCharacterEncoding()))) {
            chain.doFilter((ServletRequest)new UtfConverterRequestWrapper(request), (ServletResponse)response);
        } else {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    public void destroy() {
    }

    public static class UtfConverterRequestWrapper
    extends HttpServletRequestWrapper {
        public UtfConverterRequestWrapper(HttpServletRequest request) {
            super(request);
        }

        public String getParameter(String name) {
            return UaaStringUtils.convertISO8859_1_to_UTF_8(super.getParameter(name));
        }

        public String[] getParameterValues(String name) {
            String[] values = super.getParameterValues(name);
            if (values == null || values.length == 0) {
                return values;
            }
            String[] result = new String[values.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = UaaStringUtils.convertISO8859_1_to_UTF_8(values[i]);
            }
            return result;
        }

        public Map<String, String[]> getParameterMap() {
            HashMap<String, String[]> map = new HashMap<String, String[]>();
            Enumeration names = this.getParameterNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                map.put(name, this.getParameterValues(name));
            }
            return map;
        }
    }
}

