/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.resources.jdbc;

import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.resources.Queryable;
import org.cloudfoundry.identity.uaa.resources.jdbc.JdbcPagingListFactory;
import org.cloudfoundry.identity.uaa.resources.jdbc.SearchQueryConverter;
import org.cloudfoundry.identity.uaa.resources.jdbc.SimpleSearchQueryConverter;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.util.StringUtils;

public abstract class AbstractQueryable<T>
implements Queryable<T> {
    private NamedParameterJdbcTemplate jdbcTemplate;
    private JdbcPagingListFactory pagingListFactory;
    protected RowMapper<T> rowMapper;
    private final Log logger = LogFactory.getLog(this.getClass());
    private SearchQueryConverter queryConverter = new SimpleSearchQueryConverter();
    private int pageSize = 200;

    protected AbstractQueryable(JdbcTemplate jdbcTemplate, JdbcPagingListFactory pagingListFactory, RowMapper<T> rowMapper) {
        this.jdbcTemplate = new NamedParameterJdbcTemplate((JdbcOperations)jdbcTemplate);
        this.pagingListFactory = pagingListFactory;
        this.rowMapper = rowMapper;
    }

    public void setQueryConverter(SearchQueryConverter queryConverter) {
        this.queryConverter = queryConverter;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public int delete(String filter) {
        SearchQueryConverter.ProcessedFilter where = this.queryConverter.convert(filter, null, false);
        this.logger.debug((Object)("Filtering groups with SQL: " + where));
        try {
            String completeSql = "DELETE FROM " + this.getTableName() + " WHERE " + where.getSql();
            this.logger.debug((Object)("delete sql: " + completeSql + ", params: " + where.getParams()));
            return this.jdbcTemplate.update(completeSql, where.getParams());
        }
        catch (DataAccessException e) {
            this.logger.debug((Object)("Filter '" + filter + "' generated invalid SQL"), (Throwable)e);
            throw new IllegalArgumentException("Invalid delete filter: " + filter);
        }
    }

    @Override
    public List<T> query(String filter) {
        return this.query(filter, null, true);
    }

    @Override
    public List<T> query(String filter, String sortBy, boolean ascending) {
        this.validateOrderBy(this.queryConverter.map(sortBy));
        SearchQueryConverter.ProcessedFilter where = this.queryConverter.convert(filter, sortBy, ascending);
        this.logger.debug((Object)("Filtering groups with SQL: " + where));
        try {
            String completeSql = this.getQuerySQL(filter, where);
            this.logger.debug((Object)("complete sql: " + completeSql + ", params: " + where.getParams()));
            List<T> result = this.pageSize > 0 && this.pageSize < Integer.MAX_VALUE ? this.pagingListFactory.createJdbcPagingList(completeSql, where.getParams(), this.rowMapper, this.pageSize) : this.jdbcTemplate.query(completeSql, where.getParams(), this.rowMapper);
            return result;
        }
        catch (DataAccessException e) {
            this.logger.debug((Object)("Filter '" + filter + "' generated invalid SQL"), (Throwable)e);
            throw new IllegalArgumentException("Invalid filter: " + filter);
        }
    }

    protected String getQuerySQL(String filter, SearchQueryConverter.ProcessedFilter where) {
        if (filter == null || filter.trim().length() == 0) {
            return this.getBaseSqlQuery();
        }
        if (where.hasOrderBy()) {
            return this.getBaseSqlQuery() + " where (" + where.getSql().replace(" ORDER BY ", ")" + " ORDER BY ");
        }
        return this.getBaseSqlQuery() + " where (" + where.getSql() + ")";
    }

    protected abstract String getBaseSqlQuery();

    protected abstract String getTableName();

    protected abstract void validateOrderBy(String var1) throws IllegalArgumentException;

    protected void validateOrderBy(String orderBy, String fields) throws IllegalArgumentException {
        if (!StringUtils.hasText((String)orderBy)) {
            return;
        }
        String[] input = StringUtils.commaDelimitedListToStringArray((String)orderBy);
        HashSet compare = new HashSet();
        StringUtils.commaDelimitedListToSet((String)fields).stream().forEach(p -> compare.add(p.toLowerCase().trim()));
        boolean allints = true;
        for (String s : input) {
            try {
                Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                allints = false;
                if (compare.contains(s.toLowerCase().trim())) continue;
                throw new IllegalArgumentException("Invalid sort field:" + s);
            }
        }
        if (allints) {
            return;
        }
    }

    public SearchQueryConverter getQueryConverter() {
        return this.queryConverter;
    }
}

