/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.cloudfoundry.identity.uaa.zone.IdentityZone;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class UaaUrlUtils {
    public static String getUaaUrl() {
        return UaaUrlUtils.getUaaUrl("");
    }

    public static String getUaaUrl(String path) {
        return UaaUrlUtils.getUaaUrl(path, false);
    }

    public static String getUaaUrl(String path, boolean zoneSwitchPossible) {
        return UaaUrlUtils.getURIBuilder(path, zoneSwitchPossible).build().toUriString();
    }

    public static String getUaaHost() {
        return UaaUrlUtils.getURIBuilder("").build().getHost();
    }

    public static UriComponentsBuilder getURIBuilder(String path) {
        return UaaUrlUtils.getURIBuilder(path, false);
    }

    public static UriComponentsBuilder getURIBuilder(String path, boolean zoneSwitchPossible) {
        UriComponentsBuilder builder = ServletUriComponentsBuilder.fromCurrentContextPath().path(path);
        if (zoneSwitchPossible) {
            String host = builder.build().getHost();
            IdentityZone current = IdentityZoneHolder.get();
            if (host != null && !IdentityZoneHolder.isUaa() && !host.startsWith(current.getSubdomain() + ".")) {
                host = current.getSubdomain() + "." + host;
                builder.host(host);
            }
        }
        return builder;
    }

    public static String findMatchingRedirectUri(Collection<String> redirectUris, String requestedRedirectUri, String fallbackRedirectUri) {
        AntPathMatcher matcher = new AntPathMatcher();
        if (redirectUris == null) {
            return requestedRedirectUri;
        }
        for (String pattern : redirectUris) {
            if (!matcher.match(pattern, requestedRedirectUri)) continue;
            return requestedRedirectUri;
        }
        return fallbackRedirectUri;
    }

    public static String getHostForURI(String uri) {
        UriComponentsBuilder b = UriComponentsBuilder.fromHttpUrl((String)uri);
        return b.build().getHost();
    }

    public static boolean isUrl(String url) {
        try {
            new URL(url);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public static String addSubdomainToUrl(String url) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)url);
        builder.host(UaaUrlUtils.getSubdomain() + builder.build().getHost());
        return builder.build().toUriString();
    }

    public static String getSubdomain() {
        String subdomain = IdentityZoneHolder.get().getSubdomain();
        if (StringUtils.hasText((String)subdomain)) {
            subdomain = subdomain + ".";
        }
        return subdomain.trim();
    }

    public static String extractPathVariableFromUrl(int pathParameterIndex, String path) {
        String[] paths;
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((paths = StringUtils.delimitedListToStringArray((String)path, (String)"/")).length != 0 && pathParameterIndex < paths.length) {
            return paths[pathParameterIndex];
        }
        return null;
    }

    public static String getRequestPath(HttpServletRequest request) {
        String servletPath = request.getServletPath();
        String pathInfo = request.getPathInfo();
        if (servletPath == null) {
            servletPath = "";
        }
        if (pathInfo == null) {
            pathInfo = "";
        }
        String path = String.format("%s%s", servletPath, pathInfo);
        return path;
    }
}

