/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.zone;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.zone.IdentityZone;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneProvisioning;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.web.filter.OncePerRequestFilter;

public class IdentityZoneResolvingFilter
extends OncePerRequestFilter
implements InitializingBean {
    private IdentityZoneProvisioning dao;
    private Set<String> defaultZoneHostnames = new HashSet<String>();
    private Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        IdentityZone identityZone = null;
        String hostname = request.getServerName();
        String subdomain = this.getSubdomain(hostname);
        if (subdomain != null) {
            try {
                identityZone = this.dao.retrieveBySubdomain(subdomain);
            }
            catch (EmptyResultDataAccessException ex) {
                this.logger.debug((Object)("Cannot find identity zone for subdomain " + subdomain));
            }
            catch (Exception ex) {
                String message = "Internal server error while fetching identity zone for subdomain" + subdomain;
                this.logger.warn((Object)message, (Throwable)ex);
                response.sendError(500, message);
                return;
            }
        }
        if (identityZone == null) {
            response.sendError(404, "Cannot find identity zone for subdomain " + subdomain);
            return;
        }
        try {
            IdentityZoneHolder.set(identityZone);
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            IdentityZoneHolder.clear();
        }
    }

    private String getSubdomain(String hostname) {
        if (this.defaultZoneHostnames.contains(hostname)) {
            return "";
        }
        for (String internalHostname : this.defaultZoneHostnames) {
            if (!hostname.endsWith("." + internalHostname)) continue;
            return hostname.substring(0, hostname.length() - internalHostname.length() - 1);
        }
        if (this.defaultZoneHostnames.size() == 1 && this.defaultZoneHostnames.contains("localhost")) {
            this.logger.debug((Object)("No root domains configured, UAA is catch-all domain for host:" + hostname));
            return "";
        }
        this.logger.debug((Object)("Unable to determine subdomain for host:" + hostname + "; root domains:" + Arrays.toString(this.defaultZoneHostnames.toArray())));
        return null;
    }

    public void setIdentityZoneProvisioning(IdentityZoneProvisioning dao) {
        this.dao = dao;
    }

    public void setAdditionalInternalHostnames(Set<String> hostnames) {
        if (hostnames != null) {
            this.defaultZoneHostnames.addAll(hostnames);
        }
    }

    public void setDefaultInternalHostnames(Set<String> hostnames) {
        this.defaultZoneHostnames.addAll(hostnames);
    }

    public synchronized void restoreDefaultHostnames(Set<String> hostnames) {
        this.defaultZoneHostnames.clear();
        this.defaultZoneHostnames.addAll(hostnames);
    }

    public Set<String> getDefaultZoneHostnames() {
        return new HashSet<String>(this.defaultZoneHostnames);
    }

    public void afterPropertiesSet() throws ServletException {
        super.afterPropertiesSet();
        this.logger.info((Object)("Zone Resolving Root domains are: " + Arrays.toString(this.getDefaultZoneHostnames().toArray())));
    }
}

