/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.oauth.token;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.audit.event.SystemDeletable;
import org.cloudfoundry.identity.uaa.oauth.token.RevocableToken;
import org.cloudfoundry.identity.uaa.oauth.token.RevocableTokenProvisioning;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.util.StringUtils;

public class JdbcRevocableTokenProvisioning
implements RevocableTokenProvisioning,
SystemDeletable {
    protected JdbcTemplate jdbcTemplate;
    protected static final String FIELDS = "token_id,client_id,user_id,format,response_type,issued_at,expires_at,scope,data,identity_zone_id";
    protected static final String UPDATE_FIELDS = "token_id,client_id,user_id,format,response_type,issued_at,expires_at,scope,data,identity_zone_id".substring("token_id,client_id,user_id,format,response_type,issued_at,expires_at,scope,data,identity_zone_id".indexOf(44) + 1, "token_id,client_id,user_id,format,response_type,issued_at,expires_at,scope,data,identity_zone_id".lastIndexOf(44)).replace(",", "=?,") + "=?";
    protected static final String TABLE = "revocable_tokens";
    protected static final String GET_QUERY = "SELECT token_id,client_id,user_id,format,response_type,issued_at,expires_at,scope,data,identity_zone_id FROM revocable_tokens WHERE token_id=? AND identity_zone_id=?";
    protected static final String UPDATE_QUERY = "UPDATE revocable_tokens SET " + UPDATE_FIELDS + " WHERE token_id=? and identity_zone_id=?";
    protected static final String INSERT_QUERY = "INSERT INTO revocable_tokens (token_id,client_id,user_id,format,response_type,issued_at,expires_at,scope,data,identity_zone_id) VALUES (?,?,?,?,?,?,?,?,?,?)";
    protected static final String DELETE_QUERY = "DELETE FROM revocable_tokens WHERE token_id=? and identity_zone_id=?";
    protected static final String DELETE_EXPIRED_QUERY = "DELETE FROM revocable_tokens WHERE expires_at < ?";
    protected static final String DELETE_BY_ZONE_QUERY = "DELETE FROM revocable_tokens WHERE identity_zone_id=?";
    protected static final Log logger = LogFactory.getLog(JdbcRevocableTokenProvisioning.class);
    protected final RowMapper<RevocableToken> rowMapper;
    protected final JdbcTemplate template;
    protected AtomicLong lastExpiredCheck = new AtomicLong(0L);
    protected long expirationCheckInterval = 30000L;

    protected JdbcRevocableTokenProvisioning(JdbcTemplate jdbcTemplate) {
        this.rowMapper = new RevocableTokenRowMapper();
        this.template = jdbcTemplate;
    }

    @Override
    public List<RevocableToken> retrieveAll() {
        return null;
    }

    public RevocableToken retrieve(String id, boolean checkExpired) {
        if (checkExpired) {
            this.checkExpired();
        }
        RevocableToken result = (RevocableToken)this.template.queryForObject(GET_QUERY, this.rowMapper, new Object[]{id, IdentityZoneHolder.get().getId()});
        if (checkExpired && result.getExpiresAt() < System.currentTimeMillis()) {
            this.delete(id, 0);
            throw new EmptyResultDataAccessException("Token expired.", 1);
        }
        return result;
    }

    @Override
    public RevocableToken retrieve(String id) {
        return this.retrieve(id, true);
    }

    @Override
    public RevocableToken create(RevocableToken t) {
        String zoneId = IdentityZoneHolder.get().getId();
        this.template.update(INSERT_QUERY, new Object[]{t.getTokenId(), t.getClientId(), t.getUserId(), t.getFormat(), t.getResponseType().toString(), t.getIssuedAt(), t.getExpiresAt(), t.getScope(), t.getValue(), zoneId});
        return this.retrieve(t.getTokenId(), false);
    }

    @Override
    public RevocableToken update(String id, RevocableToken t) {
        String zoneId = IdentityZoneHolder.get().getId();
        this.template.update(UPDATE_QUERY, new Object[]{t.getClientId(), t.getUserId(), t.getFormat(), t.getResponseType().toString(), t.getIssuedAt(), t.getExpiresAt(), t.getScope(), t.getValue(), id, zoneId});
        return this.retrieve(id, false);
    }

    @Override
    public RevocableToken delete(String id, int version) {
        RevocableToken previous = this.retrieve(id, false);
        this.template.update(DELETE_QUERY, new Object[]{id, IdentityZoneHolder.get().getId()});
        return previous;
    }

    @Override
    public int deleteByIdentityZone(String zoneId) {
        return this.template.update(DELETE_BY_ZONE_QUERY, new Object[]{IdentityZoneHolder.get().getId()});
    }

    @Override
    public int deleteByOrigin(String origin, String zoneId) {
        return 0;
    }

    @Override
    public Log getLogger() {
        return logger;
    }

    public long getExpirationCheckInterval() {
        return this.expirationCheckInterval;
    }

    public void setExpirationCheckInterval(long expirationCheckInterval) {
        this.expirationCheckInterval = expirationCheckInterval;
    }

    public void checkExpired() {
        long now = System.currentTimeMillis();
        if (now - this.lastExpiredCheck.getAndSet(now) > this.getExpirationCheckInterval()) {
            int removed = this.template.update(DELETE_EXPIRED_QUERY, new Object[]{now});
            logger.debug((Object)("Removed " + removed + " expired revocable tokens."));
        }
    }

    protected static final class RevocableTokenRowMapper
    implements RowMapper<RevocableToken> {
        protected RevocableTokenRowMapper() {
        }

        public RevocableToken mapRow(ResultSet rs, int rowNum) throws SQLException {
            int pos = 1;
            RevocableToken revocableToken = new RevocableToken();
            revocableToken.setTokenId(rs.getString(pos++));
            revocableToken.setClientId(rs.getString(pos++));
            revocableToken.setUserId(rs.getString(pos++));
            revocableToken.setFormat(rs.getString(pos++));
            String responseType = rs.getString(pos++);
            if (StringUtils.hasText((String)responseType)) {
                revocableToken.setResponseType(RevocableToken.TokenType.valueOf((String)responseType));
            }
            revocableToken.setIssuedAt(rs.getLong(pos++));
            revocableToken.setExpiresAt(rs.getLong(pos++));
            revocableToken.setScope(rs.getString(pos++));
            revocableToken.setValue(rs.getString(pos++));
            revocableToken.setZoneId(rs.getString(pos++));
            return revocableToken;
        }
    }
}

