/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider.saml;

import java.io.PrintWriter;
import javax.servlet.ServletException;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.xml.io.MarshallingException;
import org.springframework.security.saml.metadata.MetadataDisplayFilter;
import org.springframework.security.saml.metadata.MetadataGenerator;

public class ZoneAwareMetadataDisplayFilter
extends MetadataDisplayFilter {
    protected final MetadataGenerator generator;

    public ZoneAwareMetadataDisplayFilter(MetadataGenerator generator) {
        this.generator = generator;
    }

    public MetadataGenerator getGenerator() {
        return this.generator;
    }

    protected void displayMetadata(String spEntityName, PrintWriter writer) throws ServletException {
        try {
            EntityDescriptor descriptor = this.getGenerator().generateMetadata();
            if (descriptor == null) {
                throw new ServletException("Metadata entity with ID " + this.manager.getHostedSPName() + " wasn't found");
            }
            writer.print(this.getMetadataAsString(descriptor));
        }
        catch (MarshallingException e) {
            log.error("Error marshalling entity descriptor", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
        catch (Exception e) {
            log.error("Error retrieving metadata", (Throwable)e);
            throw new ServletException("Error retrieving metadata", (Throwable)e);
        }
    }
}

