/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.zone;

import org.cloudfoundry.identity.uaa.provider.saml.SamlKeyManagerFactory;
import org.cloudfoundry.identity.uaa.zone.IdentityZone;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneProvisioning;
import org.springframework.security.saml.key.KeyManager;

public class IdentityZoneHolder {
    private static IdentityZoneProvisioning provisioning;
    private static final ThreadLocal<IdentityZoneWithKeyManager> THREADLOCAL;

    public static void setProvisioning(IdentityZoneProvisioning provisioning) {
        IdentityZoneHolder.provisioning = provisioning;
    }

    public static IdentityZone get() {
        return THREADLOCAL.get().getZone();
    }

    public static KeyManager getSamlSPKeyManager() {
        IdentityZoneWithKeyManager withKeyManager = THREADLOCAL.get();
        if (withKeyManager.getManager() == null) {
            KeyManager keyManager = SamlKeyManagerFactory.getKeyManager(withKeyManager.getZone().getConfig().getSamlConfig());
            if (keyManager == null) {
                keyManager = SamlKeyManagerFactory.getKeyManager(IdentityZoneHolder.getUaaZone().getConfig().getSamlConfig());
            }
            withKeyManager.setManager(keyManager);
        }
        return withKeyManager.getManager();
    }

    public static IdentityZone getUaaZone() {
        if (provisioning == null) {
            return IdentityZone.getUaa();
        }
        return provisioning.retrieve(IdentityZone.getUaa().getId());
    }

    public static void set(IdentityZone zone) {
        THREADLOCAL.set(new IdentityZoneWithKeyManager(zone, null));
    }

    public static void clear() {
        THREADLOCAL.remove();
    }

    public static boolean isUaa() {
        return THREADLOCAL.get().getZone().getId().equals(IdentityZone.getUaa().getId());
    }

    static {
        THREADLOCAL = new InheritableThreadLocal<IdentityZoneWithKeyManager>(){

            @Override
            protected IdentityZoneWithKeyManager initialValue() {
                if (provisioning == null) {
                    return new IdentityZoneWithKeyManager(IdentityZone.getUaa(), null);
                }
                IdentityZone zone = IdentityZoneHolder.getUaaZone();
                return new IdentityZoneWithKeyManager(zone, null);
            }
        };
    }

    public static class IdentityZoneWithKeyManager {
        private IdentityZone zone;
        private KeyManager manager;

        public IdentityZoneWithKeyManager(IdentityZone zone, KeyManager manager) {
            this.zone = zone;
            this.manager = manager;
        }

        public IdentityZone getZone() {
            return this.zone;
        }

        public KeyManager getManager() {
            return this.manager;
        }

        public void setManager(KeyManager manager) {
            this.manager = manager;
        }
    }

    public static class Initializer {
        public Initializer(IdentityZoneProvisioning provisioning) {
            IdentityZoneHolder.setProvisioning(provisioning);
        }
    }
}

