/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.approval;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.approval.Approval;
import org.cloudfoundry.identity.uaa.approval.ApprovalsService;
import org.cloudfoundry.identity.uaa.approval.DescribedApproval;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestOperations;

public class RestUaaApprovalsService
implements ApprovalsService {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final RestOperations restTemplate;
    private final String approvalsUrl;

    public RestUaaApprovalsService(RestOperations restTemplate, String approvalsUrl) {
        this.restTemplate = restTemplate;
        this.approvalsUrl = approvalsUrl;
    }

    @Override
    public Map<String, List<DescribedApproval>> getCurrentApprovalsByClientId() {
        HashMap<String, List<DescribedApproval>> result = new HashMap<String, List<DescribedApproval>>();
        ResponseEntity approvalsResponse = this.restTemplate.exchange(this.approvalsUrl, HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<Set<Approval>>(){}, new Object[0]);
        Set uaaapprovals = (Set)approvalsResponse.getBody();
        ArrayList<DescribedApproval> approvals = new ArrayList<DescribedApproval>();
        for (Approval approval : uaaapprovals) {
            DescribedApproval describedApproval = new DescribedApproval(approval);
            approvals.add(describedApproval);
        }
        for (DescribedApproval describedApproval : approvals) {
            String scope;
            ArrayList<DescribedApproval> clientApprovals = (ArrayList<DescribedApproval>)result.get(describedApproval.getClientId());
            if (clientApprovals == null) {
                clientApprovals = new ArrayList<DescribedApproval>();
                result.put(describedApproval.getClientId(), clientApprovals);
            }
            if (!(scope = describedApproval.getScope()).contains(".")) {
                describedApproval.setDescription("Access your data with scope '" + scope + "'");
                clientApprovals.add(describedApproval);
                continue;
            }
            String resource = scope.substring(0, scope.lastIndexOf("."));
            if ("uaa".equals(resource)) continue;
            String access = scope.substring(scope.lastIndexOf(".") + 1);
            describedApproval.setDescription("Access your '" + resource + "' resources with scope '" + access + "'");
            clientApprovals.add(describedApproval);
        }
        for (List list : result.values()) {
            Collections.sort(list, new Comparator<DescribedApproval>(){

                @Override
                public int compare(DescribedApproval o1, DescribedApproval o2) {
                    return o1.getScope().compareTo(o2.getScope());
                }
            });
        }
        return result;
    }

    @Override
    public void updateApprovals(List<DescribedApproval> approvals) {
        this.restTemplate.put(this.approvalsUrl, approvals, new Object[0]);
    }

    @Override
    public void deleteApprovalsForClient(String clientId) {
        ResponseEntity response = this.restTemplate.exchange(this.approvalsUrl + "?clientId=" + clientId, HttpMethod.DELETE, null, String.class, new Object[0]);
        this.logger.debug((Object)("Delete approvals request for client " + clientId + " resulted in " + response));
    }
}

