/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.audit.event;

import org.apache.commons.logging.Log;
import org.cloudfoundry.identity.uaa.audit.event.EntityDeletedEvent;
import org.cloudfoundry.identity.uaa.provider.IdentityProvider;
import org.cloudfoundry.identity.uaa.zone.IdentityZone;
import org.springframework.context.ApplicationListener;

public interface SystemDeletable
extends ApplicationListener<EntityDeletedEvent<?>> {
    default public void onApplicationEvent(EntityDeletedEvent<?> event) {
        if (event == null || event.getDeleted() == null) {
            return;
        }
        if (event.getDeleted() instanceof IdentityZone) {
            String zoneId = ((IdentityZone)event.getDeleted()).getId();
            if (this.isUaaZone(zoneId)) {
                this.getLogger().debug((Object)("Attempt to delete default zone ignored:" + event.getDeleted()));
                return;
            }
            this.deleteByIdentityZone(zoneId);
        } else if (event.getDeleted() instanceof IdentityProvider) {
            String zoneId = ((IdentityProvider)event.getDeleted()).getIdentityZoneId();
            String origin = ((IdentityProvider)event.getDeleted()).getOriginKey();
            if ("uaa".equals(origin)) {
                this.getLogger().debug((Object)("Attempt to delete default UAA provider ignored:" + event.getDeleted()));
                return;
            }
            this.deleteByOrigin(origin, zoneId);
        } else {
            this.getLogger().debug((Object)("Unsupported deleted event for deletion of object:" + event.getDeleted()));
        }
    }

    default public boolean isUaaZone(String zoneId) {
        return IdentityZone.getUaa().getId().equals(zoneId);
    }

    public int deleteByIdentityZone(String var1);

    public int deleteByOrigin(String var1, String var2);

    public Log getLogger();
}

