/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.authentication.manager;

import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.cloudfoundry.identity.uaa.authentication.AccountNotVerifiedException;
import org.cloudfoundry.identity.uaa.authentication.AuthenticationPolicyRejectionException;
import org.cloudfoundry.identity.uaa.authentication.manager.ChainedAuthenticationManager;
import org.cloudfoundry.identity.uaa.authentication.manager.DynamicLdapAuthenticationManager;
import org.cloudfoundry.identity.uaa.authentication.manager.LdapLoginAuthenticationManager;
import org.cloudfoundry.identity.uaa.provider.IdentityProvider;
import org.cloudfoundry.identity.uaa.provider.IdentityProviderProvisioning;
import org.cloudfoundry.identity.uaa.provider.LdapIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.scim.ScimGroupExternalMembershipManager;
import org.cloudfoundry.identity.uaa.scim.ScimGroupProvisioning;
import org.cloudfoundry.identity.uaa.util.ObjectUtils;
import org.cloudfoundry.identity.uaa.zone.IdentityZone;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;

public class DynamicZoneAwareAuthenticationManager
implements AuthenticationManager {
    private final IdentityProviderProvisioning provisioning;
    private final AuthenticationManager internalUaaAuthenticationManager;
    private final ConcurrentMap<IdentityZone, DynamicLdapAuthenticationManager> ldapAuthManagers = new ConcurrentHashMap<IdentityZone, DynamicLdapAuthenticationManager>();
    private final ScimGroupExternalMembershipManager scimGroupExternalMembershipManager;
    private final ScimGroupProvisioning scimGroupProvisioning;
    private final LdapLoginAuthenticationManager ldapLoginAuthenticationManager;

    public DynamicZoneAwareAuthenticationManager(IdentityProviderProvisioning provisioning, AuthenticationManager internalUaaAuthenticationManager, ScimGroupExternalMembershipManager scimGroupExternalMembershipManager, ScimGroupProvisioning scimGroupProvisioning, LdapLoginAuthenticationManager ldapLoginAuthenticationManager) {
        this.provisioning = provisioning;
        this.internalUaaAuthenticationManager = internalUaaAuthenticationManager;
        this.scimGroupExternalMembershipManager = scimGroupExternalMembershipManager;
        this.scimGroupProvisioning = scimGroupProvisioning;
        this.ldapLoginAuthenticationManager = ldapLoginAuthenticationManager;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        IdentityZone zone = IdentityZoneHolder.get();
        return this.getChainedAuthenticationManager(zone).authenticate(authentication);
    }

    protected ChainedAuthenticationManager getChainedAuthenticationManager(IdentityZone zone) {
        IdentityProvider ldapProvider = this.getProvider("ldap", zone);
        IdentityProvider uaaProvider = this.getProvider("uaa", zone);
        LinkedList<ChainedAuthenticationManager.AuthenticationManagerConfiguration> delegates = new LinkedList<ChainedAuthenticationManager.AuthenticationManagerConfiguration>();
        if (uaaProvider.isActive()) {
            ChainedAuthenticationManager.AuthenticationManagerConfiguration uaaConfig = new ChainedAuthenticationManager.AuthenticationManagerConfiguration(this.internalUaaAuthenticationManager, null);
            uaaConfig.setStopIf(AccountNotVerifiedException.class, AuthenticationPolicyRejectionException.class);
            delegates.add(uaaConfig);
        }
        if (ldapProvider.isActive()) {
            DynamicLdapAuthenticationManager existing = this.getLdapAuthenticationManager(zone, ldapProvider);
            if (!existing.getDefinition().equals((Object)ldapProvider.getConfig())) {
                this.ldapAuthManagers.remove(zone);
                existing.destroy();
            }
            DynamicLdapAuthenticationManager ldapAuthenticationManager = this.getLdapAuthenticationManager(zone, ldapProvider);
            ChainedAuthenticationManager.AuthenticationManagerConfiguration ldapConfig = new ChainedAuthenticationManager.AuthenticationManagerConfiguration(ldapAuthenticationManager, delegates.size() > 0 ? "ifPreviousFalse" : null);
            delegates.add(ldapConfig);
        }
        ChainedAuthenticationManager result = new ChainedAuthenticationManager();
        result.setDelegates(delegates.toArray(new ChainedAuthenticationManager.AuthenticationManagerConfiguration[delegates.size()]));
        return result;
    }

    protected IdentityProvider getProvider(String origin, IdentityZone zone) {
        try {
            IdentityProvider result = this.provisioning.retrieveByOrigin(origin, zone.getId());
            if (result != null) {
                return result;
            }
        }
        catch (EmptyResultDataAccessException result) {
            // empty catch block
        }
        IdentityProvider provider = new IdentityProvider();
        provider.setOriginKey(origin);
        provider.setActive(false);
        return provider;
    }

    public DynamicLdapAuthenticationManager getLdapAuthenticationManager(IdentityZone zone, IdentityProvider provider) {
        DynamicLdapAuthenticationManager ldapMgr = (DynamicLdapAuthenticationManager)this.ldapAuthManagers.get(zone);
        if (ldapMgr != null) {
            return ldapMgr;
        }
        LdapIdentityProviderDefinition definition = (LdapIdentityProviderDefinition)ObjectUtils.castInstance((Object)provider.getConfig(), LdapIdentityProviderDefinition.class);
        if (definition == null || !definition.isConfigured().booleanValue()) {
            throw new IllegalArgumentException("LDAP provider not configured ID:" + provider.getId());
        }
        ldapMgr = new DynamicLdapAuthenticationManager(definition, this.scimGroupExternalMembershipManager, this.scimGroupProvisioning, this.ldapLoginAuthenticationManager);
        this.ldapAuthManagers.putIfAbsent(zone, ldapMgr);
        return (DynamicLdapAuthenticationManager)this.ldapAuthManagers.get(zone);
    }

    public void destroy() {
        for (Map.Entry entry : this.ldapAuthManagers.entrySet()) {
            ((DynamicLdapAuthenticationManager)entry.getValue()).destroy();
        }
    }
}

