/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.oauth;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.approval.Approval;
import org.cloudfoundry.identity.uaa.approval.ApprovalStore;
import org.cloudfoundry.identity.uaa.authentication.Origin;
import org.cloudfoundry.identity.uaa.scim.ScimGroupProvisioning;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.client.BaseClientDetails;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.bind.support.SessionStatus;
import org.springframework.web.context.request.WebRequest;

@Controller
@SessionAttributes(value={"authorizationRequest"})
public class AccessController {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private static final String SCOPE_PREFIX = "scope.";
    private ClientDetailsService clientDetailsService;
    private Boolean useSsl;
    private ApprovalStore approvalStore = null;
    private ScimGroupProvisioning groupProvisioning;

    public void setUseSsl(Boolean useSsl) {
        this.useSsl = useSsl;
    }

    public void setClientDetailsService(ClientDetailsService clientDetailsService) {
        this.clientDetailsService = clientDetailsService;
    }

    public void setApprovalStore(ApprovalStore approvalStore) {
        this.approvalStore = approvalStore;
    }

    public ScimGroupProvisioning getGroupProvisioning() {
        return this.groupProvisioning;
    }

    public AccessController setGroupProvisioning(ScimGroupProvisioning groupProvisioning) {
        this.groupProvisioning = groupProvisioning;
        return this;
    }

    @RequestMapping(value={"/oauth/confirm_access"})
    public String confirm(Map<String, Object> model, final HttpServletRequest request, Principal principal, SessionStatus sessionStatus) throws Exception {
        if (!(principal instanceof Authentication)) {
            sessionStatus.setComplete();
            throw new InsufficientAuthenticationException("User must be authenticated with before authorizing access.");
        }
        AuthorizationRequest clientAuthRequest = (AuthorizationRequest)model.remove("authorizationRequest");
        if (clientAuthRequest == null) {
            model.put("error", "No authorization request is present, so we cannot confirm access (we don't know what you are asking for).");
        } else {
            String clientId = clientAuthRequest.getClientId();
            ClientDetails client = this.clientDetailsService.loadClientByClientId(clientId);
            BaseClientDetails modifiableClient = new BaseClientDetails(client);
            modifiableClient.setClientSecret(null);
            model.put("auth_request", clientAuthRequest);
            model.put("redirect_uri", this.getRedirectUri((ClientDetails)modifiableClient, clientAuthRequest));
            Map additionalInfo = client.getAdditionalInformation();
            String clientDisplayName = (String)additionalInfo.get("name");
            model.put("client_display_name", clientDisplayName != null ? clientDisplayName : clientId);
            Object autoApproved = additionalInfo.get("autoapprove");
            HashSet autoApprovedScopes = new HashSet();
            if (autoApproved instanceof Collection) {
                Collection scopes = (Collection)autoApproved;
                autoApprovedScopes.addAll(scopes);
            } else if (autoApproved instanceof Boolean && ((Boolean)autoApproved).booleanValue() || "true".equals(autoApproved)) {
                autoApprovedScopes.addAll(modifiableClient.getScope());
            }
            ArrayList<Approval> filteredApprovals = new ArrayList<Approval>();
            List<Approval> approvals = this.approvalStore.getApprovals(Origin.getUserId((Authentication)principal), clientId);
            for (Approval approval : approvals) {
                if (autoApprovedScopes.contains(approval.getScope())) continue;
                filteredApprovals.add(approval);
            }
            ArrayList<String> approvedScopes = new ArrayList<String>();
            ArrayList<String> deniedScopes = new ArrayList<String>();
            block5: for (Approval approval : filteredApprovals) {
                switch (approval.getStatus()) {
                    case APPROVED: {
                        approvedScopes.add(approval.getScope());
                        continue block5;
                    }
                    case DENIED: {
                        deniedScopes.add(approval.getScope());
                        continue block5;
                    }
                }
                this.logger.error((Object)"Encountered an unknown scope. This is not supposed to happen");
            }
            ArrayList<String> undecidedScopes = new ArrayList<String>();
            for (String scope : clientAuthRequest.getScope()) {
                if (approvedScopes.contains(scope) || deniedScopes.contains(scope) || autoApprovedScopes.contains(scope)) continue;
                undecidedScopes.add(scope);
            }
            List<Map<String, String>> list = this.getScopes(approvedScopes);
            model.put("approved_scopes", list);
            List<Map<String, String>> undecidedScopeDetails = this.getScopes(undecidedScopes);
            model.put("undecided_scopes", undecidedScopeDetails);
            List<Map<String, String>> deniedScopeDetails = this.getScopes(deniedScopes);
            model.put("denied_scopes", deniedScopeDetails);
            ArrayList<Map<String, String>> allScopes = new ArrayList<Map<String, String>>();
            allScopes.addAll(list);
            allScopes.addAll(undecidedScopeDetails);
            allScopes.addAll(deniedScopeDetails);
            model.put("scopes", allScopes);
            model.put("message", "To confirm or deny access POST to the following locations with the parameters requested.");
            HashMap<String, Object> options = new HashMap<String, Object>(){
                {
                    this.put("confirm", new HashMap<String, String>(){
                        {
                            this.put("location", AccessController.this.getLocation(request, "oauth/authorize"));
                            this.put("path", AccessController.this.getPath(request, "oauth/authorize"));
                            this.put("key", "user_oauth_approval");
                            this.put("value", "true");
                        }
                    });
                    this.put("deny", new HashMap<String, String>(){
                        {
                            this.put("location", AccessController.this.getLocation(request, "oauth/authorize"));
                            this.put("path", AccessController.this.getPath(request, "oauth/authorize"));
                            this.put("key", "user_oauth_approval");
                            this.put("value", "false");
                        }
                    });
                }
            };
            model.put("options", options);
        }
        return "access_confirmation";
    }

    private List<Map<String, String>> getScopes(ArrayList<String> scopes) {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        for (String scope : scopes) {
            String[] tokens = scope.split("\\.");
            String resource = tokens[0];
            if ("uaa".equals(resource)) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            String code = SCOPE_PREFIX + scope;
            map.put("code", code);
            Optional group = this.groupProvisioning.query(String.format("displayName eq \"%s\"", scope)).stream().findFirst();
            group.ifPresent(g -> {
                String description = g.getDescription();
                if (StringUtils.hasText((String)description)) {
                    map.put("text", description);
                }
            });
            map.putIfAbsent("text", scope);
            result.add(map);
        }
        Collections.sort(result, (map1, map2) -> {
            String code1 = (String)map1.get("code");
            String code2 = (String)map2.get("code");
            int i = this.codeIsPasswordOrOpenId(code2) - this.codeIsPasswordOrOpenId(code1);
            if (0 != i) {
                return i;
            }
            return code1.compareTo(code2);
        });
        return result;
    }

    private int codeIsPasswordOrOpenId(String code) {
        return code.startsWith("scope.password") || code.startsWith("scope.openid") ? 1 : 0;
    }

    private String getRedirectUri(ClientDetails client, AuthorizationRequest clientAuth) {
        String result = null;
        if (clientAuth.getRedirectUri() != null) {
            result = clientAuth.getRedirectUri();
        }
        if (client.getRegisteredRedirectUri() != null && !client.getRegisteredRedirectUri().isEmpty() && result == null) {
            result = (String)client.getRegisteredRedirectUri().iterator().next();
        }
        if (result != null) {
            if (result.contains("?")) {
                result = result.substring(0, result.indexOf("?"));
            }
            if (result.contains("#")) {
                result = result.substring(0, result.indexOf("#"));
            }
        }
        return result;
    }

    @RequestMapping(value={"/oauth/error"})
    public String handleError(WebRequest request, Map<String, Object> model) throws Exception {
        Object object = request.getAttribute("error", 0);
        if (object != null) {
            model.put("error", object);
        }
        return "access_confirmation_error";
    }

    protected String getLocation(HttpServletRequest request, String path) {
        return this.extractScheme(request) + "://" + request.getHeader("Host") + this.getPath(request, path);
    }

    private String getPath(HttpServletRequest request, String path) {
        String contextPath = request.getContextPath();
        if (contextPath.endsWith("/")) {
            contextPath = contextPath.substring(0, contextPath.lastIndexOf("/") - 1);
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return contextPath + "/" + path;
    }

    protected String extractScheme(HttpServletRequest request) {
        return this.useSsl != null && this.useSsl != false ? "https" : request.getScheme();
    }
}

