/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.oauth;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.cloudfoundry.identity.uaa.provider.IdentityProvider;
import org.cloudfoundry.identity.uaa.provider.IdentityProviderProvisioning;
import org.cloudfoundry.identity.uaa.security.DefaultSecurityContextAccessor;
import org.cloudfoundry.identity.uaa.security.SecurityContextAccessor;
import org.cloudfoundry.identity.uaa.user.UaaUser;
import org.cloudfoundry.identity.uaa.user.UaaUserDatabase;
import org.cloudfoundry.identity.uaa.util.UaaStringUtils;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.oauth2.common.exceptions.InvalidClientException;
import org.springframework.security.oauth2.common.exceptions.InvalidScopeException;
import org.springframework.security.oauth2.common.exceptions.UnauthorizedClientException;
import org.springframework.security.oauth2.common.util.OAuth2Utils;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.security.oauth2.provider.OAuth2RequestFactory;
import org.springframework.security.oauth2.provider.TokenRequest;
import org.springframework.security.oauth2.provider.client.BaseClientDetails;
import org.springframework.security.oauth2.provider.request.DefaultOAuth2RequestFactory;

public class UaaAuthorizationRequestManager
implements OAuth2RequestFactory {
    private final ClientDetailsService clientDetailsService;
    private Map<String, String> scopeToResource = Collections.singletonMap("openid", "openid");
    private String scopeSeparator = ".";
    private SecurityContextAccessor securityContextAccessor = new DefaultSecurityContextAccessor();
    private Collection<String> defaultScopes = new HashSet<String>();
    private OAuth2RequestFactory requestFactory;
    private UaaUserDatabase uaaUserDatabase;
    private IdentityProviderProvisioning providerProvisioning;

    public OAuth2RequestFactory getRequestFactory() {
        return this.requestFactory;
    }

    public void setRequestFactory(OAuth2RequestFactory requestFactory) {
        this.requestFactory = requestFactory;
    }

    public UaaAuthorizationRequestManager(ClientDetailsService clientDetailsService, UaaUserDatabase userDatabase, IdentityProviderProvisioning providerProvisioning) {
        this.clientDetailsService = clientDetailsService;
        this.uaaUserDatabase = userDatabase;
        this.requestFactory = new DefaultOAuth2RequestFactory(clientDetailsService);
        this.providerProvisioning = providerProvisioning;
    }

    public void setDefaultScopes(Collection<String> defaultScopes) {
        this.defaultScopes = defaultScopes;
    }

    public void setSecurityContextAccessor(SecurityContextAccessor securityContextAccessor) {
        this.securityContextAccessor = securityContextAccessor;
    }

    public void setScopesToResources(Map<String, String> scopeToResource) {
        this.scopeToResource = new HashMap<String, String>(scopeToResource);
    }

    public void setScopeSeparator(String scopeSeparator) {
        this.scopeSeparator = scopeSeparator;
    }

    public AuthorizationRequest createAuthorizationRequest(Map<String, String> authorizationParameters) {
        String clientId = authorizationParameters.get("client_id");
        BaseClientDetails clientDetails = (BaseClientDetails)this.clientDetailsService.loadClientByClientId(clientId);
        this.validateParameters(authorizationParameters, (ClientDetails)clientDetails);
        Set scopes = OAuth2Utils.parseParameterList((String)authorizationParameters.get("scope"));
        Set responseTypes = OAuth2Utils.parseParameterList((String)authorizationParameters.get("response_type"));
        String grantType = authorizationParameters.get("grant_type");
        String state = authorizationParameters.get("state");
        String redirectUri = authorizationParameters.get("redirect_uri");
        if (scopes == null || scopes.isEmpty()) {
            scopes = "client_credentials".equals(grantType) ? AuthorityUtils.authorityListToSet((Collection)clientDetails.getAuthorities()) : clientDetails.getScope();
        }
        if (!"client_credentials".equals(grantType) && this.securityContextAccessor.isUser()) {
            String userId = this.securityContextAccessor.getUserId();
            UaaUser uaaUser = this.uaaUserDatabase.retrieveUserById(userId);
            List<? extends GrantedAuthority> authorities = uaaUser.getAuthorities();
            scopes = this.checkUserScopes(scopes, authorities, (ClientDetails)clientDetails);
            this.checkClientIdpAuthorization(clientDetails, uaaUser);
        }
        Set<String> resourceIds = this.getResourceIds((ClientDetails)clientDetails, scopes);
        clientDetails.setResourceIds(resourceIds);
        HashMap<String, String> actualParameters = new HashMap<String, String>(authorizationParameters);
        AuthorizationRequest request = new AuthorizationRequest(actualParameters, null, clientId, scopes.isEmpty() ? null : scopes, null, null, false, state, redirectUri, responseTypes);
        if (!scopes.isEmpty()) {
            request.setScope(scopes);
        }
        request.setResourceIdsAndAuthoritiesFromClientDetails((ClientDetails)clientDetails);
        return request;
    }

    public void validateParameters(Map<String, String> parameters, ClientDetails clientDetails) {
        if (parameters.containsKey("scope")) {
            Set validScope = clientDetails.getScope();
            if ("client_credentials".equals(parameters.get("grant_type"))) {
                validScope = AuthorityUtils.authorityListToSet((Collection)clientDetails.getAuthorities());
            }
            Set<Pattern> validWildcards = this.constructWildcards(validScope);
            Set scopes = OAuth2Utils.parseParameterList((String)parameters.get("scope"));
            for (String scope : scopes) {
                if (this.matches(validWildcards, scope)) continue;
                throw new InvalidScopeException("Invalid scope: " + scope + ". Did you know that you can get default requested scopes by simply sending no value?", validScope);
            }
        }
    }

    protected void checkClientIdpAuthorization(BaseClientDetails client, UaaUser user) {
        List allowedProviders = (List)client.getAdditionalInformation().get("allowedproviders");
        if (allowedProviders == null) {
            return;
        }
        if (allowedProviders.isEmpty()) {
            throw new UnauthorizedClientException("Client is not authorized for any identity providers.");
        }
        try {
            IdentityProvider provider = this.providerProvisioning.retrieveByOrigin(user.getOrigin(), user.getZoneId());
            if (provider == null || !allowedProviders.contains(provider.getOriginKey())) {
                throw new UnauthorizedClientException("Client is not authorized for specified user's identity provider.");
            }
        }
        catch (EmptyResultDataAccessException x) {
            throw new UnauthorizedClientException("User does not belong to a valid identity provider.");
        }
    }

    private Set<String> checkUserScopes(Set<String> requestedScopes, Collection<? extends GrantedAuthority> authorities, ClientDetails clientDetails) {
        LinkedHashSet<String> allowed = new LinkedHashSet<String>(AuthorityUtils.authorityListToSet(authorities));
        allowed.addAll(this.defaultScopes);
        Set<String> result = this.intersectScopes(new LinkedHashSet<String>(requestedScopes), clientDetails.getScope(), allowed);
        if (result.isEmpty() && !clientDetails.getScope().isEmpty()) {
            throw new InvalidScopeException("Invalid scope (empty) - this user is not allowed any of the requested scopes: " + requestedScopes + " (either you requested a scope that was not allowed or client '" + clientDetails.getClientId() + "' is not allowed to act on behalf of this user)", allowed);
        }
        return result;
    }

    protected Set<String> intersectScopes(Set<String> requestedScopes, Set<String> clientScopes, Set<String> userScopes) {
        HashSet<String> result = new HashSet<String>(userScopes);
        Set<Pattern> clientWildcards = this.constructWildcards(clientScopes);
        Iterator iter = result.iterator();
        while (iter.hasNext()) {
            String scope = (String)iter.next();
            if (this.matches(clientWildcards, scope)) continue;
            iter.remove();
        }
        Set<Pattern> requestedWildcards = this.constructWildcards(requestedScopes);
        Iterator iter2 = result.iterator();
        while (iter2.hasNext()) {
            String scope = (String)iter2.next();
            if (this.matches(requestedWildcards, scope)) continue;
            iter2.remove();
        }
        return result;
    }

    protected Set<Pattern> constructWildcards(Set<String> scopes) {
        return UaaStringUtils.constructWildcards(scopes);
    }

    protected boolean matches(Set<Pattern> wildcards, String scope) {
        return UaaStringUtils.matches(wildcards, scope);
    }

    private Set<String> getResourceIds(ClientDetails clientDetails, Set<String> scopes) {
        LinkedHashSet<String> resourceIds = new LinkedHashSet<String>();
        if (clientDetails.getClientId() != null) {
            resourceIds.add(clientDetails.getClientId());
        }
        for (String scope : scopes) {
            if (this.scopeToResource.containsKey(scope)) {
                resourceIds.add(this.scopeToResource.get(scope));
                continue;
            }
            if (!scope.contains(this.scopeSeparator) || scope.endsWith(this.scopeSeparator) || scope.equals("uaa.none")) continue;
            String id = scope.substring(0, scope.lastIndexOf(this.scopeSeparator));
            resourceIds.add(id);
        }
        return resourceIds.isEmpty() ? clientDetails.getResourceIds() : resourceIds;
    }

    public OAuth2Request createOAuth2Request(AuthorizationRequest request) {
        return this.requestFactory.createOAuth2Request(request);
    }

    public OAuth2Request createOAuth2Request(ClientDetails client, TokenRequest tokenRequest) {
        return this.requestFactory.createOAuth2Request(client, tokenRequest);
    }

    public TokenRequest createTokenRequest(Map<String, String> requestParameters, ClientDetails authenticatedClient) {
        String clientId = requestParameters.get("client_id");
        if (clientId == null) {
            clientId = authenticatedClient.getClientId();
        } else if (!clientId.equals(authenticatedClient.getClientId())) {
            throw new InvalidClientException("Given client ID does not match authenticated client");
        }
        String grantType = requestParameters.get("grant_type");
        Set<String> scopes = this.extractScopes(requestParameters, authenticatedClient);
        Set<String> resourceIds = this.getResourceIds(authenticatedClient, scopes);
        UaaTokenRequest tokenRequest = new UaaTokenRequest(requestParameters, clientId, scopes, grantType, resourceIds);
        return tokenRequest;
    }

    protected Set<String> extractScopes(Map<String, String> requestParameters, ClientDetails clientDetails) {
        boolean clientCredentials = "client_credentials".equals(requestParameters.get("grant_type"));
        Set<String> scopes = OAuth2Utils.parseParameterList((String)requestParameters.get("scope"));
        if (scopes == null || scopes.isEmpty()) {
            if (clientCredentials) {
                HashSet<String> authorities = new HashSet<String>();
                for (GrantedAuthority a : clientDetails.getAuthorities()) {
                    authorities.add(a.getAuthority());
                }
                scopes = authorities;
            } else {
                scopes = clientDetails.getScope();
            }
        }
        if (!clientCredentials) {
            Set<String> userScopes = this.getUserScopes();
            scopes = this.intersectScopes(scopes, clientDetails.getScope(), userScopes);
        }
        return scopes;
    }

    protected Set<String> getUserScopes() {
        HashSet<String> scopes = new HashSet<String>();
        if (this.securityContextAccessor.isUser()) {
            String userId = this.securityContextAccessor.getUserId();
            Collection<? extends GrantedAuthority> authorities = this.uaaUserDatabase != null ? this.uaaUserDatabase.retrieveUserById(userId).getAuthorities() : this.securityContextAccessor.getAuthorities();
            for (GrantedAuthority grantedAuthority : authorities) {
                scopes.add(grantedAuthority.getAuthority());
            }
        }
        return scopes;
    }

    public TokenRequest createTokenRequest(AuthorizationRequest authorizationRequest, String grantType) {
        return this.requestFactory.createTokenRequest(authorizationRequest, grantType);
    }

    public class UaaTokenRequest
    extends TokenRequest {
        private Set<String> resourceIds;
        Set<String> responseTypes;

        public UaaTokenRequest(Map<String, String> requestParameters, String clientId, Collection<String> scope, String grantType, Set<String> resourceIds) {
            super(requestParameters, clientId, scope, grantType);
            this.resourceIds = resourceIds;
            this.responseTypes = OAuth2Utils.parseParameterList((String)requestParameters.get("response_type"));
        }

        public OAuth2Request createOAuth2Request(ClientDetails client) {
            OAuth2Request request = super.createOAuth2Request(client);
            return new OAuth2Request(request.getRequestParameters(), client.getClientId(), client.getAuthorities(), true, request.getScope(), this.resourceIds, request.getRedirectUri(), this.responseTypes, request.getExtensions());
        }
    }
}

