/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider.oauth;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cloudfoundry.identity.uaa.provider.AbstractXOAuthIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.RawXOAuthIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.XOIDCIdentityProviderDefinition;

public class OauthIdentityProviderDefinitionFactoryBean {
    private Map<String, AbstractXOAuthIdentityProviderDefinition> oauthIdpDefinitions = new HashMap<String, AbstractXOAuthIdentityProviderDefinition>();

    public OauthIdentityProviderDefinitionFactoryBean(Map<String, Map> definitions) {
        if (definitions != null) {
            for (String alias : definitions.keySet()) {
                Map idpDefinitionMap = definitions.get(alias);
                try {
                    String type = (String)idpDefinitionMap.get("type");
                    if ("oauth2.0".equalsIgnoreCase(type)) {
                        RawXOAuthIdentityProviderDefinition oauthIdentityProviderDefinition = new RawXOAuthIdentityProviderDefinition();
                        oauthIdentityProviderDefinition.setCheckTokenUrl(idpDefinitionMap.get("checkTokenUrl") == null ? null : new URL((String)idpDefinitionMap.get("checkTokenUrl")));
                        this.setCommonProperties(idpDefinitionMap, (AbstractXOAuthIdentityProviderDefinition)oauthIdentityProviderDefinition);
                        this.oauthIdpDefinitions.put(alias, (AbstractXOAuthIdentityProviderDefinition)oauthIdentityProviderDefinition);
                        continue;
                    }
                    if ("oidc1.0".equalsIgnoreCase(type)) {
                        XOIDCIdentityProviderDefinition oidcIdentityProviderDefinition = new XOIDCIdentityProviderDefinition();
                        this.setCommonProperties(idpDefinitionMap, (AbstractXOAuthIdentityProviderDefinition)oidcIdentityProviderDefinition);
                        oidcIdentityProviderDefinition.setUserInfoUrl(idpDefinitionMap.get("userInfoUrl") == null ? null : new URL((String)idpDefinitionMap.get("userInfoUrl")));
                        this.oauthIdpDefinitions.put(alias, (AbstractXOAuthIdentityProviderDefinition)oidcIdentityProviderDefinition);
                        continue;
                    }
                    throw new IllegalArgumentException("Unknown type for provider. Type must be oauth2.0 or oidc1.0. (Was " + type + ")");
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException("URL is malformed.", e);
                }
            }
        }
    }

    private void setCommonProperties(Map idpDefinitionMap, AbstractXOAuthIdentityProviderDefinition idpDefinition) {
        idpDefinition.setLinkText((String)idpDefinitionMap.get("linkText"));
        idpDefinition.setRelyingPartyId((String)idpDefinitionMap.get("relyingPartyId"));
        idpDefinition.setRelyingPartySecret((String)idpDefinitionMap.get("relyingPartySecret"));
        idpDefinition.setEmailDomain((List)idpDefinitionMap.get("emailDomain"));
        idpDefinition.setShowLinkText(idpDefinitionMap.get("showLinkText") == null ? true : (Boolean)idpDefinitionMap.get("showLinkText"));
        idpDefinition.setAddShadowUserOnLogin(idpDefinitionMap.get("addShadowUserOnLogin") == null ? true : (Boolean)idpDefinitionMap.get("addShadowUserOnLogin"));
        idpDefinition.setSkipSslValidation(idpDefinitionMap.get("skipSslValidation") == null ? false : (Boolean)idpDefinitionMap.get("skipSslValidation"));
        idpDefinition.setTokenKey((String)idpDefinitionMap.get("tokenKey"));
        idpDefinition.setAttributeMappings((Map)idpDefinitionMap.get("attributeMappings"));
        idpDefinition.setScopes((List)idpDefinitionMap.get("scopes"));
        try {
            idpDefinition.setAuthUrl(new URL((String)idpDefinitionMap.get("authUrl")));
            idpDefinition.setTokenKeyUrl(idpDefinitionMap.get("tokenKeyUrl") == null ? null : new URL((String)idpDefinitionMap.get("tokenKeyUrl")));
            idpDefinition.setTokenUrl(new URL((String)idpDefinitionMap.get("tokenUrl")));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("URL is malformed.", e);
        }
    }

    public Map<String, AbstractXOAuthIdentityProviderDefinition> getOauthIdpDefinitions() {
        return this.oauthIdpDefinitions;
    }

    public void setOauthIdpDefinitions(Map<String, AbstractXOAuthIdentityProviderDefinition> oauthIdpDefinitions) {
        this.oauthIdpDefinitions = oauthIdpDefinitions;
    }
}

