/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.audit;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import javax.sql.DataSource;
import org.cloudfoundry.identity.uaa.audit.AuditEvent;
import org.cloudfoundry.identity.uaa.audit.AuditEventType;
import org.cloudfoundry.identity.uaa.audit.UaaAuditService;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class JdbcAuditService
implements UaaAuditService {
    private final JdbcTemplate template;

    public JdbcAuditService(DataSource dataSource) {
        this.template = new JdbcTemplate(dataSource);
    }

    protected JdbcTemplate getJdbcTemplate() {
        return this.template;
    }

    @Override
    public List<AuditEvent> find(String principal, long after) {
        return this.template.query("select event_type, principal_id, origin, event_data, created, identity_zone_id from sec_audit where principal_id=? and created > ? order by created desc", (RowMapper)new AuditEventRowMapper(), new Object[]{principal, new Timestamp(after)});
    }

    @Override
    public void log(AuditEvent auditEvent) {
        String origin = auditEvent.getOrigin();
        String data = auditEvent.getData();
        origin = origin == null ? "" : origin;
        origin = origin.length() > 255 ? origin.substring(0, 255) : origin;
        data = data == null ? "" : data;
        data = data.length() > 255 ? data.substring(0, 255) : data;
        this.template.update("insert into sec_audit (principal_id, event_type, origin, event_data, identity_zone_id) values (?,?,?,?,?)", new Object[]{auditEvent.getPrincipalId(), auditEvent.getType().getCode(), origin, data, auditEvent.getIdentityZoneId()});
    }

    private static String nullSafeTrim(String s) {
        return s == null ? null : s.trim();
    }

    private class AuditEventRowMapper
    implements RowMapper<AuditEvent> {
        private AuditEventRowMapper() {
        }

        public AuditEvent mapRow(ResultSet rs, int rowNum) throws SQLException {
            AuditEventType eventType = AuditEventType.fromCode(rs.getInt(1));
            String principalId = JdbcAuditService.nullSafeTrim(rs.getString(2));
            String origin = JdbcAuditService.nullSafeTrim(rs.getString(3));
            String data = JdbcAuditService.nullSafeTrim(rs.getString(4));
            long time = rs.getTimestamp(5).getTime();
            String identityZoneId = JdbcAuditService.nullSafeTrim(rs.getString(6));
            return new AuditEvent(eventType, principalId, origin, data, time, identityZoneId);
        }
    }
}

