/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.message;

import java.io.UnsupportedEncodingException;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.message.MessageService;
import org.cloudfoundry.identity.uaa.message.MessageType;
import org.cloudfoundry.identity.uaa.zone.IdentityZone;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

public class EmailService
implements MessageService {
    private final Log logger = LogFactory.getLog(this.getClass());
    private JavaMailSender mailSender;
    private final String loginUrl;
    private final String companyName;
    private final String fromAddress;

    public EmailService(JavaMailSender mailSender, String loginUrl, String companyName, String fromAddress) {
        this.mailSender = mailSender;
        this.loginUrl = loginUrl;
        this.companyName = companyName;
        if (fromAddress != null && !fromAddress.isEmpty()) {
            this.fromAddress = fromAddress;
        } else {
            String host = UriComponentsBuilder.fromHttpUrl((String)loginUrl).build().getHost();
            this.fromAddress = "admin@" + host;
        }
    }

    public String getFromAddress() {
        return this.fromAddress;
    }

    public JavaMailSender getMailSender() {
        return this.mailSender;
    }

    public void setMailSender(JavaMailSender mailSender) {
        this.mailSender = mailSender;
    }

    private Address[] getSenderAddresses() throws AddressException, UnsupportedEncodingException {
        String name = null;
        name = IdentityZoneHolder.get().equals((Object)IdentityZone.getUaa()) ? (StringUtils.hasText((String)this.companyName) ? this.companyName : "Cloud Foundry") : IdentityZoneHolder.get().getName();
        return new Address[]{new InternetAddress(this.fromAddress, name)};
    }

    @Override
    public void sendMessage(String email, MessageType messageType, String subject, String htmlContent) {
        MimeMessage message = this.mailSender.createMimeMessage();
        try {
            message.addFrom(this.getSenderAddresses());
            message.addRecipients(Message.RecipientType.TO, email);
            message.setSubject(subject);
            message.setContent((Object)htmlContent, "text/html");
        }
        catch (MessagingException e) {
            this.logger.error((Object)("Exception raised while sending message to " + email), (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error((Object)("Exception raised while sending message to " + email), (Throwable)e);
        }
        this.mailSender.send(message);
    }
}

