/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.codestore;

import java.sql.Timestamp;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.cloudfoundry.identity.uaa.codestore.ExpiringCode;
import org.cloudfoundry.identity.uaa.codestore.ExpiringCodeStore;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.security.oauth2.common.util.RandomValueStringGenerator;
import org.springframework.util.Assert;

public class InMemoryExpiringCodeStore
implements ExpiringCodeStore {
    private RandomValueStringGenerator generator = new RandomValueStringGenerator(6);
    private ConcurrentMap<String, ExpiringCode> store = new ConcurrentHashMap<String, ExpiringCode>();

    @Override
    public ExpiringCode generateCode(String data, Timestamp expiresAt, String intent) {
        ExpiringCode expiringCode;
        if (data == null || expiresAt == null) {
            throw new NullPointerException();
        }
        if (expiresAt.getTime() < System.currentTimeMillis()) {
            throw new IllegalArgumentException();
        }
        String code = this.generator.generate();
        ExpiringCode duplicate = this.store.putIfAbsent(code, expiringCode = new ExpiringCode(code, expiresAt, data, intent));
        if (duplicate != null) {
            throw new DataIntegrityViolationException("Duplicate code: " + code);
        }
        return expiringCode;
    }

    @Override
    public ExpiringCode retrieveCode(String code) {
        if (code == null) {
            throw new NullPointerException();
        }
        ExpiringCode expiringCode = (ExpiringCode)this.store.remove(code);
        if (expiringCode == null || expiringCode.getExpiresAt().getTime() < System.currentTimeMillis()) {
            expiringCode = null;
        }
        return expiringCode;
    }

    @Override
    public void setGenerator(RandomValueStringGenerator generator) {
        this.generator = generator;
    }

    @Override
    public void expireByIntent(String intent) {
        Assert.hasText((String)intent);
        this.store.values().stream().filter(c -> intent.equals(c.getIntent())).forEach(c -> {
            ExpiringCode cfr_ignored_0 = (ExpiringCode)this.store.remove(c.getCode());
        });
    }
}

