/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider.saml;

import com.google.common.base.Ticker;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Timer;
import java.util.concurrent.TimeUnit;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpParams;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.opensaml.saml2.metadata.provider.HTTPMetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;

public class FixedHttpMetaDataProvider
extends HTTPMetadataProvider {
    private boolean socketFactorySet = false;
    private long lastFetchTime = 0L;
    private static long expirationTimeMillis = 600000L;
    private static Ticker ticker = new Ticker(){

        public long read() {
            return System.nanoTime();
        }
    };
    protected static Cache<String, byte[]> metadataCache = FixedHttpMetaDataProvider.buildCache();

    protected static Cache<String, byte[]> buildCache() {
        return CacheBuilder.newBuilder().expireAfterWrite(expirationTimeMillis, TimeUnit.MILLISECONDS).maximumSize(20000L).ticker(ticker).build();
    }

    public static FixedHttpMetaDataProvider buildProvider(Timer backgroundTaskTimer, HttpClientParams params, String metadataURL) throws MetadataProviderException {
        SimpleHttpConnectionManager connectionManager = new SimpleHttpConnectionManager(true);
        connectionManager.getParams().setDefaults((HttpParams)params);
        HttpClient client = new HttpClient((HttpConnectionManager)connectionManager);
        FixedHttpMetaDataProvider.configureProxyIfNeeded(client, metadataURL);
        return new FixedHttpMetaDataProvider(backgroundTaskTimer, client, metadataURL);
    }

    private FixedHttpMetaDataProvider(Timer backgroundTaskTimer, HttpClient client, String metadataURL) throws MetadataProviderException {
        super(backgroundTaskTimer, client, metadataURL);
    }

    public static void configureProxyIfNeeded(HttpClient client, String metadataURL) {
        if (System.getProperty("http.proxyHost") != null && System.getProperty("http.proxyPort") != null && metadataURL.toLowerCase().startsWith("http://")) {
            FixedHttpMetaDataProvider.setProxy(client, "http");
        } else if (System.getProperty("https.proxyHost") != null && System.getProperty("https.proxyPort") != null && metadataURL.toLowerCase().startsWith("https://")) {
            FixedHttpMetaDataProvider.setProxy(client, "https");
        }
    }

    protected static void setProxy(HttpClient client, String prefix) {
        try {
            String host = System.getProperty(prefix + ".proxyHost");
            int port = Integer.parseInt(System.getProperty(prefix + ".proxyPort"));
            HostConfiguration configuration = client.getHostConfiguration();
            configuration.setProxy(host, port);
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException("Invalid proxy port configured:" + System.getProperty(prefix + ".proxyPort"));
        }
    }

    public byte[] fetchMetadata() throws MetadataProviderException {
        byte[] metadata = (byte[])metadataCache.getIfPresent((Object)this.getMetadataURI());
        if (metadata == null || System.currentTimeMillis() - this.lastFetchTime > this.getExpirationTimeMillis()) {
            metadata = super.fetchMetadata();
            this.lastFetchTime = System.currentTimeMillis();
            metadataCache.put((Object)this.getMetadataURI(), (Object)metadata);
        }
        return metadata;
    }

    public void setSocketFactory(ProtocolSocketFactory newSocketFactory) {
        super.setSocketFactory(newSocketFactory);
        this.socketFactorySet = newSocketFactory != null;
    }

    public String getMetadataURI() {
        if (this.isSocketFactorySet()) {
            try {
                URI uri = new URI(super.getMetadataURI());
                String result = uri.getPath();
                if (uri.getQuery() != null && uri.getQuery().trim().length() > 0) {
                    result = result + "?" + uri.getQuery();
                }
                return result;
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return super.getMetadataURI();
    }

    public boolean isSocketFactorySet() {
        return this.socketFactorySet;
    }

    public long getExpirationTimeMillis() {
        return expirationTimeMillis;
    }

    public void setExpirationTimeMillis(long expirationTimeMillis) {
        FixedHttpMetaDataProvider.expirationTimeMillis = expirationTimeMillis;
        metadataCache = FixedHttpMetaDataProvider.buildCache();
    }

    public Ticker getTicker() {
        return ticker;
    }

    public void setTicker(Ticker ticker) {
        FixedHttpMetaDataProvider.ticker = ticker;
        metadataCache = FixedHttpMetaDataProvider.buildCache();
    }
}

