/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider.saml;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cloudfoundry.identity.uaa.authentication.UaaAuthentication;
import org.cloudfoundry.identity.uaa.authentication.UaaPrincipal;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.providers.ExpiringUsernameAuthenticationToken;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class LoginSamlAuthenticationToken
extends ExpiringUsernameAuthenticationToken {
    private final UaaPrincipal uaaPrincipal;

    public LoginSamlAuthenticationToken(UaaPrincipal uaaPrincipal, ExpiringUsernameAuthenticationToken token) {
        super(token.getTokenExpiration(), (Object)uaaPrincipal, token.getCredentials(), token.getAuthorities());
        this.uaaPrincipal = uaaPrincipal;
    }

    public UaaPrincipal getUaaPrincipal() {
        return this.uaaPrincipal;
    }

    public UaaAuthentication getUaaAuthentication(List<? extends GrantedAuthority> uaaAuthorityList, Set<String> externalGroups, MultiValueMap<String, String> userAttributes) {
        LinkedMultiValueMap customAttributes = new LinkedMultiValueMap();
        for (Map.Entry entry : userAttributes.entrySet()) {
            if (!((String)entry.getKey()).startsWith("user.attribute.")) continue;
            customAttributes.put((Object)((String)entry.getKey()).substring("user.attribute.".length()), (List)entry.getValue());
        }
        UaaAuthentication authentication = new UaaAuthentication(this.getUaaPrincipal(), this.getCredentials(), uaaAuthorityList, externalGroups, (Map<String, List<String>>)customAttributes, null, this.isAuthenticated(), System.currentTimeMillis(), this.getTokenExpiration() == null ? -1L : this.getTokenExpiration().getTime());
        authentication.setAuthenticationMethods(Collections.singleton("ext"));
        return authentication;
    }
}

