/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cloudfoundry.identity.uaa.impl.config.NestedMapPropertySource;
import org.cloudfoundry.identity.uaa.provider.LdapIdentityProviderDefinition;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class LdapUtils {
    private LdapUtils() {
    }

    public static ConfigurableEnvironment getLdapConfigurationEnvironment(LdapIdentityProviderDefinition definition) {
        Assert.notNull((Object)definition);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        LdapUtils.setIfNotNull("ldap.attributeMappings", definition.getAttributeMappings(), properties);
        LdapUtils.setIfNotNull("ldap.base.localPasswordCompare", definition.isLocalPasswordCompare(), properties);
        LdapUtils.setIfNotNull("ldap.base.mailAttributeName", definition.getMailAttributeName(), properties);
        LdapUtils.setIfNotNull("ldap.base.mailSubstitute", definition.getMailSubstitute(), properties);
        LdapUtils.setIfNotNull("ldap.base.mailSubstituteOverridesLdap", definition.isMailSubstituteOverridesLdap(), properties);
        LdapUtils.setIfNotNull("ldap.base.password", definition.getBindPassword(), properties);
        LdapUtils.setIfNotNull("ldap.base.passwordAttributeName", definition.getPasswordAttributeName(), properties);
        LdapUtils.setIfNotNull("ldap.base.passwordEncoder", definition.getPasswordEncoder(), properties);
        LdapUtils.setIfNotNull("ldap.base.referral", definition.getReferral(), properties);
        LdapUtils.setIfNotNull("ldap.base.searchBase", definition.getUserSearchBase(), properties);
        LdapUtils.setIfNotNull("ldap.base.searchFilter", definition.getUserSearchFilter(), properties);
        LdapUtils.setIfNotNull("ldap.base.url", definition.getBaseUrl(), properties);
        LdapUtils.setIfNotNull("ldap.base.userDn", definition.getBindUserDn(), properties);
        LdapUtils.setIfNotNull("ldap.base.userDnPattern", definition.getUserDNPattern(), properties);
        LdapUtils.setIfNotNull("ldap.base.userDnPatternDelimiter", definition.getUserDNPatternDelimiter(), properties);
        LdapUtils.setIfNotNull("ldap.emailDomain", definition.getEmailDomain(), properties);
        LdapUtils.setIfNotNull("ldap.externalGroupsWhitelist", definition.getExternalGroupsWhitelist(), properties);
        LdapUtils.setIfNotNull("ldap.groups.autoAdd", definition.isAutoAddGroups(), properties);
        LdapUtils.setIfNotNull("ldap.groups.file", definition.getLdapGroupFile(), properties);
        LdapUtils.setIfNotNull("ldap.groups.groupRoleAttribute", definition.getGroupRoleAttribute(), properties);
        LdapUtils.setIfNotNull("ldap.groups.groupSearchFilter", definition.getGroupSearchFilter(), properties);
        LdapUtils.setIfNotNull("ldap.groups.ignorePartialResultException", definition.isGroupsIgnorePartialResults(), properties);
        LdapUtils.setIfNotNull("ldap.groups.maxSearchDepth", definition.getMaxGroupSearchDepth(), properties);
        LdapUtils.setIfNotNull("ldap.groups.searchBase", definition.getGroupSearchBase(), properties);
        LdapUtils.setIfNotNull("ldap.groups.searchSubtree", definition.isGroupSearchSubTree(), properties);
        LdapUtils.setIfNotNull("ldap.profile.file", definition.getLdapProfileFile(), properties);
        LdapUtils.setIfNotNull("ldap.ssl.skipverification", definition.isSkipSSLVerification(), properties);
        LdapUtils.setIfNotNull("ldap.addShadowUserOnLogin", definition.isAddShadowUserOnLogin(), properties);
        NestedMapPropertySource source = new NestedMapPropertySource("ldap", properties);
        return new LdapIdentityProviderDefinition.LdapConfigEnvironment((MapPropertySource)source);
    }

    private static void setIfNotNull(String property, Object value, Map<String, Object> map) {
        if (value != null) {
            map.put(property, value);
        }
    }

    public static LdapIdentityProviderDefinition fromConfig(Map<String, Object> ldapConfig) {
        Assert.notNull(ldapConfig);
        LdapIdentityProviderDefinition definition = new LdapIdentityProviderDefinition();
        if (ldapConfig == null || ldapConfig.isEmpty()) {
            return definition;
        }
        if (ldapConfig.get("ldap.emailDomain") != null) {
            definition.setEmailDomain((List)ldapConfig.get("ldap.emailDomain"));
        }
        if (ldapConfig.get("ldap.externalGroupsWhitelist") != null) {
            definition.setExternalGroupsWhitelist((List)ldapConfig.get("ldap.externalGroupsWhitelist"));
        }
        if (ldapConfig.get("ldap.attributeMappings") != null) {
            definition.setAttributeMappings((Map)ldapConfig.get("ldap.attributeMappings"));
        }
        if (ldapConfig.get("ldap.addShadowUserOnLogin") != null) {
            definition.setAddShadowUserOnLogin(((Boolean)ldapConfig.get("ldap.addShadowUserOnLogin")).booleanValue());
        }
        definition.setLdapProfileFile((String)ldapConfig.get("ldap.profile.file"));
        String profileFile = definition.getLdapProfileFile();
        if (StringUtils.hasText((String)profileFile)) {
            switch (profileFile) {
                case "ldap/ldap-simple-bind.xml": {
                    definition.setUserDNPattern((String)ldapConfig.get("ldap.base.userDnPattern"));
                    if (ldapConfig.get("ldap.base.userDnPatternDelimiter") == null) break;
                    definition.setUserDNPatternDelimiter((String)ldapConfig.get("ldap.base.userDnPatternDelimiter"));
                    break;
                }
                case "ldap/ldap-search-and-compare.xml": 
                case "ldap/ldap-search-and-bind.xml": {
                    definition.setBindUserDn((String)ldapConfig.get("ldap.base.userDn"));
                    definition.setBindPassword((String)ldapConfig.get("ldap.base.password"));
                    definition.setUserSearchBase((String)ldapConfig.get("ldap.base.searchBase"));
                    definition.setUserSearchFilter((String)ldapConfig.get("ldap.base.searchFilter"));
                    break;
                }
            }
        }
        definition.setBaseUrl((String)ldapConfig.get("ldap.base.url"));
        definition.setSkipSSLVerification((Boolean)ldapConfig.get("ldap.ssl.skipverification"));
        definition.setReferral((String)ldapConfig.get("ldap.base.referral"));
        definition.setMailSubstituteOverridesLdap((Boolean)ldapConfig.get("ldap.base.mailSubstituteOverridesLdap"));
        if (StringUtils.hasText((String)((String)ldapConfig.get("ldap.base.mailAttributeName")))) {
            definition.setMailAttributeName((String)ldapConfig.get("ldap.base.mailAttributeName"));
        }
        definition.setMailSubstitute((String)ldapConfig.get("ldap.base.mailSubstitute"));
        definition.setPasswordAttributeName((String)ldapConfig.get("ldap.base.passwordAttributeName"));
        definition.setPasswordEncoder((String)ldapConfig.get("ldap.base.passwordEncoder"));
        definition.setLocalPasswordCompare((Boolean)ldapConfig.get("ldap.base.localPasswordCompare"));
        if (StringUtils.hasText((String)((String)ldapConfig.get("ldap.groups.file")))) {
            definition.setLdapGroupFile((String)ldapConfig.get("ldap.groups.file"));
        }
        if (StringUtils.hasText((String)definition.getLdapGroupFile()) && !"ldap/ldap-groups-null.xml".equals(definition.getLdapGroupFile())) {
            definition.setGroupSearchBase((String)ldapConfig.get("ldap.groups.searchBase"));
            definition.setGroupSearchFilter((String)ldapConfig.get("ldap.groups.groupSearchFilter"));
            definition.setGroupsIgnorePartialResults((Boolean)ldapConfig.get("ldap.groups.ignorePartialResultException"));
            if (ldapConfig.get("ldap.groups.maxSearchDepth") != null) {
                definition.setMaxGroupSearchDepth(((Integer)ldapConfig.get("ldap.groups.maxSearchDepth")).intValue());
            }
            definition.setGroupSearchSubTree((Boolean)ldapConfig.get("ldap.groups.searchSubtree"));
            definition.setAutoAddGroups((Boolean)ldapConfig.get("ldap.groups.autoAdd"));
            definition.setGroupRoleAttribute((String)ldapConfig.get("ldap.groups.groupRoleAttribute"));
        }
        String LDAP_ATTR_MAP_PREFIX = "ldap.attributeMappings.";
        for (Map.Entry<String, Object> entry : ldapConfig.entrySet()) {
            if (LdapIdentityProviderDefinition.LDAP_PROPERTY_NAMES.contains(entry.getKey()) || !entry.getKey().startsWith("ldap.attributeMappings.") || !(entry.getValue() instanceof String)) continue;
            definition.addAttributeMapping(entry.getKey().substring("ldap.attributeMappings.".length()), entry.getValue());
        }
        if (ldapConfig.get("ldap.providerDescription") != null && ldapConfig.get("ldap.providerDescription") instanceof String) {
            definition.setProviderDescription((String)ldapConfig.get("ldap.providerDescription"));
        }
        return definition;
    }
}

