/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.util;

import com.fasterxml.jackson.core.type.TypeReference;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.oauth.TokenRevokedException;
import org.cloudfoundry.identity.uaa.oauth.jwt.Jwt;
import org.cloudfoundry.identity.uaa.oauth.jwt.JwtHelper;
import org.cloudfoundry.identity.uaa.oauth.token.RevocableToken;
import org.cloudfoundry.identity.uaa.oauth.token.RevocableTokenProvisioning;
import org.cloudfoundry.identity.uaa.user.UaaUser;
import org.cloudfoundry.identity.uaa.user.UaaUserDatabase;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.cloudfoundry.identity.uaa.util.UaaStringUtils;
import org.cloudfoundry.identity.uaa.util.UaaTokenUtils;
import org.flywaydb.core.internal.util.StringUtils;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.jwt.crypto.sign.InvalidSignatureException;
import org.springframework.security.jwt.crypto.sign.SignatureVerifier;
import org.springframework.security.oauth2.common.exceptions.InsufficientScopeException;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.NoSuchClientException;
import org.springframework.util.Assert;

public class TokenValidation {
    private static final Log logger = LogFactory.getLog(TokenValidation.class);
    private final Map<String, Object> claims;
    private final Jwt tokenJwt;
    private final String token;
    private final boolean decoded;
    private final List<RuntimeException> validationErrors = new ArrayList<RuntimeException>();
    private Optional<List<String>> scopes = null;

    public static TokenValidation validate(String tokenJwtValue) {
        return new TokenValidation(tokenJwtValue);
    }

    private TokenValidation(String token) {
        String tokenJwtClaims;
        Jwt tokenJwt;
        this.token = token;
        try {
            tokenJwt = JwtHelper.decode(token);
        }
        catch (Exception ex) {
            tokenJwt = null;
            this.validationErrors.add((RuntimeException)new InvalidTokenException("Invalid token (could not decode): " + token, (Throwable)ex));
        }
        this.tokenJwt = tokenJwt;
        if (tokenJwt != null && StringUtils.hasText((String)(tokenJwtClaims = tokenJwt.getClaims()))) {
            Map claims;
            try {
                claims = (Map)JsonUtils.readValue((String)tokenJwtClaims, (TypeReference)new TypeReference<Map<String, Object>>(){});
            }
            catch (JsonUtils.JsonUtilException ex) {
                claims = null;
                this.validationErrors.add((RuntimeException)new InvalidTokenException("Invalid token (cannot read token claims): " + token, (Throwable)ex));
            }
            this.claims = claims;
        } else {
            this.claims = new HashMap<String, Object>();
        }
        this.decoded = this.isValid();
    }

    public boolean isValid() {
        return this.validationErrors.size() == 0;
    }

    public List<RuntimeException> getValidationErrors() {
        return this.validationErrors;
    }

    public TokenValidation clone() {
        return new TokenValidation(this);
    }

    private TokenValidation(TokenValidation source) {
        this.claims = source.claims == null ? null : new HashMap<String, Object>(source.claims);
        this.tokenJwt = source.tokenJwt;
        this.token = source.token;
        this.decoded = source.decoded;
        this.scopes = source.scopes;
    }

    public TokenValidation checkSignature(SignatureVerifier verifier) {
        if (!this.decoded) {
            return this;
        }
        try {
            this.tokenJwt.verifySignature(verifier);
        }
        catch (Exception ex) {
            logger.debug((Object)"Invalid token (could not verify signature)", (Throwable)ex);
            this.addError("Could not verify token signature.", (Exception)new InvalidSignatureException(this.token));
        }
        return this;
    }

    public TokenValidation checkIssuer(String issuer) {
        if (issuer == null) {
            return this;
        }
        if (!this.decoded || !this.claims.containsKey("iss")) {
            this.addError("Token does not bear an ISS claim.");
            return this;
        }
        if (!TokenValidation.equals(issuer, this.claims.get("iss"))) {
            this.addError("Invalid issuer (" + this.claims.get("iss") + ") for token did not match expected: " + issuer);
        }
        return this;
    }

    public TokenValidation checkExpiry(Instant asOf) {
        if (!this.decoded || !this.claims.containsKey("exp")) {
            this.addError("Token does not bear an EXP claim.");
            return this;
        }
        Object expClaim = this.claims.get("exp");
        try {
            long expiry = ((Integer)expClaim).intValue();
            if (asOf.getEpochSecond() > expiry) {
                this.addError("Token expired at " + expiry);
            }
        }
        catch (ClassCastException ex) {
            this.addError("Token bears an invalid or unparseable EXP claim.", ex);
        }
        return this;
    }

    public TokenValidation checkExpiry() {
        return this.checkExpiry(Instant.now());
    }

    public TokenValidation checkUser(UaaUser user) {
        return this.checkUser((String uid) -> {
            if (!TokenValidation.equals(uid, user.getId())) {
                throw new InvalidTokenException("Token does not have expected user ID.");
            }
            return user;
        });
    }

    public TokenValidation checkUser(UaaUserDatabase userDb) {
        return this.checkUser(userDb::retrieveUserById);
    }

    private TokenValidation checkUser(Function<String, UaaUser> getUser) {
        String userId;
        if (!this.decoded || !UaaTokenUtils.isUserToken(this.claims)) {
            this.addError("Token is not a user token.");
            return this;
        }
        if (!this.claims.containsKey("user_id")) {
            this.addError("Token does not bear a USER_ID claim.");
            return this;
        }
        Object userIdClaim = this.claims.get("user_id");
        try {
            userId = (String)userIdClaim;
        }
        catch (ClassCastException ex) {
            this.addError("Token bears an invalid or unparseable USER_ID claim.", ex);
            return this;
        }
        if (userId == null) {
            this.addError("Token has a null USER_ID claim.");
        } else {
            UaaUser user;
            try {
                user = getUser.apply(userId);
                Assert.notNull((Object)user);
            }
            catch (UsernameNotFoundException ex) {
                user = null;
                this.addError("Token bears a non-existent user ID: " + userId, (Exception)((Object)ex));
            }
            catch (InvalidTokenException ex) {
                user = null;
                this.validationErrors.add((RuntimeException)((Object)ex));
            }
            if (user == null) {
                this.addError("Found no data for user ID: " + userId);
            } else {
                List<? extends GrantedAuthority> authorities = user.getAuthorities();
                if (authorities == null) {
                    this.addError("Invalid token (all scopes have been revoked)");
                } else {
                    List<String> authoritiesValue = authorities.stream().map(GrantedAuthority::getAuthority).collect(Collectors.toList());
                    this.checkScopesWithin(authoritiesValue);
                }
            }
        }
        return this;
    }

    public TokenValidation checkScopesInclude(String ... scopes) {
        return this.checkScopesInclude(Arrays.asList(scopes));
    }

    public TokenValidation checkScopesInclude(Collection<String> scopes) {
        this.getScopes().ifPresent(tokenScopes -> {
            String missingScopes = scopes.stream().filter(s -> !tokenScopes.contains(s)).collect(Collectors.joining(" "));
            if (StringUtils.hasText((String)missingScopes)) {
                this.validationErrors.add((RuntimeException)new InsufficientScopeException("Some expected scopes are missing: " + missingScopes));
            }
        });
        return this;
    }

    public TokenValidation checkScopesWithin(String ... scopes) {
        return this.checkScopesWithin(Arrays.asList(scopes));
    }

    public TokenValidation checkScopesWithin(Collection<String> scopes) {
        this.getScopes().ifPresent(tokenScopes -> {
            Set scopePatterns = UaaStringUtils.constructWildcards((Collection)scopes);
            List missingScopes = tokenScopes.stream().filter(s -> !scopePatterns.stream().anyMatch(p -> p.matcher((CharSequence)s).matches())).collect(Collectors.toList());
            if (!missingScopes.isEmpty()) {
                this.validationErrors.add((RuntimeException)((Object)new InvalidTokenException("Some scopes have been revoked: " + missingScopes.stream().collect(Collectors.joining(" ")))));
            }
        });
        return this;
    }

    public TokenValidation checkClient(ClientDetails client) {
        return this.checkClient(cid -> {
            if (!TokenValidation.equals(cid, client.getClientId())) {
                throw new InvalidTokenException("Token's client ID does not match expected value: " + client.getClientId());
            }
            return client;
        });
    }

    public TokenValidation checkClient(ClientDetailsService clientDetailsService) {
        String clientId;
        if (!this.decoded || !this.claims.containsKey("cid")) {
            this.addError("Token bears no client ID.");
            return this;
        }
        if (this.claims.containsKey("client_id") && !TokenValidation.equals(this.claims.get("cid"), this.claims.get("client_id"))) {
            this.addError("Token bears conflicting client ID claims.");
            return this;
        }
        try {
            clientId = (String)this.claims.get("cid");
        }
        catch (ClassCastException ex) {
            this.addError("Token bears an invalid or unparseable CID claim.", ex);
            return this;
        }
        try {
            ClientDetails client = clientDetailsService.loadClientByClientId(clientId);
            Collection clientScopes = null == this.claims.get("user_name") ? (Collection)Optional.ofNullable(client.getAuthorities()).map(a -> a.stream().map(GrantedAuthority::getAuthority).collect(Collectors.toList())).orElse(Collections.emptyList()) : client.getScope();
            this.checkScopesWithin(clientScopes);
        }
        catch (NoSuchClientException ex) {
            this.addError("The token refers to a non-existent client: " + clientId, (Exception)((Object)ex));
        }
        catch (InvalidTokenException ex) {
            this.validationErrors.add((RuntimeException)((Object)ex));
        }
        return this;
    }

    public TokenValidation checkRevocationSignature(String currentHash) {
        String revocableHashSignature;
        if (!this.decoded) {
            this.addError("Token does not bear a revocation hash.");
            return this;
        }
        if (!this.claims.containsKey("rev_sig")) {
            return this;
        }
        try {
            revocableHashSignature = (String)this.claims.get("rev_sig");
        }
        catch (ClassCastException ex) {
            this.addError("Token bears an invalid or unparseable revocation signature.", ex);
            return this;
        }
        if (revocableHashSignature == null || !revocableHashSignature.equals(currentHash)) {
            this.validationErrors.add((RuntimeException)((Object)new TokenRevokedException(this.token)));
        }
        return this;
    }

    public TokenValidation checkAudience(String ... clients) {
        return this.checkAudience(Arrays.asList(clients));
    }

    public TokenValidation checkAudience(Collection<String> clients) {
        List<String> audience;
        if (!this.decoded || !this.claims.containsKey("aud")) {
            this.addError("The token does not bear an AUD claim.");
            return this;
        }
        Object audClaim = this.claims.get("aud");
        if (audClaim instanceof String) {
            audience = Collections.singletonList((String)audClaim);
        } else if (audClaim == null) {
            audience = Collections.emptyList();
        } else {
            try {
                audience = ((List)audClaim).stream().map(s -> (String)s).collect(Collectors.toList());
            }
            catch (ClassCastException ex) {
                this.addError("The token's audience claim is invalid or unparseable.", ex);
                return this;
            }
        }
        String notInAudience = clients.stream().filter(c -> !audience.contains(c)).collect(Collectors.joining(", "));
        if (StringUtils.hasText((String)notInAudience)) {
            this.addError("Some parties were not in the token audience: " + notInAudience);
        }
        return this;
    }

    public TokenValidation checkRevocableTokenStore(RevocableTokenProvisioning revocableTokenProvisioning) {
        block7: {
            if (!this.decoded) {
                this.addError("The token could not be checked for revocation.");
                return this;
            }
            try {
                if (!this.claims.containsKey("revocable") || !((Boolean)this.claims.get("revocable")).booleanValue()) break block7;
                String tokenId = (String)this.claims.get("jti");
                if (tokenId == null) {
                    this.addError("The token does not bear a token ID (JTI).");
                    return this;
                }
                RevocableToken revocableToken = null;
                try {
                    revocableToken = (RevocableToken)revocableTokenProvisioning.retrieve(tokenId);
                }
                catch (EmptyResultDataAccessException emptyResultDataAccessException) {
                    // empty catch block
                }
                if (revocableToken == null) {
                    this.validationErrors.add((RuntimeException)((Object)new TokenRevokedException("The token has been revoked: " + tokenId)));
                }
            }
            catch (ClassCastException ex) {
                this.addError("The token's revocability or JTI claim is invalid or unparseable.", ex);
                return this;
            }
        }
        return this;
    }

    private boolean addError(String msg, Exception cause) {
        return this.validationErrors.add((RuntimeException)((Object)new InvalidTokenException(msg, (Throwable)cause)));
    }

    private boolean addError(String msg) {
        return this.addError(msg, null);
    }

    private static boolean equals(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    private Optional<List<String>> getScopes() {
        if (this.scopes == null) {
            if (!this.decoded || !this.claims.containsKey("scope")) {
                this.addError("The token does not bear a SCOPE claim.");
                this.scopes = Optional.empty();
                return this.scopes;
            }
            ArrayList scopeClaim = this.claims.get("scope");
            if (scopeClaim == null) {
                scopeClaim = new ArrayList();
            }
            try {
                this.scopes = Optional.of(((List)scopeClaim).stream().map(s -> (String)s).collect(Collectors.toList()));
                return this.scopes;
            }
            catch (ClassCastException ex) {
                this.addError("The token's scope claim is invalid or unparseable.", ex);
                this.scopes = Optional.empty();
                return this.scopes;
            }
        }
        return this.scopes;
    }

    public TokenValidation throwIfInvalid() {
        if (!this.isValid()) {
            throw this.validationErrors.get(0);
        }
        return this;
    }

    public Jwt getJwt() {
        return this.tokenJwt;
    }

    public Map<String, Object> getClaims() {
        return this.claims;
    }
}

