/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.zone;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.cloudfoundry.identity.uaa.provider.saml.SamlKeyManagerFactory;
import org.cloudfoundry.identity.uaa.zone.BrandingInformationSource;
import org.cloudfoundry.identity.uaa.zone.IdentityZone;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneProvisioning;
import org.springframework.security.saml.key.KeyManager;

public class IdentityZoneHolder {
    private static IdentityZoneProvisioning provisioning;
    private static final ThreadLocal<IdentityZoneWithKeyManager> THREADLOCAL;
    private static final BrandingInformationSource brandingResolver;

    public static void setProvisioning(IdentityZoneProvisioning provisioning) {
        IdentityZoneHolder.provisioning = provisioning;
    }

    public static IdentityZone get() {
        return THREADLOCAL.get().getZone();
    }

    public static KeyManager getSamlSPKeyManager() {
        IdentityZoneWithKeyManager withKeyManager = THREADLOCAL.get();
        if (withKeyManager.getManager() == null) {
            KeyManager keyManager = SamlKeyManagerFactory.getKeyManager(withKeyManager.getZone().getConfig().getSamlConfig());
            if (keyManager == null) {
                keyManager = SamlKeyManagerFactory.getKeyManager(IdentityZoneHolder.getUaaZone().getConfig().getSamlConfig());
            }
            withKeyManager.setManager(keyManager);
        }
        return withKeyManager.getManager();
    }

    public static IdentityZone getUaaZone() {
        if (provisioning == null) {
            return IdentityZone.getUaa();
        }
        return provisioning.retrieve(IdentityZone.getUaa().getId());
    }

    public static void set(IdentityZone zone) {
        THREADLOCAL.set(new IdentityZoneWithKeyManager(zone, null));
    }

    public static void clear() {
        THREADLOCAL.remove();
    }

    public static boolean isUaa() {
        return THREADLOCAL.get().getZone().getId().equals(IdentityZone.getUaa().getId());
    }

    public static BrandingInformationSource resolveBranding() {
        return brandingResolver;
    }

    static {
        THREADLOCAL = new InheritableThreadLocal<IdentityZoneWithKeyManager>(){

            @Override
            protected IdentityZoneWithKeyManager initialValue() {
                if (provisioning == null) {
                    return new IdentityZoneWithKeyManager(IdentityZone.getUaa(), null);
                }
                IdentityZone zone = IdentityZoneHolder.getUaaZone();
                return new IdentityZoneWithKeyManager(zone, null);
            }
        };
        brandingResolver = new MergedZoneBrandingInformation();
    }

    private static class MergedZoneBrandingInformation
    implements BrandingInformationSource {
        private MergedZoneBrandingInformation() {
        }

        public String getCompanyName() {
            return MergedZoneBrandingInformation.resolve(BrandingInformationSource::getCompanyName);
        }

        public String getProductLogo() {
            return MergedZoneBrandingInformation.tryGet(IdentityZoneHolder.get(), BrandingInformationSource::getProductLogo).orElse(null);
        }

        public String getSquareLogo() {
            return MergedZoneBrandingInformation.resolve(BrandingInformationSource::getSquareLogo);
        }

        public String getFooterLegalText() {
            return MergedZoneBrandingInformation.resolve(BrandingInformationSource::getFooterLegalText);
        }

        public Map<String, String> getFooterLinks() {
            return MergedZoneBrandingInformation.resolve(BrandingInformationSource::getFooterLinks);
        }

        private static <T> T resolve(Function<BrandingInformationSource, T> brandingProperty) {
            return MergedZoneBrandingInformation.tryGet(IdentityZoneHolder.get(), brandingProperty).orElse(MergedZoneBrandingInformation.tryGet(IdentityZoneHolder.getUaaZone(), brandingProperty).orElse(null));
        }

        private static <T> Optional<T> tryGet(IdentityZone zone, Function<BrandingInformationSource, T> brandingProperty) {
            return Optional.ofNullable(zone.getConfig()).flatMap(c -> Optional.ofNullable(c.getBranding())).flatMap(b -> Optional.ofNullable(brandingProperty.apply((BrandingInformationSource)b)));
        }
    }

    public static class IdentityZoneWithKeyManager {
        private IdentityZone zone;
        private KeyManager manager;

        public IdentityZoneWithKeyManager(IdentityZone zone, KeyManager manager) {
            this.zone = zone;
            this.manager = manager;
        }

        public IdentityZone getZone() {
            return this.zone;
        }

        public KeyManager getManager() {
            return this.manager;
        }

        public void setManager(KeyManager manager) {
            this.manager = manager;
        }
    }

    public static class Initializer {
        public Initializer(IdentityZoneProvisioning provisioning) {
            IdentityZoneHolder.setProvisioning(provisioning);
        }
    }
}

