/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.authentication.manager;

import java.util.Calendar;
import java.util.Collections;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.authentication.AccountNotVerifiedException;
import org.cloudfoundry.identity.uaa.authentication.AuthenticationPolicyRejectionException;
import org.cloudfoundry.identity.uaa.authentication.PasswordExpiredException;
import org.cloudfoundry.identity.uaa.authentication.UaaAuthentication;
import org.cloudfoundry.identity.uaa.authentication.UaaAuthenticationDetails;
import org.cloudfoundry.identity.uaa.authentication.UaaPrincipal;
import org.cloudfoundry.identity.uaa.authentication.event.UnverifiedUserAuthenticationEvent;
import org.cloudfoundry.identity.uaa.authentication.event.UserAuthenticationFailureEvent;
import org.cloudfoundry.identity.uaa.authentication.event.UserAuthenticationSuccessEvent;
import org.cloudfoundry.identity.uaa.authentication.event.UserNotFoundEvent;
import org.cloudfoundry.identity.uaa.authentication.manager.AccountLoginPolicy;
import org.cloudfoundry.identity.uaa.authentication.manager.PermitAllAccountLoginPolicy;
import org.cloudfoundry.identity.uaa.provider.IdentityProvider;
import org.cloudfoundry.identity.uaa.provider.IdentityProviderProvisioning;
import org.cloudfoundry.identity.uaa.provider.UaaIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.user.UaaUser;
import org.cloudfoundry.identity.uaa.user.UaaUserDatabase;
import org.cloudfoundry.identity.uaa.util.ObjectUtils;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.event.AuthenticationFailureBadCredentialsEvent;
import org.springframework.security.authentication.event.AuthenticationFailureLockedEvent;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;

public class AuthzAuthenticationManager
implements AuthenticationManager,
ApplicationEventPublisherAware {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final PasswordEncoder encoder;
    private final UaaUserDatabase userDatabase;
    private ApplicationEventPublisher eventPublisher;
    private AccountLoginPolicy accountLoginPolicy = new PermitAllAccountLoginPolicy();
    private IdentityProviderProvisioning providerProvisioning;
    private String origin;
    private boolean allowUnverifiedUsers = true;

    public AuthzAuthenticationManager(UaaUserDatabase cfusers, IdentityProviderProvisioning providerProvisioning) {
        this(cfusers, (PasswordEncoder)new BCryptPasswordEncoder(), providerProvisioning);
    }

    public AuthzAuthenticationManager(UaaUserDatabase userDatabase, PasswordEncoder encoder, IdentityProviderProvisioning providerProvisioning) {
        this.userDatabase = userDatabase;
        this.encoder = encoder;
        this.providerProvisioning = providerProvisioning;
    }

    public Authentication authenticate(Authentication req) throws AuthenticationException {
        this.logger.debug((Object)("Processing authentication request for " + req.getName()));
        if (req.getCredentials() == null) {
            BadCredentialsException e = new BadCredentialsException("No password supplied");
            this.publish((ApplicationEvent)new AuthenticationFailureBadCredentialsEvent(req, (AuthenticationException)((Object)e)));
            throw e;
        }
        UaaUser user = this.getUaaUser(req);
        if (user == null) {
            this.logger.debug((Object)("No user named '" + req.getName() + "' was found for origin:" + this.origin));
            this.publish(new UserNotFoundEvent(req));
        } else {
            boolean passwordMatches;
            if (!this.accountLoginPolicy.isAllowed(user, req)) {
                this.logger.warn((Object)("Login policy rejected authentication for " + user.getUsername() + ", " + user.getId() + ". Ignoring login request."));
                AuthenticationPolicyRejectionException e = new AuthenticationPolicyRejectionException("Your account has been locked because of too many failed attempts to login.");
                this.publish((ApplicationEvent)new AuthenticationFailureLockedEvent(req, (AuthenticationException)e));
                throw e;
            }
            boolean bl = passwordMatches = ((CharSequence)req.getCredentials()).length() != 0 && this.encoder.matches((CharSequence)req.getCredentials(), user.getPassword());
            if (!passwordMatches) {
                this.logger.debug((Object)("Password did not match for user " + req.getName()));
                this.publish(new UserAuthenticationFailureEvent(user, req));
            } else {
                this.logger.debug((Object)("Password successfully matched for userId[" + user.getUsername() + "]:" + user.getId()));
                if (!(this.allowUnverifiedUsers && user.isLegacyVerificationBehavior() || user.isVerified())) {
                    this.publish(new UnverifiedUserAuthenticationEvent(user, req));
                    this.logger.debug((Object)("Account not verified: " + user.getId()));
                    throw new AccountNotVerifiedException("Account not verified");
                }
                int expiringPassword = this.getPasswordExpiresInMonths();
                if (expiringPassword > 0) {
                    Calendar cal = Calendar.getInstance();
                    cal.setTimeInMillis(user.getPasswordLastModified().getTime());
                    cal.add(2, expiringPassword);
                    if (cal.getTimeInMillis() < System.currentTimeMillis()) {
                        throw new PasswordExpiredException("Your current password has expired. Please reset your password.");
                    }
                }
                UaaAuthentication success = new UaaAuthentication(new UaaPrincipal(user), user.getAuthorities(), (UaaAuthenticationDetails)req.getDetails());
                success.setAuthenticationMethods(Collections.singleton("pwd"));
                this.publish(new UserAuthenticationSuccessEvent(user, (Authentication)success));
                return success;
            }
        }
        BadCredentialsException e = new BadCredentialsException("Bad credentials");
        this.publish((ApplicationEvent)new AuthenticationFailureBadCredentialsEvent(req, (AuthenticationException)((Object)e)));
        throw e;
    }

    protected int getPasswordExpiresInMonths() {
        UaaIdentityProviderDefinition idpDefinition;
        int result = 0;
        IdentityProvider provider = this.providerProvisioning.retrieveByOrigin("uaa", IdentityZoneHolder.get().getId());
        if (provider != null && (idpDefinition = (UaaIdentityProviderDefinition)ObjectUtils.castInstance((Object)provider.getConfig(), UaaIdentityProviderDefinition.class)) != null && null != idpDefinition.getPasswordPolicy()) {
            return idpDefinition.getPasswordPolicy().getExpirePasswordInMonths();
        }
        return result;
    }

    private UaaUser getUaaUser(Authentication req) {
        try {
            UaaUser user = this.userDatabase.retrieveUserByName(req.getName().toLowerCase(Locale.US), this.getOrigin());
            if (user != null) {
                return user;
            }
        }
        catch (UsernameNotFoundException usernameNotFoundException) {
            // empty catch block
        }
        return null;
    }

    private void publish(ApplicationEvent event) {
        if (this.eventPublisher != null) {
            this.eventPublisher.publishEvent(event);
        }
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public AccountLoginPolicy getAccountLoginPolicy() {
        return this.accountLoginPolicy;
    }

    public void setAccountLoginPolicy(AccountLoginPolicy accountLoginPolicy) {
        this.accountLoginPolicy = accountLoginPolicy;
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public void setAllowUnverifiedUsers(boolean allowUnverifiedUsers) {
        this.allowUnverifiedUsers = allowUnverifiedUsers;
    }
}

