/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.authentication.manager;

import org.cloudfoundry.identity.uaa.provider.IdentityProvider;
import org.cloudfoundry.identity.uaa.provider.IdentityProviderProvisioning;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.ProviderNotFoundException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;

public class CheckIdpEnabledAuthenticationManager
implements AuthenticationManager {
    private final String origin;
    private final IdentityProviderProvisioning identityProviderProvisioning;
    private final AuthenticationManager delegate;

    public CheckIdpEnabledAuthenticationManager(AuthenticationManager delegate, String origin, IdentityProviderProvisioning identityProviderProvisioning) {
        this.origin = origin;
        this.identityProviderProvisioning = identityProviderProvisioning;
        this.delegate = delegate;
    }

    public String getOrigin() {
        return this.origin;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        try {
            IdentityProvider idp = this.identityProviderProvisioning.retrieveByOrigin(this.getOrigin(), IdentityZoneHolder.get().getId());
            if (!idp.isActive()) {
                throw new ProviderNotFoundException("Identity Provider has been disabled by administrator.");
            }
        }
        catch (EmptyResultDataAccessException x) {
            throw new ProviderNotFoundException("Unable to find identity provider for origin:" + this.getOrigin());
        }
        return this.delegate.authenticate(authentication);
    }
}

