/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.scim.bootstrap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.scim.ScimGroup;
import org.cloudfoundry.identity.uaa.scim.ScimGroupExternalMember;
import org.cloudfoundry.identity.uaa.scim.ScimGroupExternalMembershipManager;
import org.cloudfoundry.identity.uaa.scim.ScimGroupProvisioning;
import org.cloudfoundry.identity.uaa.scim.exception.ScimResourceAlreadyExistsException;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.beans.factory.InitializingBean;

public class ScimExternalGroupBootstrap
implements InitializingBean {
    private Map<String, Map<String, List>> externalGroupMaps;
    private final ScimGroupProvisioning scimGroupProvisioning;
    private final ScimGroupExternalMembershipManager externalMembershipManager;
    private static final String GROUP_BY_NAME_AND_ZONE_FILTER = "displayName eq \"%s\" and identity_zone_id eq \"%s\"";
    private final Log logger = LogFactory.getLog(this.getClass());
    private boolean addNonExistingGroups = false;

    protected ScimGroupProvisioning getScimGroupProvisioning() {
        return this.scimGroupProvisioning;
    }

    public boolean isAddNonExistingGroups() {
        return this.addNonExistingGroups;
    }

    public void setAddNonExistingGroups(boolean addNonExistingGroups) {
        this.addNonExistingGroups = addNonExistingGroups;
    }

    public ScimExternalGroupBootstrap(ScimGroupProvisioning scimGroupProvisioning, ScimGroupExternalMembershipManager externalMembershipManager) {
        this.scimGroupProvisioning = scimGroupProvisioning;
        this.externalMembershipManager = externalMembershipManager;
    }

    public void setExternalGroupMaps(Map<String, Map<String, List>> externalGroupMaps) {
        this.externalGroupMaps = externalGroupMaps;
    }

    protected ScimGroup addGroup(String groupName) {
        ScimGroup group = new ScimGroup(null, groupName, IdentityZoneHolder.get().getId());
        try {
            return this.getScimGroupProvisioning().create(group);
        }
        catch (ScimResourceAlreadyExistsException x) {
            List groups = this.getScimGroupProvisioning().query(String.format(GROUP_BY_NAME_AND_ZONE_FILTER, groupName, IdentityZoneHolder.get().getId()));
            if (groups != null && groups.size() > 0) {
                return (ScimGroup)groups.get(0);
            }
            throw new RuntimeException("Unable to create or return group with name:" + groupName);
        }
    }

    public void afterPropertiesSet() throws Exception {
        for (String origin : this.externalGroupMaps.keySet()) {
            Map<String, List> externalGroupMappingsByOrigin = this.externalGroupMaps.get(origin);
            if (externalGroupMappingsByOrigin == null) continue;
            for (String externalGroup : externalGroupMappingsByOrigin.keySet()) {
                List internalGroups = externalGroupMappingsByOrigin.get(externalGroup);
                if (internalGroups == null) continue;
                internalGroups.removeAll(Collections.singleton(null));
                for (String internalGroup : internalGroups) {
                    List groups = this.getScimGroupProvisioning().query(String.format(GROUP_BY_NAME_AND_ZONE_FILTER, internalGroup, IdentityZoneHolder.get().getId()));
                    if (groups == null || groups.size() == 0 && this.isAddNonExistingGroups()) {
                        groups = new ArrayList();
                        groups.add(this.addGroup(internalGroup));
                    } else if (groups == null || groups.size() == 0 && !this.isAddNonExistingGroups()) continue;
                    this.addGroupMap(((ScimGroup)groups.get(0)).getId(), externalGroup, origin);
                }
            }
        }
    }

    private void addGroupMap(String groupId, String externalGroup, String origin) {
        ScimGroupExternalMember externalGroupMapping = this.externalMembershipManager.mapExternalGroup(groupId, externalGroup, origin);
        this.logger.debug((Object)("adding external group mapping: " + externalGroupMapping));
    }
}

