/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.oauth;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.cloudfoundry.identity.uaa.util.UaaStringUtils;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.common.exceptions.InvalidScopeException;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.OAuth2RequestValidator;
import org.springframework.security.oauth2.provider.TokenRequest;

public class UaaOauth2RequestValidator
implements OAuth2RequestValidator {
    private static String CLIENT_CREDENTIALS = "client_credentials";
    private ClientDetailsService clientDetailsService;

    public void setClientDetailsService(ClientDetailsService clientDetailsService) {
        this.clientDetailsService = clientDetailsService;
    }

    public void validateScope(AuthorizationRequest authorizationRequest, ClientDetails client) throws InvalidScopeException {
        if (CLIENT_CREDENTIALS.equalsIgnoreCase((String)authorizationRequest.getRequestParameters().get("grant_type"))) {
            this.validateScope(authorizationRequest.getScope(), this.getAuthorities(client.getAuthorities()), false);
        } else {
            this.validateScope(authorizationRequest.getScope(), client.getScope(), true);
        }
    }

    public void validateScope(TokenRequest tokenRequest, ClientDetails client) throws InvalidScopeException {
        if (CLIENT_CREDENTIALS.equalsIgnoreCase(tokenRequest.getGrantType())) {
            this.validateScope(tokenRequest.getScope(), this.getAuthorities(client.getAuthorities()), false);
        } else if ("user_token".equalsIgnoreCase(tokenRequest.getGrantType())) {
            client = this.clientDetailsService.loadClientByClientId((String)tokenRequest.getRequestParameters().get("client_id"));
            this.validateScope(tokenRequest.getScope(), client.getScope(), true);
        } else {
            this.validateScope(tokenRequest.getScope(), client.getScope(), true);
        }
    }

    private void validateScope(Set<String> requestScopes, Set<String> clientScopes, boolean wildCardsAllowed) {
        if (clientScopes == null || clientScopes.isEmpty()) {
            throw new InvalidScopeException("Empty scope (client has no registered scopes)");
        }
        if (wildCardsAllowed) {
            Set wildcards = UaaStringUtils.constructWildcards(clientScopes);
            for (String scope : requestScopes) {
                if (UaaStringUtils.matches((Set)wildcards, (String)scope)) continue;
                throw new InvalidScopeException("Invalid scope: " + scope, clientScopes);
            }
        } else {
            for (String scope : requestScopes) {
                if (clientScopes.contains(scope)) continue;
                throw new InvalidScopeException("Invalid scope: " + scope, clientScopes);
            }
        }
    }

    private Set<String> getAuthorities(Collection<GrantedAuthority> authorities) {
        HashSet<String> result = new HashSet<String>();
        for (GrantedAuthority authority : authorities) {
            result.add(authority.getAuthority());
        }
        return result;
    }
}

