/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.oauth.token;

import java.util.Collection;
import org.cloudfoundry.identity.uaa.oauth.UaaOauth2Authentication;
import org.cloudfoundry.identity.uaa.oauth.token.RevocableTokenProvisioning;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.common.DefaultOAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.exceptions.InvalidGrantException;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.security.oauth2.provider.OAuth2RequestFactory;
import org.springframework.security.oauth2.provider.TokenRequest;
import org.springframework.security.oauth2.provider.token.AbstractTokenGranter;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;

public class UserTokenGranter
extends AbstractTokenGranter {
    private ClientDetailsService clientDetailsService;
    private RevocableTokenProvisioning tokenStore;

    public UserTokenGranter(AuthorizationServerTokenServices tokenServices, ClientDetailsService clientDetailsService, OAuth2RequestFactory requestFactory, RevocableTokenProvisioning tokenStore) {
        super(tokenServices, clientDetailsService, requestFactory, "user_token");
        this.clientDetailsService = clientDetailsService;
        this.tokenStore = tokenStore;
    }

    public OAuth2AccessToken grant(String grantType, TokenRequest tokenRequest) {
        TokenRequest adjusted = new TokenRequest(tokenRequest.getRequestParameters(), (String)tokenRequest.getRequestParameters().get("requesting_client_id"), (Collection)tokenRequest.getScope(), tokenRequest.getGrantType());
        return super.grant(grantType, adjusted);
    }

    protected void validateGrantType(String grantType, ClientDetails clientDetails) {
    }

    protected Authentication validateRequest(TokenRequest request) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null || !authentication.isAuthenticated() || !(authentication instanceof UaaOauth2Authentication)) {
            throw new InsufficientAuthenticationException("Invalid authentication object:" + authentication);
        }
        UaaOauth2Authentication oauth2Authentication = (UaaOauth2Authentication)authentication;
        if (oauth2Authentication.getUserAuthentication() == null || !oauth2Authentication.getUserAuthentication().isAuthenticated()) {
            throw new InsufficientAuthenticationException("Authentication containing a user is required");
        }
        if (request.getRequestParameters() == null || request.getRequestParameters().get("requesting_client_id") == null) {
            throw new InvalidGrantException("Parameter requesting_client_id is required.");
        }
        if (!"user_token".equals(request.getGrantType())) {
            throw new InvalidGrantException("Invalid grant type");
        }
        ClientDetails requesting = this.clientDetailsService.loadClientByClientId((String)request.getRequestParameters().get("requesting_client_id"));
        super.validateGrantType("user_token", requesting);
        ClientDetails receiving = this.clientDetailsService.loadClientByClientId((String)request.getRequestParameters().get("client_id"));
        super.validateGrantType("refresh_token", receiving);
        return oauth2Authentication.getUserAuthentication();
    }

    protected OAuth2Authentication getOAuth2Authentication(ClientDetails client, TokenRequest tokenRequest) {
        Authentication userAuth = this.validateRequest(tokenRequest);
        OAuth2Request storedOAuth2Request = this.getRequestFactory().createOAuth2Request(client, tokenRequest);
        return new OAuth2Authentication(storedOAuth2Request, userAuth);
    }

    protected DefaultOAuth2AccessToken prepareForSerialization(DefaultOAuth2AccessToken token) {
        String id = token.getValue();
        token.setValue(null);
        token.getAdditionalInformation().put("jti", token.getRefreshToken().getValue());
        this.tokenStore.delete(id, 0);
        return token;
    }

    protected OAuth2AccessToken getAccessToken(ClientDetails client, TokenRequest tokenRequest) {
        return this.prepareForSerialization((DefaultOAuth2AccessToken)super.getAccessToken(client, tokenRequest));
    }
}

