/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider.saml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.provider.SamlIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.zone.IdentityZone;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.StringUtils;

public class BootstrapSamlIdentityProviderConfigurator
implements InitializingBean {
    private static Log logger = LogFactory.getLog(BootstrapSamlIdentityProviderConfigurator.class);
    private String legacyIdpIdentityAlias;
    private volatile String legacyIdpMetaData;
    private String legacyNameId;
    private int legacyAssertionConsumerIndex;
    private boolean legacyMetadataTrustCheck = true;
    private boolean legacyShowSamlLink = true;
    private List<SamlIdentityProviderDefinition> identityProviders = new LinkedList<SamlIdentityProviderDefinition>();
    private List<SamlIdentityProviderDefinition> toBeFetchedProviders = new LinkedList<SamlIdentityProviderDefinition>();
    private Timer dummyTimer = new Timer(){

        @Override
        public void cancel() {
            super.cancel();
        }

        @Override
        public int purge() {
            return 0;
        }

        @Override
        public void schedule(TimerTask task, long delay) {
        }

        @Override
        public void schedule(TimerTask task, long delay, long period) {
        }

        @Override
        public void schedule(TimerTask task, Date firstTime, long period) {
        }

        @Override
        public void schedule(TimerTask task, Date time) {
        }

        @Override
        public void scheduleAtFixedRate(TimerTask task, long delay, long period) {
        }

        @Override
        public void scheduleAtFixedRate(TimerTask task, Date firstTime, long period) {
        }
    };

    public BootstrapSamlIdentityProviderConfigurator() {
        this.dummyTimer.cancel();
    }

    public List<SamlIdentityProviderDefinition> getIdentityProviderDefinitions() {
        return Collections.unmodifiableList(new ArrayList<SamlIdentityProviderDefinition>(this.identityProviders));
    }

    protected void parseIdentityProviderDefinitions() {
        this.identityProviders.clear();
        if (this.getLegacyIdpMetaData() != null) {
            SamlIdentityProviderDefinition def = new SamlIdentityProviderDefinition();
            def.setMetaDataLocation(this.getLegacyIdpMetaData());
            def.setMetadataTrustCheck(this.isLegacyMetadataTrustCheck());
            def.setNameID(this.getLegacyNameId());
            def.setAssertionConsumerIndex(this.getLegacyAssertionConsumerIndex());
            String alias = this.getLegacyIdpIdentityAlias();
            if (alias == null) {
                throw new IllegalArgumentException("Invalid IDP - Alias must be not null for deprecated IDP.");
            }
            def.setIdpEntityAlias(alias);
            def.setShowSamlLink(this.isLegacyShowSamlLink());
            def.setLinkText("Use your corporate credentials");
            def.setZoneId(IdentityZone.getUaa().getId());
            this.identityProviders.add(def);
        }
        HashSet<String> uniqueAlias = new HashSet<String>();
        for (SamlIdentityProviderDefinition def : this.toBeFetchedProviders) {
            String alias = this.getUniqueAlias(def);
            if (uniqueAlias.contains(alias)) {
                throw new IllegalStateException("Duplicate IDP alias found:" + alias);
            }
            uniqueAlias.add(alias);
            this.identityProviders.add(def);
        }
    }

    protected String getUniqueAlias(SamlIdentityProviderDefinition def) {
        return def.getUniqueAlias();
    }

    public void setIdentityProviders(Map<String, Map<String, Object>> providers) {
        this.identityProviders.clear();
        this.toBeFetchedProviders.clear();
        if (providers == null) {
            return;
        }
        for (Map.Entry<String, Map<String, Object>> entry : providers.entrySet()) {
            String alias = entry.getKey();
            Map<String, Object> saml = entry.getValue();
            String metaDataLocation = (String)saml.get("idpMetadata");
            String nameID = (String)saml.get("nameID");
            Integer assertionIndex = (Integer)saml.get("assertionConsumerIndex");
            Boolean trustCheck = (Boolean)saml.get("metadataTrustCheck");
            Boolean showLink = (Boolean)entry.getValue().get("showSamlLoginLink");
            String socketFactoryClassName = (String)saml.get("socketFactoryClassName");
            String linkText = (String)entry.getValue().get("linkText");
            String iconUrl = (String)entry.getValue().get("iconUrl");
            String zoneId = (String)entry.getValue().get("zoneId");
            String groupMappingMode = (String)entry.getValue().get("groupMappingMode");
            String providerDescription = (String)entry.getValue().get("providerDescription");
            Boolean addShadowUserOnLogin = (Boolean)entry.getValue().get("addShadowUserOnLogin");
            List emailDomain = (List)saml.get("emailDomain");
            List externalGroupsWhitelist = (List)saml.get("externalGroupsWhitelist");
            Map attributeMappings = (Map)saml.get("attributeMappings");
            SamlIdentityProviderDefinition def = new SamlIdentityProviderDefinition();
            if (StringUtils.hasText((String)providerDescription)) {
                def.setProviderDescription(providerDescription);
            }
            if (alias == null) {
                throw new IllegalArgumentException("Invalid IDP - alias must not be null [" + metaDataLocation + "]");
            }
            if (metaDataLocation == null) {
                throw new IllegalArgumentException("Invalid IDP - metaDataLocation must not be null [" + alias + "]");
            }
            def.setIdpEntityAlias(alias);
            def.setAssertionConsumerIndex(assertionIndex == null ? 0 : assertionIndex);
            def.setMetaDataLocation(metaDataLocation);
            def.setNameID(nameID);
            def.setMetadataTrustCheck(trustCheck == null ? true : trustCheck);
            if (StringUtils.hasText((String)groupMappingMode)) {
                def.setGroupMappingMode(SamlIdentityProviderDefinition.ExternalGroupMappingMode.valueOf((String)groupMappingMode));
            }
            def.setShowSamlLink(showLink == null ? true : showLink);
            def.setSocketFactoryClassName(socketFactoryClassName);
            def.setLinkText(linkText);
            def.setIconUrl(iconUrl);
            def.setEmailDomain(emailDomain);
            def.setExternalGroupsWhitelist(externalGroupsWhitelist);
            def.setAttributeMappings(attributeMappings);
            def.setZoneId(StringUtils.hasText((String)zoneId) ? zoneId : IdentityZone.getUaa().getId());
            def.setAddShadowUserOnLogin(addShadowUserOnLogin == null ? true : addShadowUserOnLogin);
            this.toBeFetchedProviders.add(def);
        }
    }

    public String getLegacyIdpIdentityAlias() {
        return this.legacyIdpIdentityAlias;
    }

    public void setLegacyIdpIdentityAlias(String legacyIdpIdentityAlias) {
        this.legacyIdpIdentityAlias = "null".equals(legacyIdpIdentityAlias) ? null : legacyIdpIdentityAlias;
    }

    public String getLegacyIdpMetaData() {
        return this.legacyIdpMetaData;
    }

    public void setLegacyIdpMetaData(String legacyIdpMetaData) {
        this.legacyIdpMetaData = "null".equals(legacyIdpMetaData) ? null : legacyIdpMetaData;
    }

    public String getLegacyNameId() {
        return this.legacyNameId;
    }

    public void setLegacyNameId(String legacyNameId) {
        this.legacyNameId = legacyNameId;
    }

    public int getLegacyAssertionConsumerIndex() {
        return this.legacyAssertionConsumerIndex;
    }

    public void setLegacyAssertionConsumerIndex(int legacyAssertionConsumerIndex) {
        this.legacyAssertionConsumerIndex = legacyAssertionConsumerIndex;
    }

    public boolean isLegacyMetadataTrustCheck() {
        return this.legacyMetadataTrustCheck;
    }

    public void setLegacyMetadataTrustCheck(boolean legacyMetadataTrustCheck) {
        this.legacyMetadataTrustCheck = legacyMetadataTrustCheck;
    }

    public boolean isLegacyShowSamlLink() {
        return this.legacyShowSamlLink;
    }

    public void setLegacyShowSamlLink(boolean legacyShowSamlLink) {
        this.legacyShowSamlLink = legacyShowSamlLink;
    }

    public void afterPropertiesSet() throws Exception {
        this.parseIdentityProviderDefinitions();
    }
}

