/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider.saml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.authentication.UaaAuthentication;
import org.cloudfoundry.identity.uaa.authentication.UaaPrincipal;
import org.cloudfoundry.identity.uaa.authentication.event.UserAuthenticationSuccessEvent;
import org.cloudfoundry.identity.uaa.authentication.manager.ExternalGroupAuthorizationEvent;
import org.cloudfoundry.identity.uaa.authentication.manager.InvitedUserAuthenticatedEvent;
import org.cloudfoundry.identity.uaa.authentication.manager.NewUserAuthenticatedEvent;
import org.cloudfoundry.identity.uaa.provider.IdentityProvider;
import org.cloudfoundry.identity.uaa.provider.IdentityProviderProvisioning;
import org.cloudfoundry.identity.uaa.provider.SamlIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.saml.LoginSAMLException;
import org.cloudfoundry.identity.uaa.provider.saml.LoginSamlAuthenticationToken;
import org.cloudfoundry.identity.uaa.provider.saml.SamlUserAuthority;
import org.cloudfoundry.identity.uaa.scim.ScimGroupExternalMember;
import org.cloudfoundry.identity.uaa.scim.ScimGroupExternalMembershipManager;
import org.cloudfoundry.identity.uaa.user.UaaUser;
import org.cloudfoundry.identity.uaa.user.UaaUserDatabase;
import org.cloudfoundry.identity.uaa.user.UaaUserPrototype;
import org.cloudfoundry.identity.uaa.zone.IdentityZone;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.joda.time.DateTime;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.core.AuthnStatement;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.schema.XSAny;
import org.opensaml.xml.schema.XSBase64Binary;
import org.opensaml.xml.schema.XSBoolean;
import org.opensaml.xml.schema.XSBooleanValue;
import org.opensaml.xml.schema.XSDateTime;
import org.opensaml.xml.schema.XSInteger;
import org.opensaml.xml.schema.XSQName;
import org.opensaml.xml.schema.XSString;
import org.opensaml.xml.schema.XSURI;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.ProviderNotFoundException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.providers.ExpiringUsernameAuthenticationToken;
import org.springframework.security.saml.SAMLAuthenticationProvider;
import org.springframework.security.saml.SAMLAuthenticationToken;
import org.springframework.security.saml.SAMLCredential;
import org.springframework.security.saml.context.SAMLMessageContext;
import org.springframework.security.saml.userdetails.SAMLUserDetailsService;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

public class LoginSamlAuthenticationProvider
extends SAMLAuthenticationProvider
implements ApplicationEventPublisherAware {
    private static final Log logger = LogFactory.getLog(LoginSamlAuthenticationProvider.class);
    private UaaUserDatabase userDatabase;
    private ApplicationEventPublisher eventPublisher;
    private IdentityProviderProvisioning identityProviderProvisioning;
    private ScimGroupExternalMembershipManager externalMembershipManager;

    public void setIdentityProviderProvisioning(IdentityProviderProvisioning identityProviderProvisioning) {
        this.identityProviderProvisioning = identityProviderProvisioning;
    }

    public void setUserDatabase(UaaUserDatabase userDatabase) {
        this.userDatabase = userDatabase;
    }

    public void setExternalMembershipManager(ScimGroupExternalMembershipManager externalMembershipManager) {
        this.externalMembershipManager = externalMembershipManager;
    }

    public void setUserDetails(SAMLUserDetailsService userDetails) {
        super.setUserDetails(userDetails);
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        boolean addNew;
        SamlIdentityProviderDefinition samlConfig;
        IdentityProvider idp;
        if (!this.supports(authentication.getClass())) {
            throw new IllegalArgumentException("Only SAMLAuthenticationToken is supported, " + authentication.getClass() + " was attempted");
        }
        IdentityZone zone = IdentityZoneHolder.get();
        SAMLAuthenticationToken token = (SAMLAuthenticationToken)authentication;
        SAMLMessageContext context = token.getCredentials();
        String alias = context.getPeerExtendedMetadata().getAlias();
        try {
            idp = this.identityProviderProvisioning.retrieveByOrigin(alias, IdentityZoneHolder.get().getId());
            samlConfig = (SamlIdentityProviderDefinition)idp.getConfig();
            addNew = samlConfig.isAddShadowUserOnLogin();
            if (!idp.isActive()) {
                throw new ProviderNotFoundException("Identity Provider has been disabled by administrator for alias:" + alias);
            }
        }
        catch (EmptyResultDataAccessException x) {
            throw new ProviderNotFoundException("No SAML identity provider found in zone for alias:" + alias);
        }
        ExpiringUsernameAuthenticationToken result = this.getExpiringUsernameAuthenticationToken(authentication);
        UaaPrincipal samlPrincipal = new UaaPrincipal("NaN", result.getName(), result.getName(), alias, result.getName(), zone.getId());
        Collection<? extends GrantedAuthority> samlAuthorities = this.retrieveSamlAuthorities(samlConfig, (SAMLCredential)result.getCredentials());
        Collection<? extends GrantedAuthority> authorities = null;
        SamlIdentityProviderDefinition.ExternalGroupMappingMode groupMappingMode = ((SamlIdentityProviderDefinition)idp.getConfig()).getGroupMappingMode();
        switch (groupMappingMode) {
            case EXPLICITLY_MAPPED: {
                authorities = this.mapAuthorities(idp.getOriginKey(), samlAuthorities);
                break;
            }
            case AS_SCOPES: {
                authorities = new LinkedList<GrantedAuthority>(samlAuthorities);
            }
        }
        Set<String> filteredExternalGroups = this.filterSamlAuthorities(samlConfig, samlAuthorities);
        MultiValueMap<String, String> userAttributes = this.retrieveUserAttributes(samlConfig, (SAMLCredential)result.getCredentials());
        UaaUser user = this.createIfMissing(samlPrincipal, addNew, authorities, userAttributes);
        UaaPrincipal principal = new UaaPrincipal(user);
        return new LoginSamlAuthenticationToken(principal, result).getUaaAuthentication(user.getAuthorities(), filteredExternalGroups, userAttributes);
    }

    protected ExpiringUsernameAuthenticationToken getExpiringUsernameAuthenticationToken(Authentication authentication) {
        return (ExpiringUsernameAuthenticationToken)super.authenticate(authentication);
    }

    protected void publish(ApplicationEvent event) {
        if (this.eventPublisher != null) {
            this.eventPublisher.publishEvent(event);
        }
    }

    private Set<String> filterSamlAuthorities(SamlIdentityProviderDefinition definition, Collection<? extends GrantedAuthority> samlAuthorities) {
        List whiteList = Collections.EMPTY_LIST;
        if (definition != null && definition.getExternalGroupsWhitelist() != null) {
            whiteList = definition.getExternalGroupsWhitelist();
        }
        Set authorities = samlAuthorities.stream().map(s -> s.getAuthority()).collect(Collectors.toSet());
        return new HashSet<String>(CollectionUtils.retainAll(authorities, (Collection)whiteList));
    }

    protected Collection<? extends GrantedAuthority> mapAuthorities(String origin, Collection<? extends GrantedAuthority> authorities) {
        LinkedList<SimpleGrantedAuthority> result = new LinkedList<SimpleGrantedAuthority>();
        for (GrantedAuthority grantedAuthority : authorities) {
            String externalGroup = grantedAuthority.getAuthority();
            for (ScimGroupExternalMember internalGroup : this.externalMembershipManager.getExternalGroupMapsByExternalGroup(externalGroup, origin)) {
                result.add(new SimpleGrantedAuthority(internalGroup.getDisplayName()));
            }
        }
        return result;
    }

    public Collection<? extends GrantedAuthority> retrieveSamlAuthorities(SamlIdentityProviderDefinition definition, SAMLCredential credential) {
        ArrayList<SamlUserAuthority> authorities = new ArrayList<SamlUserAuthority>();
        if (definition.getAttributeMappings().get("external_groups") != null) {
            LinkedList<String> attributeNames = new LinkedList<String>();
            if (definition.getAttributeMappings().get("external_groups") instanceof String) {
                attributeNames.add((String)definition.getAttributeMappings().get("external_groups"));
            } else if (definition.getAttributeMappings().get("external_groups") instanceof Collection) {
                attributeNames.addAll((Collection)definition.getAttributeMappings().get("external_groups"));
            }
            for (Attribute attribute : credential.getAttributes()) {
                if (!attributeNames.contains(attribute.getName()) && !attributeNames.contains(attribute.getFriendlyName()) || attribute.getAttributeValues() == null || attribute.getAttributeValues().size() <= 0) continue;
                for (XMLObject group : attribute.getAttributeValues()) {
                    authorities.add(new SamlUserAuthority(this.getStringValue(attribute.getName(), definition, group)));
                }
            }
        }
        return authorities == null ? Collections.EMPTY_LIST : authorities;
    }

    public MultiValueMap<String, String> retrieveUserAttributes(SamlIdentityProviderDefinition definition, SAMLCredential credential) {
        logger.debug((Object)String.format("Retrieving SAML user attributes [zone:%s, origin:%s]", definition.getZoneId(), definition.getIdpEntityAlias()));
        LinkedMultiValueMap userAttributes = new LinkedMultiValueMap();
        if (definition != null && definition.getAttributeMappings() != null) {
            for (Map.Entry attributeMapping : definition.getAttributeMappings().entrySet()) {
                if (!(attributeMapping.getValue() instanceof String) || credential.getAttribute((String)attributeMapping.getValue()) == null) continue;
                String key = (String)attributeMapping.getKey();
                for (XMLObject xmlObject : credential.getAttribute((String)attributeMapping.getValue()).getAttributeValues()) {
                    String value = this.getStringValue(key, definition, xmlObject);
                    if (value == null) continue;
                    userAttributes.add((Object)key, (Object)value);
                }
            }
        }
        if (credential.getAuthenticationAssertion() != null && credential.getAuthenticationAssertion().getAuthnStatements() != null) {
            for (AuthnStatement statement : credential.getAuthenticationAssertion().getAuthnStatements()) {
                if (statement.getAuthnContext() == null || statement.getAuthnContext().getAuthnContextClassRef() == null) continue;
                userAttributes.add((Object)"acr", (Object)statement.getAuthnContext().getAuthnContextClassRef().getAuthnContextClassRef());
            }
        }
        return userAttributes;
    }

    protected String getStringValue(String key, SamlIdentityProviderDefinition definition, XMLObject xmlObject) {
        String value = null;
        if (xmlObject instanceof XSString) {
            value = ((XSString)xmlObject).getValue();
        } else if (xmlObject instanceof XSAny) {
            value = ((XSAny)xmlObject).getTextContent();
        } else if (xmlObject instanceof XSInteger) {
            Integer i = ((XSInteger)xmlObject).getValue();
            value = i != null ? i.toString() : null;
        } else if (xmlObject instanceof XSBoolean) {
            XSBooleanValue b = ((XSBoolean)xmlObject).getValue();
            value = b != null && b.getValue() != null ? b.getValue().toString() : null;
        } else if (xmlObject instanceof XSDateTime) {
            DateTime d = ((XSDateTime)xmlObject).getValue();
            value = d != null ? d.toString() : null;
        } else if (xmlObject instanceof XSQName) {
            QName name = ((XSQName)xmlObject).getValue();
            value = name != null ? name.toString() : null;
        } else if (xmlObject instanceof XSURI) {
            value = ((XSURI)xmlObject).getValue();
        } else if (xmlObject instanceof XSBase64Binary) {
            value = ((XSBase64Binary)xmlObject).getValue();
        }
        if (value != null) {
            logger.debug((Object)String.format("Found SAML user attribute %s of value %s [zone:%s, origin:%s]", key, value, definition.getZoneId(), definition.getIdpEntityAlias()));
            return value;
        }
        if (xmlObject != null) {
            logger.debug((Object)String.format("SAML user attribute %s at is not of type XSString or other recognizable type, %s [zone:%s, origin:%s]", key, xmlObject.getClass().getName(), definition.getZoneId(), definition.getIdpEntityAlias()));
        }
        return null;
    }

    protected UaaUser createIfMissing(UaaPrincipal samlPrincipal, boolean addNew, Collection<? extends GrantedAuthority> authorities, MultiValueMap<String, String> userAttributes) {
        UaaUser user = null;
        String invitedUserId = null;
        boolean is_invitation_acceptance = this.isAcceptedInvitationAuthentication();
        if (is_invitation_acceptance) {
            invitedUserId = (String)RequestContextHolder.currentRequestAttributes().getAttribute("user_id", 1);
            user = this.userDatabase.retrieveUserById(invitedUserId);
            if (userAttributes.getFirst((Object)"email") != null) {
                if (!((String)userAttributes.getFirst((Object)"email")).equalsIgnoreCase(user.getEmail())) {
                    throw new BadCredentialsException("SAML User email mismatch. Authenticated email doesn't match invited email.");
                }
            } else {
                userAttributes = new LinkedMultiValueMap(userAttributes);
                userAttributes.add((Object)"email", (Object)user.getEmail());
            }
            addNew = false;
            if (user.getUsername().equals(user.getEmail()) && !user.getUsername().equals(samlPrincipal.getName())) {
                user.setVerified(true);
                user = user.modifyUsername(samlPrincipal.getName());
            }
            this.publish(new InvitedUserAuthenticatedEvent(user));
            user = this.userDatabase.retrieveUserById(invitedUserId);
        }
        boolean userModified = false;
        UaaUser userWithSamlAttributes = this.getUser(samlPrincipal, (MultiValueMap<String, String>)userAttributes);
        try {
            if (user == null) {
                user = this.userDatabase.retrieveUserByName(samlPrincipal.getName(), samlPrincipal.getOrigin());
            }
        }
        catch (UsernameNotFoundException e) {
            UaaUser uaaUser = this.userDatabase.retrieveUserByEmail(userWithSamlAttributes.getEmail(), samlPrincipal.getOrigin());
            if (uaaUser != null) {
                user = uaaUser.modifyUsername(samlPrincipal.getName());
            }
            if (!addNew) {
                throw new LoginSAMLException("SAML user does not exist. You can correct this by creating a shadow user for the SAML user.", e);
            }
            this.publish(new NewUserAuthenticatedEvent(userWithSamlAttributes));
            try {
                user = this.userDatabase.retrieveUserByName(samlPrincipal.getName(), samlPrincipal.getOrigin());
            }
            catch (UsernameNotFoundException ex) {
                throw new BadCredentialsException("Unable to establish shadow user for SAML user:" + samlPrincipal.getName());
            }
        }
        if (this.haveUserAttributesChanged(user, userWithSamlAttributes)) {
            userModified = true;
            user = user.modifyAttributes(userWithSamlAttributes.getEmail(), userWithSamlAttributes.getGivenName(), userWithSamlAttributes.getFamilyName(), userWithSamlAttributes.getPhoneNumber());
        }
        this.publish(new ExternalGroupAuthorizationEvent(user, userModified, authorities, true));
        user = this.userDatabase.retrieveUserById(user.getId());
        UaaPrincipal result = new UaaPrincipal(user);
        UaaAuthentication success = new UaaAuthentication(result, user.getAuthorities(), null);
        this.publish(new UserAuthenticationSuccessEvent(user, (Authentication)success));
        return user;
    }

    protected boolean isAcceptedInvitationAuthentication() {
        try {
            Boolean result;
            RequestAttributes attr = RequestContextHolder.currentRequestAttributes();
            if (attr != null && (result = (Boolean)attr.getAttribute("IS_INVITE_ACCEPTANCE", 1)) != null) {
                return result;
            }
        }
        catch (IllegalStateException x) {
            logger.debug((Object)"Unable to retrieve request attributes during SAML authentication.");
        }
        return false;
    }

    protected UaaUser getUser(UaaPrincipal principal, MultiValueMap<String, String> userAttributes) {
        String name = principal.getName();
        String email = (String)userAttributes.getFirst((Object)"email");
        String givenName = (String)userAttributes.getFirst((Object)"given_name");
        String familyName = (String)userAttributes.getFirst((Object)"family_name");
        String phoneNumber = (String)userAttributes.getFirst((Object)"phone_number");
        String userId = "NaN";
        String origin = principal.getOrigin() != null ? principal.getOrigin() : "login-server";
        String zoneId = principal.getZoneId();
        if (name == null && email != null) {
            name = email;
        }
        if (name == null && "NaN".equals(userId)) {
            throw new BadCredentialsException("Cannot determine username from credentials supplied");
        }
        if (name == null) {
            name = "unknown";
        }
        if (email == null) {
            email = name.contains("@") ? (name.split("@").length == 2 && !name.startsWith("@") && !name.endsWith("@") ? name : name.replaceAll("@", "") + "@unknown.org") : name + "@unknown.org";
        }
        if (givenName == null) {
            givenName = email.split("@")[0];
        }
        if (familyName == null) {
            familyName = email.split("@")[1];
        }
        return new UaaUser(new UaaUserPrototype().withEmail(email).withGivenName(givenName).withFamilyName(familyName).withPhoneNumber(phoneNumber).withModified(new Date()).withId(userId).withUsername(name).withPassword("").withAuthorities(Collections.EMPTY_LIST).withCreated(new Date()).withOrigin(origin).withExternalId(name).withVerified(true).withZoneId(zoneId).withSalt(null).withPasswordLastModified(null));
    }

    private boolean haveUserAttributesChanged(UaaUser existingUser, UaaUser user) {
        return !StringUtils.equals((String)existingUser.getGivenName(), (String)user.getGivenName()) || !StringUtils.equals((String)existingUser.getFamilyName(), (String)user.getFamilyName()) || !StringUtils.equals((String)existingUser.getPhoneNumber(), (String)user.getPhoneNumber()) || !StringUtils.equals((String)existingUser.getEmail(), (String)user.getEmail());
    }
}

