/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.security;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.authentication.UaaPrincipal;
import org.springframework.http.MediaType;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.InternalAuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.csrf.InvalidCsrfTokenException;
import org.springframework.security.web.csrf.MissingCsrfTokenException;
import org.springframework.util.StringUtils;

public class CsrfAwareEntryPointAndDeniedHandler
implements AccessDeniedHandler,
AuthenticationEntryPoint {
    private static Log logger = LogFactory.getLog(CsrfAwareEntryPointAndDeniedHandler.class);
    private LoginUrlAuthenticationEntryPoint loginEntryPoint;
    private LoginUrlAuthenticationEntryPoint csrfEntryPoint;

    public CsrfAwareEntryPointAndDeniedHandler(String redirectCsrf, String redirectNotLoggedIn) {
        if (redirectCsrf == null || !redirectCsrf.startsWith("/")) {
            throw new NullPointerException("Invalid CSRF redirect URL, must start with '/'");
        }
        if (redirectNotLoggedIn == null || !redirectNotLoggedIn.startsWith("/")) {
            throw new NullPointerException("Invalid login redirect URL, must start with '/'");
        }
        this.loginEntryPoint = new LoginUrlAuthenticationEntryPoint(redirectNotLoggedIn);
        this.csrfEntryPoint = new LoginUrlAuthenticationEntryPoint(redirectCsrf);
    }

    protected boolean isUserLoggedIn() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        return auth != null && auth.isAuthenticated() && auth.getPrincipal() instanceof UaaPrincipal;
    }

    protected boolean wantJson(HttpServletRequest request) {
        String accept = request.getHeader("Accept");
        boolean json = false;
        if (StringUtils.hasText((String)accept)) {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)accept)) {
                if (!mediaType.equals((Object)MediaType.APPLICATION_JSON)) continue;
                json = true;
                break;
            }
        }
        return json;
    }

    protected void internalHandle(HttpServletRequest request, HttpServletResponse response, Exception exception) throws IOException, ServletException {
        Throwable authEx;
        Throwable throwable = authEx = exception instanceof AuthenticationException ? (AuthenticationException)((Object)exception) : new InternalAuthenticationServiceException("Access denied.", (Throwable)exception);
        if (this.wantJson(request)) {
            response.setStatus(403);
            response.setContentType("application/json");
            response.getWriter().append(String.format("{\"error\":\"%s\"}", exception.getMessage()));
        } else {
            LoginUrlAuthenticationEntryPoint entryPoint = this.getLoginUrlAuthenticationEntryPoint(exception);
            entryPoint.commence(request, response, (AuthenticationException)authEx);
        }
    }

    protected LoginUrlAuthenticationEntryPoint getLoginUrlAuthenticationEntryPoint(Exception exception) {
        if (exception instanceof MissingCsrfTokenException || exception instanceof InvalidCsrfTokenException) {
            return this.csrfEntryPoint;
        }
        if (this.isUserLoggedIn()) {
            logger.debug((Object)"Redirecting to CSRF endpoint based on error.", (Throwable)exception);
            return this.csrfEntryPoint;
        }
        return this.loginEntryPoint;
    }

    public void handle(HttpServletRequest request, HttpServletResponse response, AccessDeniedException accessDeniedException) throws IOException, ServletException {
        request.setAttribute("SPRING_SECURITY_403_EXCEPTION", (Object)accessDeniedException);
        this.internalHandle(request, response, (Exception)accessDeniedException);
    }

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        this.internalHandle(request, response, (Exception)((Object)authException));
    }
}

